set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857297';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      3,
      NULL,
      NULL,
      4.860988,
      3.583814,
      NULL,
      NULL,
      '432',
      '01430431',
      49.597696,
      29.874649,
      '2401412',
      1,
      0,
      2,
      2,
      '2322',
      5.049954,
      NULL,
      NULL,
      NULL,
      ' 4-29-1996',
      246,
      26.667841,
      NULL,
      0.085945,
      3,
      ' 3-23-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 1-22-1987',
      NULL,
      ' 7- 2-1985',
      1.326162,
      NULL,
      0.462382,
      0.752431,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.126042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      4,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      9.904480,
      NULL,
      0,
      0,
      NULL,
      1.654665,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      8.412215,
      3.389588,
      1.786029,
      1.163539,
      0.048415,
      NULL,
      1.410448,
      2,
      0.746985,
      1,
      2.059742,
      1,
      0,
      1,
      NULL,
      3,
      1.012331,
      1,
      1,
      0,
      9.313598,
      0,
      1,
      1.711612,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      4,
      1,
      0,
      3,
      4,
      NULL,
      1,
      3,
      0,
      1,
      0,
      5,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      3,
      3,
      3,
      2,
      1,
      1,
      1,
      NULL,
      1,
      3,
      3,
      1,
      4,
      0,
      3,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      2,
      2,
      0,
      '11- 8-1998',
      138.611263,
      ' 7-17-1984',
      34.822321,
      1,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      5,
      2,
      3.582908,
      NULL,
      NULL,
      NULL,
      0.250124,
      0.937334,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.093418,
      0,
      2.394430,
      1.729007,
      0.469474,
      0.103337,
      0.571397,
      18.055283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2,
      0,
      1,
      NULL,
      1,
      3,
      3,
      0,
      NULL,
      3,
      3,
      NULL,
      7.682721,
      2,
      1.532221,
      0,
      0,
      0.961166,
      1.945245,
      NULL,
      1.036756,
      1,
      0.921490,
      0,
      0,
      NULL,
      3.003234,
      1,
      2,
      9,
      0.829624,
      5,
      NULL,
      2,
      0.783460,
      1.889862,
      1.535100,
      0.873094,
      NULL,
      0,
      45.382142,
      0,
      0.310969,
      11,
      NULL,
      17,
      NULL,
      1,
      5,
      3,
      '04032',
      '',
      '',
      0.287052,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      2.677270,
      NULL,
      36,
      NULL,
      0.218424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.595320,
      1,
      0.403076,
      NULL,
      1,
      0.415314,
      NULL,
      0.115258,
      0,
      0.830229,
      NULL,
      NULL,
      2.485372,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.234676,
      1.372756,
      NULL,
      NULL,
      0.346381,
      NULL,
      NULL,
      1.268377,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0.812465,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.969679,
      3,
      2,
      NULL,
      0.027170,
      2,
      0.926342,
      NULL,
      NULL,
      2,
      0,
      1.699148,
      1.206413,
      2,
      NULL,
      NULL,
      1.129765,
      0.729249,
      NULL,
      1.782980,
      0.717648,
      3.485685,
      2.304728,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5.027734,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      3,
      3,
      0,
      NULL,
      NULL,
      0,
      2,
      1.546292,
      NULL,
      NULL,
      NULL,
      1.807971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.877673,
      0.646209,
      NULL,
      NULL,
      3.488542,
      1.054322,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.153827,
      1.471558,
      0,
      0,
      2,
      1,
      1.568960,
      3.410354,
      1,
      7,
      2.026131,
      NULL,
      0.900707,
      2.526999,
      2,
      1.044830,
      NULL,
      NULL,
      2.788477,
      NULL,
      NULL,
      3,
      2,
      NULL,
      2.807570,
      5.440626,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.102890,
      NULL,
      NULL,
      0,
      0.037788,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.139597,
      NULL,
      NULL,
      1.750704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.959429,
      NULL,
      NULL,
      8.727401,
      NULL,
      NULL,
      1.207344,
      0,
      NULL,
      NULL,
      0,
      2,
      1.477241,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.033738,
      1,
      1,
      0.284826,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.582333,
      NULL,
      1.131519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247548,
      154.413886,
      25.503882,
      1.373592,
      2.531604,
      0.725912,
      1,
      0.228396,
      0,
      0.514804,
      2,
      NULL,
      1.496309,
      1.275886,
      1.024471,
      NULL,
      0.511933,
      0,
      0.871203,
      NULL,
      0,
      NULL,
      1.381675,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698829,
      0.159924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.756883,
      1,
      NULL,
      0,
      NULL,
      1.898131,
      NULL,
      NULL,
      NULL,
      0.873332,
      NULL,
      0,
      NULL,
      1.293903,
      NULL,
      0.711843,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.615152,
      2.551400,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.104338,
      1.111559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      1,
      1,
      2,
      NULL,
      2,
      3.033532,
      NULL,
      3.932999,
      1.102799,
      NULL,
      NULL,
      1,
      NULL,
      0.664309,
      2,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.655732,
      0.418124,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.703196,
      NULL,
      0,
      1.393236,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.552439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070118,
      NULL,
      0.379223,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      99,
      NULL,
      3,
      3.478885,
      '40432',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.571108,
      '',
      '',
      '');
commit;
end;
/


