set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9212254';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '0430212',
      0,
      1.965487,
      2,
      0,
      '4414',
      NULL,
      0,
      NULL,
      NULL,
      ' 3-24-1976',
      16,
      NULL,
      4,
      0,
      NULL,
      ' 3-21-1975',
      NULL,
      NULL,
      68,
      3.888465,
      1,
      NULL,
      NULL,
      ' 9-28-1992',
      NULL,
      0.425543,
      3,
      3,
      0,
      2,
      2,
      1,
      NULL,
      135,
      8,
      1,
      NULL,
      9.229669,
      10.124446,
      0,
      NULL,
      1,
      NULL,
      3,
      0.986508,
      NULL,
      1,
      0,
      1.873216,
      0,
      NULL,
      1.530226,
      0,
      NULL,
      0.695234,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      0,
      2,
      5,
      NULL,
      0,
      1,
      1,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      0.153287,
      NULL,
      NULL,
      5,
      0,
      7,
      2,
      1,
      1.677948,
      NULL,
      3,
      NULL,
      2,
      1.215126,
      1,
      0.307852,
      3,
      NULL,
      0,
      1,
      1,
      2.562342,
      1,
      0,
      NULL,
      7.119381,
      NULL,
      0,
      3.600080,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1.830937,
      NULL,
      1,
      0,
      1,
      1,
      3,
      0,
      3,
      0,
      5,
      0,
      1,
      0,
      2,
      5,
      2,
      1,
      5,
      NULL,
      3,
      1,
      NULL,
      NULL,
      5,
      5,
      1,
      1,
      0,
      2,
      '10- 8-1992',
      1238.646454,
      ' 5-28-1982',
      430.243238,
      3,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      3,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      0.748665,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687996,
      0,
      2,
      1,
      1.851383,
      1.813107,
      NULL,
      NULL,
      NULL,
      0.362647,
      1,
      1.330214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.253362,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973496,
      0,
      22.867797,
      0.759616,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      2,
      3,
      1,
      3,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1.556588,
      3.094250,
      4,
      1.937394,
      NULL,
      1,
      1.529696,
      1.392857,
      0.657003,
      NULL,
      1,
      1.890235,
      NULL,
      1.117447,
      0,
      NULL,
      0.696110,
      1,
      8.478172,
      NULL,
      2.556512,
      6,
      1,
      0,
      3,
      0,
      3,
      1,
      NULL,
      1.333059,
      12.551984,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736487,
      NULL,
      '44204',
      '',
      '',
      1.438723,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      12,
      109.646846,
      64,
      2,
      16,
      NULL,
      13,
      0,
      1.410639,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994128,
      NULL,
      0,
      1,
      3,
      1.245062,
      NULL,
      NULL,
      1.480000,
      13,
      0.353152,
      0,
      NULL,
      NULL,
      1.118743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.689037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.353382,
      0.854032,
      3.330284,
      1,
      1.429879,
      0,
      2,
      2.104682,
      1.682429,
      3,
      0,
      0,
      3,
      NULL,
      0,
      3,
      3,
      0,
      1,
      0.329510,
      0,
      1.142099,
      1.745139,
      1.327942,
      3,
      2.950008,
      3.582945,
      2.211875,
      1,
      NULL,
      NULL,
      1.917399,
      NULL,
      NULL,
      2,
      1.601388,
      6,
      NULL,
      1.741135,
      NULL,
      NULL,
      NULL,
      0.989873,
      NULL,
      NULL,
      NULL,
      1.209216,
      NULL,
      NULL,
      3.002362,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.617662,
      NULL,
      NULL,
      0.273550,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.415996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.177407,
      0,
      NULL,
      NULL,
      1.508339,
      NULL,
      NULL,
      2,
      3,
      0,
      2.996820,
      3.955738,
      2.595203,
      1,
      NULL,
      6.718129,
      3,
      1.320403,
      2,
      2,
      1.445303,
      1.345949,
      1,
      3,
      2,
      0.097781,
      2.038628,
      3.095148,
      7,
      NULL,
      7.552590,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.374479,
      1,
      0.049012,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139014,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.314392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.111782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025607,
      0.699868,
      0.446963,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.918948,
      NULL,
      NULL,
      NULL,
      0.922235,
      NULL,
      NULL,
      NULL,
      1.655529,
      NULL,
      NULL,
      NULL,
      0.867094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.627856,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.390865,
      218.663710,
      288,
      NULL,
      NULL,
      NULL,
      1.407408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.806096,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      204.653233,
      NULL,
      0,
      1.422258,
      1,
      0.918746,
      1,
      0.236257,
      1,
      0.015884,
      0,
      1.656359,
      1.921908,
      1.234818,
      0.186625,
      1.543173,
      0.327444,
      0.108796,
      0,
      0.852492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.123646,
      1.244150,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885358,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280395,
      1.158529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.294164,
      NULL,
      0.212687,
      NULL,
      NULL,
      NULL,
      0.937745,
      NULL,
      0,
      NULL,
      0.250829,
      NULL,
      0.714405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      0.844269,
      0.312777,
      2.588959,
      NULL,
      1,
      NULL,
      2.681455,
      3.767556,
      0.395847,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.400050,
      1.705308,
      NULL,
      NULL,
      0.564021,
      NULL,
      0,
      0.623832,
      NULL,
      1.879633,
      0.935645,
      NULL,
      0.828452,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.866588,
      NULL,
      NULL,
      1.825974,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.178047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      4,
      7,
      1.472095,
      0,
      2.507937,
      61.274099,
      42,
      5,
      1.345999,
      1.784915,
      NULL,
      NULL,
      '',
      1.890120,
      NULL,
      NULL,
      '',
      0.302420,
      NULL,
      '',
      '');
commit;
end;
/


