set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      NULL,
      7,
      NULL,
      1,
      NULL,
      4,
      NULL,
      '2130',
      1,
      NULL,
      NULL,
      NULL,
      ' 5-22-2000',
      37,
      NULL,
      NULL,
      1,
      3.127475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-25-1978',
      2,
      0.962421,
      0,
      3.755850,
      0.742416,
      1,
      NULL,
      1.194159,
      NULL,
      NULL,
      NULL,
      NULL,
      5.697577,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.713535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      5,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1.600361,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.878334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.477851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1.431887,
      5,
      0,
      0,
      NULL,
      NULL,
      3,
      3,
      3,
      5,
      1,
      1,
      1,
      4,
      1,
      3,
      5,
      4,
      0,
      2,
      3,
      1,
      0,
      5,
      0,
      4,
      2,
      NULL,
      ' 7- 1-1997',
      NULL,
      ' 8-16-1980',
      103.085952,
      NULL,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.151443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      2.634741,
      3.461882,
      2,
      0,
      3,
      1.479260,
      NULL,
      0.112306,
      NULL,
      2.625804,
      1.686605,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154600,
      NULL,
      6,
      0,
      1,
      0.859209,
      NULL,
      NULL,
      NULL,
      0,
      5.769355,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002064,
      1.523581,
      1,
      1.708533,
      0,
      1,
      0.835771,
      NULL,
      NULL,
      0.261848,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.884262,
      3.477681,
      NULL,
      1,
      1,
      3,
      2,
      NULL,
      3,
      3,
      0,
      1,
      0,
      1.217103,
      NULL,
      2,
      0.058947,
      0,
      NULL,
      0.327729,
      1.221852,
      0.476684,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.838112,
      3.724652,
      NULL,
      0.567390,
      0.119313,
      4,
      4,
      5.636749,
      4.844704,
      4.082033,
      NULL,
      1.731098,
      0,
      0,
      0,
      NULL,
      1,
      1.490999,
      66,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      '02434',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      11.445253,
      91,
      13,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.513136,
      NULL,
      1.288378,
      NULL,
      NULL,
      NULL,
      0.497589,
      NULL,
      NULL,
      0.768476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.863631,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      6,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.778069,
      NULL,
      NULL,
      0.152123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.275701,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.943607,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.250119,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.657196,
      NULL,
      NULL,
      0.540445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785859,
      NULL,
      NULL,
      0.862325,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      4.883837,
      4.897447,
      2,
      3.075513,
      5.891299,
      4.039615,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.489116,
      3.930098,
      0,
      2.807027,
      2,
      1.273075,
      NULL,
      1,
      1,
      2,
      NULL,
      0.236624,
      2.179996,
      NULL,
      0,
      0.547476,
      3.303135,
      1,
      2,
      0.115004,
      3.695495,
      2.072301,
      3,
      4.823762,
      1,
      NULL,
      2,
      3,
      0,
      0.619580,
      NULL,
      1.349043,
      0.561980,
      1.286502,
      3.587037,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.811142,
      NULL,
      NULL,
      0.172704,
      2.794468,
      NULL,
      0,
      1.564472,
      3,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      80.545576,
      153,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.765322,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.017530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449735,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.668167,
      NULL,
      NULL,
      0.738169,
      0,
      NULL,
      NULL,
      1.427160,
      0.549952,
      NULL,
      NULL,
      1,
      0.438067,
      NULL,
      NULL,
      2.834313,
      2,
      NULL,
      NULL,
      0.994027,
      0,
      NULL,
      NULL,
      NULL,
      0.797643,
      NULL,
      NULL,
      0.071746,
      0,
      NULL,
      NULL,
      3.254645,
      8.709248,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.394180,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.930297,
      0,
      1.150254,
      1,
      NULL,
      NULL,
      0.071093,
      NULL,
      0.734335,
      NULL,
      0.588215,
      0,
      NULL,
      1.639391,
      0,
      0.446042,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      9.089246,
      3.488955,
      0.559960,
      NULL,
      1,
      4.417967,
      3.689582,
      0,
      0,
      1,
      1.695884,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.725120,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.278597,
      NULL,
      0,
      NULL,
      NULL,
      0.680441,
      0.869103,
      NULL,
      2.808610,
      1,
      NULL,
      NULL,
      NULL,
      0.454058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.007137,
      3,
      NULL,
      2.567875,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.774381,
      NULL,
      2.467429,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      6,
      0,
      NULL,
      NULL,
      9,
      81.703809,
      2,
      4,
      2,
      '12314',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


