set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      NULL,
      0.933772,
      0.284661,
      1,
      NULL,
      '1140',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-14-1979',
      42,
      NULL,
      5,
      3,
      3,
      ' 2-29-1987',
      4.368231,
      NULL,
      114,
      19,
      2,
      '11-15-1983',
      ' 0-12-1976',
      ' 1-12-1978',
      3,
      1.698578,
      0.850490,
      1,
      0.672796,
      3.403649,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      6.997592,
      23,
      9,
      0,
      7,
      1,
      2,
      NULL,
      0.979072,
      0,
      0,
      NULL,
      0.019063,
      1,
      0,
      NULL,
      1.521607,
      0.458095,
      0,
      0,
      4,
      4,
      1.562357,
      2,
      0,
      1,
      0,
      NULL,
      2,
      1,
      NULL,
      0,
      0,
      1,
      0,
      5.791729,
      0,
      0,
      1,
      0,
      1.706802,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      1.239691,
      2,
      3,
      1.176176,
      0.178349,
      1.305671,
      2.071515,
      1.925284,
      0,
      2.997246,
      0.770772,
      1.682652,
      1.000750,
      0,
      0,
      1,
      8.835329,
      0,
      0,
      0.810488,
      1.677431,
      NULL,
      NULL,
      0.223092,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      1,
      NULL,
      1,
      1,
      0,
      2,
      0,
      0,
      0,
      0.299171,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1.826391,
      0,
      0,
      0,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      2,
      2,
      1,
      1,
      0,
      2,
      4,
      NULL,
      5,
      2,
      2,
      1,
      1,
      NULL,
      3,
      NULL,
      1,
      1.471536,
      ' 1- 5-1985',
      15.285465,
      '10-27-1975',
      25.160362,
      0,
      2,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.521942,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.855167,
      3,
      NULL,
      2.283300,
      NULL,
      4.146977,
      0.980604,
      1,
      5,
      1,
      5,
      1,
      2,
      5.750633,
      0,
      1.945047,
      3.641041,
      0.568568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2.208228,
      0.908356,
      1,
      1.821807,
      2,
      83.057295,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.499574,
      1.188391,
      NULL,
      3,
      0,
      1,
      2,
      1,
      0,
      1,
      0,
      2,
      0.776126,
      2,
      5.504402,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      0.351497,
      1.862193,
      1.145087,
      1.676219,
      0,
      3,
      3,
      1,
      8.500310,
      4.815771,
      3,
      6.101910,
      7.579354,
      2,
      NULL,
      1.587098,
      NULL,
      NULL,
      2.764181,
      2.501526,
      52.049779,
      0,
      0,
      NULL,
      11,
      NULL,
      72,
      1,
      0,
      0.005056,
      '40314',
      '',
      '',
      1,
      '',
      '',
      '',
      0.475473,
      '',
      '',
      '',
      3.741857,
      36,
      NULL,
      0,
      0.177840,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.187146,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.193181,
      NULL,
      NULL,
      0.950062,
      NULL,
      NULL,
      0.134989,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.751053,
      NULL,
      NULL,
      0.478244,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.250206,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.711788,
      NULL,
      NULL,
      0.948742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565229,
      NULL,
      NULL,
      1.898752,
      NULL,
      NULL,
      1.423364,
      NULL,
      NULL,
      0.409740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.645666,
      NULL,
      NULL,
      1.144352,
      3.223179,
      NULL,
      2.847132,
      NULL,
      NULL,
      0.062360,
      NULL,
      NULL,
      1.400221,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.856222,
      NULL,
      NULL,
      0.746251,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.466461,
      NULL,
      NULL,
      4,
      2,
      NULL,
      0.606504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.097318,
      1,
      3,
      3,
      NULL,
      0.596130,
      NULL,
      NULL,
      NULL,
      1.558168,
      NULL,
      3,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.696883,
      1.290736,
      1,
      0,
      0.164681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.410337,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.497392,
      0.500896,
      1.426288,
      1.065199,
      1.578788,
      NULL,
      NULL,
      0.187817,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.752587,
      NULL,
      0.509869,
      66.520003,
      0,
      NULL,
      0.240195,
      NULL,
      0,
      0,
      NULL,
      1,
      1.255410,
      0.018610,
      0,
      1,
      1.307177,
      0,
      1,
      0.890916,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.875518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      5,
      NULL,
      3,
      NULL,
      3,
      1.508470,
      3,
      1.627241,
      NULL,
      NULL,
      0.194032,
      1,
      0,
      1,
      2.797336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.006518,
      1.676681,
      0.443678,
      3.407179,
      0,
      0.807943,
      1.796807,
      NULL,
      0.622875,
      1.260150,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314598,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.482744,
      0,
      1,
      0.634145,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      12,
      82.011799,
      3,
      1.835460,
      2.868748,
      '44204',
      '',
      NULL,
      1.418949,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '');
commit;
end;
/


