set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8010848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '4401323',
      0.916016,
      NULL,
      3,
      1,
      '1022',
      2.018637,
      3.583109,
      1.691505,
      25,
      ' 9-29-2000',
      71.986599,
      NULL,
      NULL,
      NULL,
      0,
      ' 7-28-2001',
      39,
      NULL,
      367,
      NULL,
      3,
      NULL,
      NULL,
      ' 9-18-1976',
      2.899178,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1.909985,
      93,
      NULL,
      3.928561,
      NULL,
      25,
      3.865763,
      5,
      14.607753,
      2,
      1,
      2.208106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      4,
      2.450211,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      5,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.224025,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      3,
      2,
      1,
      1,
      1,
      0,
      0,
      2,
      0,
      1,
      NULL,
      5,
      5,
      0,
      1,
      1,
      3,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.509689,
      1,
      1.207599,
      1.990974,
      0,
      0.055575,
      NULL,
      NULL,
      NULL,
      0,
      1.137542,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.878434,
      0,
      0.401740,
      NULL,
      0.766269,
      0.461481,
      NULL,
      NULL,
      NULL,
      3,
      0.463110,
      0.566991,
      3,
      NULL,
      0,
      3,
      1,
      NULL,
      2,
      0,
      3,
      3,
      3.643116,
      NULL,
      2.822765,
      5,
      0,
      0,
      2,
      1.001270,
      0.089971,
      0.230087,
      NULL,
      0.234470,
      0,
      1,
      1,
      NULL,
      1,
      1.385380,
      NULL,
      5,
      3.082987,
      1,
      8.152465,
      5,
      6,
      3,
      2.223375,
      2.108605,
      NULL,
      2.878440,
      NULL,
      9,
      1,
      1,
      59,
      NULL,
      NULL,
      NULL,
      5,
      1.726982,
      5,
      '34003',
      '41423',
      '43233',
      1,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      3.888662,
      NULL,
      283,
      NULL,
      3.757345,
      16,
      30.983032,
      24,
      4,
      3.714289,
      NULL,
      3,
      0.178764,
      NULL,
      NULL,
      0.857282,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      0.028665,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.407325,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.570134,
      NULL,
      NULL,
      8,
      1.008476,
      3,
      0,
      1.035982,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.215862,
      2.491274,
      1,
      0,
      0.798209,
      1.252410,
      1.764554,
      NULL,
      NULL,
      1.292326,
      1,
      NULL,
      1.424422,
      1.632172,
      2.189182,
      0,
      1.695668,
      1.088599,
      1.634079,
      1.531807,
      0,
      0,
      1.004678,
      NULL,
      0.811176,
      1,
      1,
      0.809728,
      0,
      NULL,
      NULL,
      2.224636,
      0,
      1,
      6,
      2.891123,
      1,
      0,
      1.330394,
      NULL,
      NULL,
      NULL,
      1.089972,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.499731,
      1.408212,
      0,
      0.623235,
      0.637157,
      3,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      0.487030,
      NULL,
      NULL,
      0.604436,
      NULL,
      NULL,
      1.557976,
      NULL,
      NULL,
      3.216047,
      2,
      1,
      0,
      0,
      0.491831,
      2.152775,
      0.310879,
      0,
      0,
      16,
      NULL,
      2,
      NULL,
      0,
      4.360709,
      8,
      1.833382,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      4,
      4.656287,
      4,
      1.473320,
      5.910113,
      NULL,
      5,
      6.576222,
      2.561798,
      0,
      NULL,
      1.118250,
      3.091861,
      NULL,
      1,
      1.078239,
      0.797025,
      NULL,
      1.681418,
      NULL,
      4,
      0.561993,
      0.408816,
      3.445806,
      3,
      3.761944,
      3,
      NULL,
      NULL,
      NULL,
      3.215542,
      1.253130,
      3.509869,
      NULL,
      NULL,
      7,
      3.060366,
      2.791467,
      2.347596,
      3,
      2,
      2,
      1,
      0,
      1,
      1,
      1.662537,
      3,
      NULL,
      NULL,
      0.114315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.739371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665340,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.149757,
      NULL,
      NULL,
      3.831458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498699,
      0.776913,
      NULL,
      NULL,
      0.557926,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1942,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.931029,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.870794,
      2.481313,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.940536,
      1.520366,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.369551,
      0,
      NULL,
      NULL,
      4.977404,
      18.554260,
      NULL,
      NULL,
      18.489936,
      17,
      NULL,
      NULL,
      1.798184,
      1.096994,
      NULL,
      NULL,
      9.775292,
      8,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      3,
      1.165341,
      NULL,
      NULL,
      0,
      12,
      NULL,
      NULL,
      9,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      131.382451,
      NULL,
      0,
      NULL,
      NULL,
      1.815725,
      NULL,
      NULL,
      1.773906,
      NULL,
      NULL,
      3.641639,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2.910523,
      0.313914,
      1.186000,
      222.645783,
      5.239616,
      1,
      3.327536,
      0,
      3,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1.085915,
      0,
      1.378409,
      0,
      0,
      1,
      2.724588,
      NULL,
      3.899467,
      NULL,
      0.650375,
      NULL,
      1.443060,
      NULL,
      3.792192,
      NULL,
      0.511000,
      NULL,
      0,
      NULL,
      3.407820,
      23.661251,
      67.502363,
      1,
      NULL,
      NULL,
      NULL,
      0.718357,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.569041,
      NULL,
      0.617718,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.906839,
      NULL,
      1.356045,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733780,
      NULL,
      NULL,
      1.256003,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.056164,
      NULL,
      NULL,
      NULL,
      0,
      1.734039,
      0.981871,
      NULL,
      0.049542,
      NULL,
      0.028055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.559487,
      NULL,
      0.812114,
      NULL,
      0.564793,
      0.263160,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964584,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373890,
      NULL,
      3.863657,
      NULL,
      0,
      NULL,
      3,
      NULL,
      339.300881,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.443901,
      NULL,
      0,
      14,
      45,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      2.990196,
      2.383784,
      1.642598,
      1,
      0,
      0,
      0,
      NULL,
      0.655376,
      0,
      0,
      0.021580,
      1.802560,
      NULL,
      NULL,
      1.712512,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715925,
      NULL,
      0,
      1.411174,
      1.263385,
      0,
      1.631841,
      NULL,
      0.766296,
      NULL,
      1.445037,
      3.699495,
      NULL,
      0,
      0.194550,
      0,
      3.213003,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472996,
      NULL,
      1.423108,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309491,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.645066,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      34.667195,
      0.539112,
      NULL,
      1.915184,
      1.298289,
      NULL,
      0.971204,
      0.184413,
      0.637746,
      NULL,
      5,
      NULL,
      2.495725,
      0,
      NULL,
      71.454332,
      42.002479,
      3,
      1,
      NULL,
      '01432',
      '30241',
      '30232',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


