set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      2,
      0.680639,
      NULL,
      1,
      '3443',
      1,
      1,
      NULL,
      NULL,
      ' 8- 0-1974',
      63,
      NULL,
      2,
      2.611175,
      NULL,
      ' 7-20-1991',
      44.523214,
      NULL,
      43.803161,
      136.956679,
      2,
      ' 7-14-1991',
      ' 1-27-2001',
      ' 3-19-1997',
      0.269686,
      1.908782,
      2.126042,
      2,
      1,
      2.278601,
      8,
      0.517231,
      0.972669,
      1,
      3,
      11.938545,
      10,
      NULL,
      0,
      4,
      6.727509,
      NULL,
      3,
      1.984179,
      0.864711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      1,
      4,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      2,
      4,
      1,
      2.255453,
      0,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0,
      1.453245,
      1.005785,
      1.484734,
      0.525867,
      NULL,
      NULL,
      NULL,
      3.478638,
      0.785262,
      NULL,
      1,
      1,
      NULL,
      0.718729,
      NULL,
      1,
      3.641970,
      NULL,
      0,
      1,
      3,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      NULL,
      1,
      0,
      0,
      5,
      NULL,
      1,
      0,
      3.934358,
      0,
      NULL,
      0,
      NULL,
      1.459613,
      NULL,
      0.184493,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3,
      5,
      0,
      NULL,
      4,
      3,
      1,
      2,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '10-11-1999',
      112.275350,
      ' 1- 0-1999',
      27,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      1,
      0,
      0.014269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2.229552,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      0.683912,
      1,
      2,
      0,
      NULL,
      5.769800,
      1.832822,
      3,
      1.019868,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.941325,
      0.528033,
      0,
      0.198028,
      NULL,
      101,
      2.710770,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      0,
      NULL,
      0,
      0,
      0,
      2,
      0,
      3,
      NULL,
      0,
      0,
      0,
      2.934918,
      7.857045,
      1.562782,
      0.813015,
      1.377871,
      1,
      NULL,
      0.226178,
      1.198403,
      0,
      4.500005,
      0,
      1,
      1,
      0,
      2,
      0,
      11,
      NULL,
      0.923432,
      8.012478,
      4,
      2,
      4.496989,
      0,
      0,
      0,
      0,
      0.961993,
      NULL,
      0,
      0.678292,
      NULL,
      8,
      53,
      29.051599,
      NULL,
      1,
      0.942121,
      '44213',
      '34233',
      '24421',
      1,
      NULL,
      '',
      '',
      0.503457,
      '',
      '',
      '',
      NULL,
      24,
      NULL,
      NULL,
      3.161408,
      16,
      4,
      NULL,
      0,
      0.631618,
      2.242797,
      1,
      0.269237,
      NULL,
      NULL,
      2,
      2,
      0,
      1.881123,
      NULL,
      NULL,
      2.328728,
      0.396232,
      0.168535,
      0.534649,
      NULL,
      NULL,
      1.863101,
      NULL,
      NULL,
      1.504002,
      NULL,
      NULL,
      1.937511,
      3.789070,
      3.300968,
      3.736912,
      0.624632,
      NULL,
      2,
      1,
      3.663411,
      1,
      2,
      0.962530,
      6,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.003189,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1.681172,
      3,
      0.499423,
      3.172571,
      2,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      3,
      0,
      1.454139,
      NULL,
      0.513357,
      1,
      0,
      1.308160,
      0.306261,
      2,
      1,
      NULL,
      3.607076,
      0,
      1.645369,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.460923,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906978,
      0.196189,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.235787,
      NULL,
      NULL,
      0.175029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.504302,
      NULL,
      NULL,
      0.634361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.371173,
      1.728191,
      1.796173,
      0.814529,
      NULL,
      NULL,
      0.797088,
      NULL,
      NULL,
      2,
      5.725759,
      2,
      0,
      NULL,
      NULL,
      1,
      1.304466,
      0.110426,
      0,
      NULL,
      2.404153,
      NULL,
      2,
      3,
      3.867313,
      1,
      2.326681,
      2,
      3,
      2,
      NULL,
      1,
      2,
      2.140568,
      NULL,
      1.043358,
      3,
      3.215757,
      1,
      9.755557,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      0.184733,
      0,
      0,
      1.957561,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.282333,
      NULL,
      NULL,
      0.413926,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.907535,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301444,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      3,
      1.231771,
      NULL,
      NULL,
      0.753695,
      NULL,
      NULL,
      NULL,
      1.293099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.343827,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.298655,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455629,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402972,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174433,
      3.134543,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.548162,
      0.079717,
      NULL,
      NULL,
      NULL,
      1.308096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      323,
      30.468443,
      0,
      2,
      1,
      NULL,
      0,
      1,
      0.691159,
      3.315403,
      0,
      3,
      0.885769,
      3.578442,
      1,
      0.803680,
      NULL,
      1,
      1.840543,
      2,
      NULL,
      NULL,
      NULL,
      1.342548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.591581,
      NULL,
      0,
      NULL,
      91,
      38.660337,
      47,
      1.096949,
      2,
      1.198985,
      NULL,
      3.263229,
      NULL,
      NULL,
      NULL,
      1.798354,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.164598,
      NULL,
      1.424743,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.027693,
      NULL,
      1,
      NULL,
      1,
      1.124726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286730,
      1.519449,
      NULL,
      3.032890,
      NULL,
      2,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      1.610900,
      NULL,
      0.104559,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      92,
      NULL,
      NULL,
      NULL,
      1.650643,
      NULL,
      NULL,
      NULL,
      0.222915,
      0,
      1.337268,
      NULL,
      2.065779,
      NULL,
      2,
      NULL,
      138.059902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314158,
      2.207912,
      NULL,
      0.857484,
      NULL,
      0.906712,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263133,
      2,
      NULL,
      0.227206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.710072,
      1.701173,
      0,
      38.256357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      7.546613,
      0.304398,
      1.888118,
      2.716619,
      0,
      10,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.900522,
      0,
      NULL,
      1,
      1.876642,
      NULL,
      0,
      0,
      NULL,
      1.278017,
      0.539807,
      NULL,
      2.977337,
      2.653334,
      NULL,
      0,
      1.641193,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.311119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.325081,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.145032,
      NULL,
      0,
      NULL,
      2.413522,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.491330,
      NULL,
      0.520189,
      NULL,
      64.623892,
      0,
      NULL,
      1.610091,
      NULL,
      3.441418,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.635910,
      NULL,
      NULL,
      72,
      4,
      2,
      NULL,
      3,
      '43041',
      '31134',
      '02411',
      1.315659,
      '',
      '',
      '',
      1.510470,
      '',
      '',
      '');
commit;
end;
/


