set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8807779';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '0002442',
      3.020056,
      0.248220,
      0,
      3,
      NULL,
      NULL,
      0.706973,
      NULL,
      NULL,
      ' 7-25-2003',
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      50.052165,
      3,
      32,
      21.633828,
      2,
      ' 9- 6-1991',
      '11-18-1983',
      ' 5- 9-2003',
      0.100764,
      0,
      1,
      0,
      0,
      0.445455,
      1,
      NULL,
      NULL,
      300,
      0,
      15.358707,
      NULL,
      123.238659,
      NULL,
      NULL,
      10.116143,
      2,
      0,
      3.694028,
      1.231507,
      NULL,
      0,
      1,
      NULL,
      0.336379,
      NULL,
      1.228074,
      0.848672,
      0.845210,
      1,
      0,
      2,
      6,
      3,
      2,
      1,
      0,
      1,
      2,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      6.490873,
      1,
      2,
      1,
      0,
      0.406242,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1,
      0.498643,
      1.872458,
      0.022383,
      1.954000,
      1,
      0,
      1,
      0.075435,
      1.308336,
      0,
      1.491311,
      NULL,
      1,
      NULL,
      0.812991,
      1,
      0,
      0,
      NULL,
      5,
      2,
      1,
      NULL,
      0.461156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      0,
      2,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      0.611606,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      4,
      3,
      0,
      5,
      0,
      5,
      4,
      4,
      2,
      4,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1656.394085,
      ' 5-12-1999',
      1526.852553,
      0.142988,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.451814,
      11,
      6,
      NULL,
      0.784798,
      6.938244,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.498118,
      1,
      1,
      NULL,
      0.672696,
      1,
      2,
      29,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      12,
      2,
      17,
      NULL,
      0.399337,
      2,
      '02323',
      '',
      '',
      0,
      '',
      '',
      '',
      1.535548,
      '',
      '',
      '',
      0,
      NULL,
      392,
      11.161922,
      0.289012,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.647524,
      1.043086,
      6.208498,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      0.779581,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      NULL,
      1.830768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      8,
      2.858973,
      19.597120,
      5.303917,
      NULL,
      NULL,
      13,
      0,
      0.636400,
      0.122588,
      1.871420,
      1.742724,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1.171271,
      0,
      NULL,
      1,
      1.680974,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.158849,
      NULL,
      NULL,
      2.565415,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.585005,
      NULL,
      NULL,
      NULL,
      3,
      0,
      15,
      3.938496,
      NULL,
      NULL,
      0.429853,
      14.839148,
      14,
      NULL,
      NULL,
      NULL,
      6,
      1.823337,
      NULL,
      2.592433,
      4.672443,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.490632,
      0.115817,
      0.345528,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.076247,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.660928,
      14.286209,
      4.803652,
      1.367862,
      NULL,
      NULL,
      6,
      1,
      0,
      3,
      5,
      7.297353,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      3.186514,
      NULL,
      NULL,
      0.972168,
      9.688481,
      15,
      NULL,
      1,
      19,
      0,
      NULL,
      NULL,
      3.204252,
      2.279423,
      1.774552,
      NULL,
      4.709980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.221653,
      0.415340,
      0,
      NULL,
      0.667238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.710063,
      NULL,
      NULL,
      0.662486,
      NULL,
      NULL,
      1.101289,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.559613,
      NULL,
      NULL,
      0,
      0,
      0,
      0.191733,
      0.288820,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974772,
      NULL,
      NULL,
      NULL,
      1.949610,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.097817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921414,
      NULL,
      NULL,
      NULL,
      0.706015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049945,
      NULL,
      NULL,
      1.636658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526678,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      10505.814725,
      153,
      0,
      0,
      0,
      1.847786,
      1.688672,
      1,
      0.831418,
      1.587933,
      0.085276,
      NULL,
      1.929125,
      0,
      0,
      0,
      0,
      0,
      1,
      0.409318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.627907,
      NULL,
      0,
      0.536311,
      NULL,
      NULL,
      18.196186,
      15.088902,
      NULL,
      1.565785,
      NULL,
      NULL,
      2.559149,
      9.454631,
      NULL,
      9.132312,
      11,
      NULL,
      13.482397,
      5,
      NULL,
      4.923475,
      18,
      NULL,
      3.117159,
      11.903006,
      NULL,
      2,
      9.515595,
      NULL,
      9.729508,
      2.355000,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.054740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139210,
      NULL,
      NULL,
      NULL,
      0.050936,
      NULL,
      0,
      2,
      0,
      1.144058,
      2,
      0,
      11.065379,
      55,
      1,
      0,
      2.193084,
      '43433',
      '',
      '',
      1.430101,
      '',
      NULL,
      '',
      1.428913,
      '',
      '',
      '');
commit;
end;
/


