set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '0421022',
      1.902853,
      NULL,
      1,
      2,
      '1112',
      3,
      1.430644,
      NULL,
      NULL,
      NULL,
      13.829041,
      NULL,
      NULL,
      2,
      0,
      ' 2- 3-1980',
      8.203533,
      NULL,
      133.287027,
      NULL,
      0,
      '10- 4-1982',
      ' 4- 0-1987',
      ' 0- 6-1984',
      3.193888,
      3,
      1,
      0.375737,
      0.743552,
      0.607164,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.023390,
      8.869111,
      8.527551,
      3.799239,
      5,
      13,
      5,
      1,
      4,
      NULL,
      2,
      0,
      0,
      0,
      0,
      1.166929,
      0.838137,
      1,
      1,
      1.073251,
      0,
      0,
      1,
      3,
      1,
      0,
      0,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1.245040,
      0,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.487050,
      1,
      0.210694,
      1.651592,
      NULL,
      NULL,
      1,
      2.173420,
      1,
      1,
      0.456533,
      2,
      0.267544,
      3.734548,
      0,
      NULL,
      2,
      NULL,
      1,
      0,
      2,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.555862,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      3,
      0,
      3.333964,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      4,
      4,
      3,
      NULL,
      3,
      0,
      3,
      3,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      15,
      0,
      3.967959,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.237140,
      1,
      1,
      1.676359,
      2.872311,
      1,
      5,
      3.434323,
      NULL,
      NULL,
      NULL,
      1.045329,
      5,
      1.725444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147378,
      NULL,
      1,
      1,
      1,
      1.297476,
      2,
      NULL,
      1.358759,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.281678,
      2,
      1,
      0,
      3,
      1,
      NULL,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      2,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.698291,
      NULL,
      1,
      0.558063,
      3.699148,
      0,
      11,
      NULL,
      3,
      2.425943,
      5,
      7,
      5,
      1,
      NULL,
      1,
      3,
      3.501889,
      3,
      0,
      1.414015,
      NULL,
      55,
      44,
      121.062218,
      5,
      1.390722,
      NULL,
      '',
      NULL,
      '',
      2.077938,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      2,
      20,
      NULL,
      6.410324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953776,
      NULL,
      NULL,
      0.220602,
      NULL,
      NULL,
      1.709791,
      NULL,
      NULL,
      1.357939,
      NULL,
      NULL,
      0,
      3.402602,
      NULL,
      0.268549,
      NULL,
      NULL,
      1.019903,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839008,
      1.676543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.563685,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.932132,
      NULL,
      NULL,
      NULL,
      3.084680,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.373066,
      NULL,
      NULL,
      1,
      0,
      0,
      1.954218,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      1,
      1.783307,
      2.421829,
      3,
      NULL,
      3.717995,
      0.325269,
      NULL,
      NULL,
      1.774362,
      NULL,
      NULL,
      1.746948,
      0,
      1,
      3.386544,
      1,
      1.640767,
      0,
      1.033393,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.545000,
      NULL,
      NULL,
      1.036983,
      NULL,
      NULL,
      0.040063,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      4,
      5.793274,
      0.960832,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.770073,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.506773,
      NULL,
      NULL,
      0.376615,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.650339,
      NULL,
      NULL,
      0.761008,
      2,
      3,
      1.972459,
      NULL,
      NULL,
      3.547365,
      1,
      0,
      2,
      0,
      1.182576,
      0,
      1,
      NULL,
      NULL,
      1.809656,
      1.366290,
      NULL,
      3.209827,
      NULL,
      1.458944,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.325241,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.097196,
      2.524589,
      0.330733,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.496861,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.099202,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836955,
      NULL,
      7,
      4,
      1.139653,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.929977,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      13820.321837,
      1592.458103,
      0.745082,
      2.498211,
      0.797554,
      2.699009,
      0.685524,
      1,
      1.902321,
      0.375736,
      0.204240,
      2.933814,
      0.623476,
      NULL,
      1.094494,
      1,
      1,
      NULL,
      0.898493,
      1.836007,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.033101,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      129.710102,
      NULL,
      3,
      0,
      16,
      1,
      1,
      NULL,
      NULL,
      0.684670,
      NULL,
      NULL,
      NULL,
      2.313305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.393303,
      NULL,
      0.216292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.750347,
      NULL,
      NULL,
      2.695415,
      NULL,
      2,
      NULL,
      3.919247,
      NULL,
      2,
      NULL,
      178,
      NULL,
      1.091721,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.290906,
      NULL,
      1.999002,
      NULL,
      1.820180,
      NULL,
      270.575875,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.520724,
      NULL,
      1.068703,
      1.680859,
      2.555397,
      NULL,
      0,
      NULL,
      2.854152,
      NULL,
      1.336426,
      NULL,
      0,
      NULL,
      1.304053,
      NULL,
      1.835210,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3.065948,
      NULL,
      0.776849,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.354150,
      NULL,
      0,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612348,
      1,
      NULL,
      1,
      NULL,
      0.600868,
      NULL,
      105.317286,
      NULL,
      2,
      3,
      2.994804,
      1,
      NULL,
      0.587337,
      3.534840,
      NULL,
      164.689179,
      1,
      1.023666,
      0,
      3.264505,
      0.324024,
      0,
      0,
      1,
      9,
      43.305233,
      0.752517,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      5.499006,
      NULL,
      0,
      0,
      2.922681,
      NULL,
      NULL,
      0.085139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.872909,
      NULL,
      NULL,
      0.903626,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.051368,
      NULL,
      NULL,
      1.481897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.408142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.395877,
      NULL,
      NULL,
      NULL,
      28,
      5,
      1.796717,
      NULL,
      '42402',
      NULL,
      '',
      0.390858,
      '24434',
      '',
      '',
      1.350452,
      '',
      '',
      '');
commit;
end;
/


