set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '0243200',
      3,
      0,
      4,
      0,
      '4430',
      0,
      0.019010,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      1.912403,
      317,
      68,
      NULL,
      ' 4- 2-1987',
      '10- 0-1977',
      '10- 7-1991',
      1,
      1,
      1.218891,
      2,
      0.051728,
      1.870578,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      12.001824,
      NULL,
      31.150664,
      5,
      6.862098,
      0,
      2,
      2.228508,
      0.080852,
      NULL,
      1,
      0.951602,
      NULL,
      1.558978,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      3,
      NULL,
      0,
      NULL,
      3,
      3,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      2.760166,
      NULL,
      0,
      2,
      2,
      1.051765,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.743751,
      0.162789,
      NULL,
      1.791383,
      0.954028,
      1,
      0.601002,
      0,
      2,
      0.158040,
      1.380543,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      5,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      0,
      2,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      3,
      1,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      2,
      0,
      0,
      0,
      5,
      NULL,
      1.532439,
      ' 2- 3-1981',
      396.654796,
      NULL,
      679,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      326.258176,
      0.602775,
      2.539001,
      3,
      0.163188,
      0,
      1,
      1,
      1.830792,
      4,
      1.294398,
      0.818473,
      0.859261,
      0,
      NULL,
      1,
      NULL,
      2,
      2,
      0,
      0.625560,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768020,
      3,
      0.911234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.679208,
      1.182027,
      0.126790,
      0,
      NULL,
      0.504019,
      1.284490,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.405195,
      2,
      0,
      NULL,
      2,
      NULL,
      1,
      0,
      3,
      2,
      2,
      2,
      NULL,
      0.136478,
      1.673591,
      3,
      1,
      0,
      NULL,
      NULL,
      0,
      1.125885,
      0,
      1,
      1,
      0,
      1.274355,
      NULL,
      1.134495,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      41,
      NULL,
      92,
      NULL,
      1,
      2,
      NULL,
      NULL,
      '',
      1.986695,
      '',
      NULL,
      '',
      1.492114,
      NULL,
      '',
      '',
      1.383118,
      3,
      13.836185,
      22.273977,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.767398,
      1.762039,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.138644,
      2.929774,
      0,
      2.632872,
      1,
      1,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      1.988379,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.577511,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.324830,
      4.973005,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.244909,
      1.063543,
      1.238322,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.053487,
      0,
      NULL,
      0,
      1.411685,
      1.209736,
      0.074940,
      0,
      0,
      2,
      0,
      1.325023,
      1.665483,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.122259,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      0.688789,
      NULL,
      1.625654,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.367526,
      NULL,
      NULL,
      3.442197,
      2,
      2.495790,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.999024,
      NULL,
      1.755279,
      NULL,
      3,
      NULL,
      NULL,
      1.331264,
      3,
      1,
      1,
      NULL,
      NULL,
      1.675558,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.307948,
      NULL,
      NULL,
      1.305787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5.054243,
      1,
      NULL,
      3,
      1,
      NULL,
      0.692435,
      NULL,
      3.477808,
      2.690113,
      NULL,
      6,
      NULL,
      1.853126,
      0,
      3.250302,
      2,
      NULL,
      1,
      NULL,
      3.571998,
      0.423339,
      NULL,
      NULL,
      3.945613,
      2,
      0.756148,
      NULL,
      3.452554,
      NULL,
      3.590636,
      NULL,
      0,
      1,
      3,
      1,
      0.561916,
      0,
      1.984238,
      NULL,
      2,
      NULL,
      NULL,
      0.291875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.284217,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.424325,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.199582,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.411192,
      3.516727,
      2.484768,
      1,
      0.622886,
      0,
      2.375867,
      NULL,
      NULL,
      4.614746,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.021656,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.888190,
      3,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.505182,
      1,
      NULL,
      NULL,
      1.855531,
      1.450924,
      NULL,
      NULL,
      0.304958,
      1.349114,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.232845,
      0.387039,
      NULL,
      NULL,
      0.027053,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      3,
      1800.931721,
      NULL,
      1,
      NULL,
      NULL,
      1.220716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.339876,
      NULL,
      NULL,
      12632,
      1834,
      1,
      NULL,
      0,
      1,
      0.639116,
      1.740357,
      1.803142,
      0,
      NULL,
      0,
      1.567570,
      0.302016,
      NULL,
      0,
      1,
      0.455843,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.604305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      113.765486,
      NULL,
      3.105540,
      7.941881,
      25,
      3.881643,
      0.889326,
      NULL,
      NULL,
      0.052397,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.356359,
      NULL,
      0.442104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523236,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.617087,
      NULL,
      1.235267,
      1,
      0.700761,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529558,
      0.347585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196150,
      1.778520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020469,
      3.951884,
      NULL,
      NULL,
      NULL,
      0.567139,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.400830,
      NULL,
      3,
      NULL,
      387.399185,
      NULL,
      0.646062,
      NULL,
      0,
      NULL,
      3,
      1,
      0,
      22,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      0.658365,
      0.482994,
      0.382081,
      0,
      0.330220,
      3,
      NULL,
      2.848086,
      0,
      3.257551,
      1,
      1,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0.304296,
      0.145467,
      NULL,
      NULL,
      NULL,
      0.253969,
      0,
      0.941158,
      3,
      3.083887,
      1,
      1,
      0.901591,
      NULL,
      0.774720,
      0,
      1,
      1.224304,
      2,
      2.354686,
      0,
      2,
      NULL,
      0.098237,
      NULL,
      1.800185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.786036,
      NULL,
      2.575125,
      0,
      0,
      1,
      3,
      NULL,
      2,
      NULL,
      3.331912,
      0.226105,
      1.377810,
      2.214998,
      1.204198,
      3.622624,
      0,
      NULL,
      1,
      0,
      NULL,
      3,
      1,
      2,
      1.631055,
      0.253736,
      0.377090,
      172,
      3,
      NULL,
      NULL,
      NULL,
      0.960666,
      3,
      1.048229,
      0,
      3,
      NULL,
      3,
      1.547654,
      3,
      0,
      54,
      20.711396,
      1,
      NULL,
      7.433434,
      '24213',
      '22341',
      '24044',
      1.296755,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL);
commit;
end;
/


