set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-10-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      1.758057,
      NULL,
      2,
      1,
      '2011',
      3,
      1.019484,
      NULL,
      NULL,
      ' 9-10-1980',
      NULL,
      NULL,
      2,
      2.973164,
      0.496954,
      NULL,
      NULL,
      0,
      253.908057,
      138,
      1,
      ' 6-14-1979',
      NULL,
      ' 1-10-1995',
      1,
      2.089485,
      1.572056,
      3.309162,
      0,
      3,
      3,
      3.951122,
      NULL,
      NULL,
      NULL,
      6.858043,
      7.415827,
      NULL,
      33.194770,
      NULL,
      16.247147,
      2,
      1,
      3,
      0.639186,
      0,
      1,
      0,
      0.488481,
      1.865700,
      1,
      1,
      0,
      1.005296,
      0,
      NULL,
      1,
      5,
      0.477145,
      2,
      0,
      0,
      3,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      3.244414,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      0.188050,
      1,
      0,
      1.749936,
      1.114350,
      2.940566,
      0.117966,
      1.632564,
      1.828817,
      NULL,
      3.947878,
      2,
      0.518491,
      1,
      0,
      1,
      NULL,
      NULL,
      0.492323,
      3,
      NULL,
      0.408809,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      0,
      3,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      2,
      4,
      1,
      4,
      2,
      0,
      0,
      0,
      NULL,
      2,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.579148,
      1,
      NULL,
      1.982495,
      0,
      0.153375,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773832,
      0,
      1,
      NULL,
      1,
      0,
      0,
      3,
      18.087333,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2,
      NULL,
      1,
      2.953477,
      2,
      0,
      0,
      1,
      1,
      1.487692,
      NULL,
      0,
      1.667786,
      1,
      0.985893,
      1.869139,
      NULL,
      0.520049,
      1,
      0,
      1,
      1.025337,
      NULL,
      NULL,
      3.850270,
      4.144581,
      2,
      1.817644,
      NULL,
      1,
      3,
      1,
      1.230898,
      1.414425,
      39.892543,
      2,
      3.884615,
      NULL,
      NULL,
      30,
      22,
      3,
      NULL,
      1,
      NULL,
      '',
      NULL,
      NULL,
      '02230',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      27,
      122,
      NULL,
      0.970061,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.013867,
      0.328692,
      1,
      0.542290,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.462780,
      0,
      0.475075,
      0.019459,
      NULL,
      NULL,
      1.335093,
      NULL,
      NULL,
      2.617535,
      NULL,
      0,
      1.862716,
      NULL,
      NULL,
      1.370281,
      NULL,
      NULL,
      4,
      1.596340,
      0.010880,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400673,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.933086,
      0,
      1.868413,
      1.007212,
      2.544843,
      0,
      1.519409,
      0.445146,
      NULL,
      1,
      1,
      0,
      1.318548,
      NULL,
      3.921168,
      3,
      0.343269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.888685,
      1.348908,
      3.249722,
      NULL,
      1.836994,
      3,
      0.223964,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.762243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042088,
      2.242032,
      0.777544,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      NULL,
      NULL,
      0,
      0.553260,
      0,
      NULL,
      5,
      0.194643,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.393660,
      NULL,
      NULL,
      5.988438,
      2.296611,
      2.987135,
      2.412133,
      NULL,
      NULL,
      3.562652,
      NULL,
      0.985010,
      2.668541,
      1.680519,
      NULL,
      2.954235,
      2.520787,
      0,
      0,
      3,
      1,
      3,
      0,
      0.069340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638686,
      0.454493,
      2.349045,
      2.215299,
      NULL,
      3.664909,
      3,
      0.060607,
      NULL,
      2.733619,
      1,
      NULL,
      NULL,
      1,
      0,
      0.734470,
      1.735349,
      1,
      0.054385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.407831,
      0.908276,
      0,
      0,
      1.442796,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      5,
      NULL,
      3.874358,
      1,
      1.240890,
      NULL,
      NULL,
      1.779733,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6645.055443,
      420,
      0.942032,
      NULL,
      0.579268,
      0.822070,
      0,
      0,
      0,
      3.451765,
      0,
      3,
      1,
      2.525920,
      1.336836,
      1.789399,
      1,
      1,
      NULL,
      0,
      NULL,
      2.113742,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2.838692,
      NULL,
      NULL,
      NULL,
      3,
      4.711221,
      16.250266,
      1.839433,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.094709,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.121558,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.116476,
      NULL,
      0.194859,
      NULL,
      0.220433,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0.218108,
      NULL,
      0.208888,
      NULL,
      NULL,
      NULL,
      1.001791,
      NULL,
      299.270750,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.648595,
      1,
      2,
      NULL,
      0.576489,
      NULL,
      1,
      NULL,
      5,
      NULL,
      1,
      NULL,
      1.291185,
      NULL,
      0,
      NULL,
      1.372474,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.058647,
      NULL,
      2,
      NULL,
      1.296648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.975228,
      1.800349,
      NULL,
      2.451949,
      NULL,
      1.436565,
      NULL,
      253.152305,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.562299,
      NULL,
      3,
      1.815744,
      0.425966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.672876,
      NULL,
      NULL,
      NULL,
      1144,
      NULL,
      138.546927,
      3.040780,
      2.265875,
      0.899179,
      NULL,
      1,
      NULL,
      NULL,
      894,
      0,
      1.741737,
      1.261118,
      NULL,
      1.105417,
      2.300912,
      1,
      2.040134,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      6.973457,
      0.886467,
      0,
      NULL,
      2,
      9,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.117774,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.652661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.276224,
      1.171489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      3.242269,
      NULL,
      2,
      NULL,
      0.464599,
      NULL,
      0.672595,
      NULL,
      NULL,
      NULL,
      2.136606,
      NULL,
      1.992098,
      NULL,
      0.614117,
      NULL,
      3,
      NULL,
      0.684922,
      NULL,
      0,
      NULL,
      7,
      0,
      NULL,
      1.545617,
      NULL,
      3,
      NULL,
      0.129940,
      NULL,
      3,
      0,
      2,
      3,
      1,
      0.764656,
      74,
      19.284286,
      NULL,
      NULL,
      NULL,
      '34410',
      '40201',
      '',
      NULL,
      '10222',
      NULL,
      '',
      1.697432,
      '',
      '',
      NULL);
commit;
end;
/


