set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '4231210',
      2,
      NULL,
      2,
      0,
      '2122',
      1.640048,
      1.630409,
      NULL,
      NULL,
      '10-29-1994',
      11.933127,
      NULL,
      2,
      1.099562,
      0.769241,
      ' 9-29-1988',
      27,
      2.421336,
      NULL,
      49,
      0,
      ' 0- 6-2000',
      '11- 1-1990',
      ' 2-21-1986',
      0,
      NULL,
      2,
      1.881079,
      1.264313,
      0,
      2,
      1.749077,
      1.571898,
      7,
      3,
      16,
      1.202049,
      NULL,
      17.304717,
      NULL,
      12.960617,
      5,
      1,
      NULL,
      0.365892,
      3,
      1,
      1,
      1,
      0.750254,
      1,
      0,
      1.530713,
      0.339277,
      0.525629,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.195693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      4,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      1,
      7.207185,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      5,
      4,
      5,
      0,
      2,
      4,
      NULL,
      1,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      13.101405,
      NULL,
      0.388436,
      NULL,
      1,
      0,
      NULL,
      3.954092,
      3,
      4,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.204055,
      0.565198,
      1.874105,
      1,
      1,
      0.871992,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.097832,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.620273,
      1.825180,
      NULL,
      1.986441,
      1,
      0.009489,
      0.076544,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      0,
      1,
      1,
      3,
      2,
      0,
      3,
      2,
      3,
      0,
      2.658175,
      0.690562,
      0.051966,
      1.976737,
      0.587659,
      1,
      1,
      0.558613,
      1.351606,
      NULL,
      NULL,
      0.427397,
      1.311495,
      NULL,
      1.582748,
      1,
      1,
      3.016050,
      0,
      3.603733,
      7.694326,
      1,
      5,
      5,
      0.956173,
      4.525772,
      3,
      4,
      3,
      0,
      0,
      56,
      2,
      0,
      NULL,
      44,
      38,
      34,
      3,
      0,
      0,
      '',
      '',
      '',
      3.066712,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.855206,
      32,
      NULL,
      18.559218,
      0.245457,
      45,
      3.558396,
      0,
      1,
      1.418598,
      NULL,
      NULL,
      0.634332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.275774,
      NULL,
      NULL,
      0,
      0.717604,
      1,
      1.952171,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.062481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898292,
      2,
      0.121686,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.810681,
      NULL,
      0,
      NULL,
      0.076973,
      NULL,
      NULL,
      NULL,
      0.930695,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.254999,
      0.366988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.058560,
      0,
      NULL,
      2,
      2,
      0,
      3,
      1,
      0,
      0,
      0,
      0,
      2,
      2.476291,
      0.273127,
      0,
      0.292143,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.696006,
      0.977775,
      1,
      3.386887,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.124803,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.594578,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      3.072594,
      0.556663,
      2,
      2.790397,
      1,
      5,
      NULL,
      0.683256,
      1,
      NULL,
      NULL,
      0.135820,
      NULL,
      NULL,
      0.143468,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.577048,
      NULL,
      NULL,
      0.721073,
      NULL,
      NULL,
      0.237583,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2.513784,
      0,
      0,
      1,
      NULL,
      0,
      6.665675,
      1,
      0.472798,
      2,
      NULL,
      0.403440,
      0,
      NULL,
      NULL,
      1.211622,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      4,
      1.940444,
      NULL,
      0.626536,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.219874,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.251813,
      0.831226,
      1,
      0.638393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563352,
      NULL,
      8,
      4,
      1,
      NULL,
      NULL,
      1.186360,
      NULL,
      NULL,
      1.066153,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      18115.694914,
      NULL,
      NULL,
      0.312802,
      0,
      NULL,
      1,
      NULL,
      0.856676,
      NULL,
      1.416898,
      2.529490,
      1.900265,
      1.251586,
      1,
      1.718711,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.838414,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.154414,
      NULL,
      126.317927,
      NULL,
      2.836639,
      20,
      44.888825,
      1,
      1.119862,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.599520,
      NULL,
      3.162559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.711816,
      1,
      NULL,
      3.628348,
      NULL,
      2,
      NULL,
      187,
      NULL,
      3.544400,
      NULL,
      1.964717,
      NULL,
      1.263019,
      NULL,
      0,
      0.095347,
      1.590524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      299,
      NULL,
      3,
      NULL,
      0.301528,
      NULL,
      0.528788,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      2.828956,
      NULL,
      2.507258,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.208780,
      NULL,
      NULL,
      1.943437,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.678101,
      NULL,
      3.200609,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      634,
      NULL,
      187,
      1.406628,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.606603,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3.664348,
      1.419521,
      2,
      NULL,
      2,
      2.938811,
      2.443668,
      NULL,
      0,
      3.897371,
      NULL,
      NULL,
      0.500015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.876077,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.491996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.206111,
      0.215757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.737860,
      0.833854,
      NULL,
      0.953644,
      NULL,
      3.232881,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.060294,
      NULL,
      3.400074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.577374,
      NULL,
      1,
      NULL,
      1,
      NULL,
      11.131358,
      3,
      NULL,
      0.000193,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0.487433,
      NULL,
      NULL,
      40.149181,
      42,
      3,
      0.573957,
      0.131645,
      NULL,
      '30234',
      '',
      3.882404,
      '04223',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


