set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '0304032',
      3,
      1.916018,
      3,
      NULL,
      '0140',
      3.981940,
      1,
      NULL,
      NULL,
      ' 9-14-1988',
      NULL,
      NULL,
      1,
      0,
      3,
      ' 8-17-1995',
      31.574762,
      2.933313,
      194,
      NULL,
      NULL,
      ' 2-21-1996',
      NULL,
      NULL,
      3.520601,
      NULL,
      0.537068,
      NULL,
      1,
      0,
      3,
      1.988001,
      NULL,
      NULL,
      NULL,
      8,
      8,
      17,
      3,
      5,
      NULL,
      5,
      1,
      3,
      0,
      3,
      NULL,
      0.927940,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      3,
      5,
      1,
      1.142683,
      NULL,
      NULL,
      0,
      4,
      1,
      0,
      3,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0.030728,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      5,
      0,
      4,
      NULL,
      0,
      NULL,
      3,
      5,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      NULL,
      0,
      0,
      2.756313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.833184,
      2,
      1,
      4,
      1,
      2,
      0.987433,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.984604,
      1,
      1,
      0.662414,
      0.275890,
      1,
      3,
      NULL,
      0,
      1.371864,
      NULL,
      NULL,
      NULL,
      2,
      1.249830,
      1.485743,
      0,
      2,
      3,
      2,
      3,
      NULL,
      NULL,
      3,
      3,
      2,
      NULL,
      1.875539,
      2.714283,
      NULL,
      0.260675,
      NULL,
      0,
      1.264139,
      0,
      1.865347,
      0.442484,
      0.968972,
      1.606145,
      0.851951,
      NULL,
      0,
      0.220168,
      1,
      1.496844,
      5.814381,
      NULL,
      5.544142,
      NULL,
      6,
      1.609905,
      5.571108,
      2,
      4.881410,
      NULL,
      2,
      0.622149,
      34,
      1,
      0,
      NULL,
      6,
      61,
      NULL,
      NULL,
      3,
      2,
      '10243',
      '41340',
      '13200',
      1.327412,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.997298,
      10.912905,
      22.419237,
      NULL,
      3.575800,
      NULL,
      5.142628,
      2,
      1,
      2.953371,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323814,
      NULL,
      NULL,
      0,
      0,
      1.268352,
      0,
      3,
      0.324380,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.663588,
      0,
      1,
      0.618294,
      NULL,
      NULL,
      8,
      3,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.986555,
      NULL,
      NULL,
      NULL,
      0,
      0.523529,
      1,
      3,
      3,
      0.845756,
      1.288889,
      0.537831,
      0.318861,
      0,
      NULL,
      2,
      2,
      NULL,
      1.554859,
      NULL,
      3.546881,
      2.442709,
      2,
      NULL,
      1,
      1,
      3.772919,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.590833,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.543310,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.789500,
      0.982883,
      3,
      3,
      0,
      0,
      NULL,
      NULL,
      3.164937,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.943222,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.089796,
      NULL,
      NULL,
      0.946318,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.422067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136750,
      NULL,
      NULL,
      1.109497,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.780530,
      0.769340,
      NULL,
      3,
      2.719252,
      3,
      1.411556,
      0,
      3,
      0.712012,
      2.048684,
      NULL,
      2.227717,
      NULL,
      3.847498,
      1,
      NULL,
      0,
      3,
      0.554115,
      1.991092,
      1,
      3,
      NULL,
      NULL,
      0.157951,
      5.457996,
      6,
      0,
      3.051359,
      3.873220,
      3,
      4,
      3,
      1.905739,
      0,
      1,
      1,
      2.874927,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      9.019525,
      NULL,
      NULL,
      2.359704,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.715425,
      NULL,
      NULL,
      1.618360,
      NULL,
      NULL,
      0.952806,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.833980,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.938282,
      NULL,
      NULL,
      1,
      0,
      0.663953,
      0,
      1,
      2.966660,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186123,
      NULL,
      NULL,
      NULL,
      16.652275,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.627279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.052845,
      NULL,
      NULL,
      0,
      1.441602,
      NULL,
      NULL,
      1.703351,
      NULL,
      NULL,
      NULL,
      1.370404,
      3,
      NULL,
      NULL,
      1,
      0.073950,
      NULL,
      NULL,
      1.080577,
      1,
      NULL,
      NULL,
      0.456422,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.340308,
      NULL,
      NULL,
      NULL,
      0,
      3.419208,
      NULL,
      NULL,
      4.611415,
      5.169719,
      NULL,
      NULL,
      1.426293,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.917577,
      NULL,
      2.324115,
      0,
      NULL,
      NULL,
      NULL,
      1.352991,
      NULL,
      NULL,
      1,
      10.175713,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      113.522843,
      7.771974,
      0.245004,
      0.612837,
      1.395805,
      0.648853,
      1.745852,
      NULL,
      1.910680,
      0.607859,
      NULL,
      NULL,
      0.047604,
      2.348877,
      1.021009,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1.460269,
      NULL,
      NULL,
      NULL,
      0.568532,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.923343,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.243820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944028,
      0.954732,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.810944,
      NULL,
      1,
      NULL,
      0.735170,
      NULL,
      0.254408,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.377678,
      NULL,
      301,
      NULL,
      2.917623,
      NULL,
      2.906205,
      NULL,
      1.379193,
      NULL,
      0,
      0,
      1.938979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.891771,
      NULL,
      0.619044,
      NULL,
      NULL,
      NULL,
      0.371028,
      NULL,
      0,
      NULL,
      0,
      1.721690,
      NULL,
      10.447166,
      46.282649,
      1.722710,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      1.178291,
      1,
      NULL,
      1,
      0.291877,
      0,
      2,
      2,
      NULL,
      1.201797,
      NULL,
      NULL,
      1,
      3.461315,
      1,
      1,
      NULL,
      1,
      1.987224,
      1.657406,
      1.544489,
      0.168454,
      0,
      0,
      NULL,
      1,
      1.811225,
      0,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      1,
      1.070310,
      2.358130,
      3.813232,
      1,
      2.019003,
      0.683759,
      3.317506,
      2.472588,
      0.845358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.421764,
      1,
      1.837486,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      105,
      NULL,
      1,
      4,
      0.302763,
      '12113',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.699445,
      '',
      '',
      '');
commit;
end;
/


