set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30',
      '24',
      NULL,
      31,
      '4431432',
      5,
      1.592730,
      NULL,
      2,
      '3220',
      4.430623,
      0.216331,
      NULL,
      NULL,
      ' 0- 7-1993',
      63,
      19,
      NULL,
      2.449612,
      1.538611,
      '10-16-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 0-24-1995',
      ' 4-27-1976',
      NULL,
      1,
      1.886588,
      2.812991,
      NULL,
      NULL,
      0,
      2,
      1.090325,
      0,
      4,
      3,
      12.924226,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      NULL,
      1.929333,
      0,
      1,
      0,
      0,
      1.559712,
      0.804882,
      0.656612,
      1.158811,
      1.323397,
      1.322022,
      1,
      0,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      4,
      1,
      0,
      1,
      8.144718,
      0,
      0,
      1,
      0,
      0.198113,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3.590787,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0.299215,
      0,
      1,
      NULL,
      0,
      1,
      1,
      5,
      0,
      5,
      2,
      2,
      0,
      4,
      0,
      NULL,
      1,
      4,
      1,
      0,
      NULL,
      0,
      NULL,
      5,
      NULL,
      4,
      5,
      3,
      ' 0- 0-1997',
      NULL,
      NULL,
      24.167240,
      0.178101,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      NULL,
      1,
      0,
      0,
      NULL,
      1.174315,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.929160,
      2,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.535586,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3.336292,
      8,
      1.423675,
      1.974225,
      5,
      2.472837,
      NULL,
      NULL,
      NULL,
      2.267721,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.391248,
      0.182712,
      0.295281,
      0.736153,
      2,
      42.120718,
      NULL,
      0.681761,
      NULL,
      NULL,
      NULL,
      3,
      1.834542,
      2.890320,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      NULL,
      3,
      NULL,
      NULL,
      2.512304,
      1,
      5,
      1.282922,
      0,
      1,
      1.273635,
      1.886175,
      0.925817,
      0.781287,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      2,
      0.003897,
      6,
      2.106165,
      0.433891,
      3,
      NULL,
      6.131526,
      NULL,
      NULL,
      4,
      NULL,
      3.825887,
      3,
      9,
      NULL,
      NULL,
      55,
      NULL,
      60,
      NULL,
      NULL,
      0.466265,
      2,
      '32213',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.420115,
      35,
      35.139436,
      26,
      3.253352,
      39.357077,
      9.481377,
      5.378844,
      NULL,
      NULL,
      1.797181,
      0.948105,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.159578,
      NULL,
      2.126000,
      NULL,
      2,
      1.779338,
      NULL,
      NULL,
      3,
      0,
      2.724881,
      0,
      NULL,
      NULL,
      0.105864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.262899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      5,
      1.485572,
      0,
      0.029706,
      NULL,
      NULL,
      NULL,
      0.886971,
      2.129208,
      3,
      3,
      3.465683,
      NULL,
      1.257562,
      2,
      2.970459,
      1.755136,
      1.829503,
      0.227299,
      0.374751,
      3.517632,
      NULL,
      0.646038,
      3.676365,
      2.965947,
      1,
      NULL,
      0.781232,
      0.356317,
      1,
      NULL,
      1.895354,
      1,
      3,
      0.682555,
      1.020598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.525787,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.089305,
      NULL,
      2.788582,
      2.790662,
      0,
      NULL,
      NULL,
      0.692248,
      0.335429,
      NULL,
      1.161595,
      3.399711,
      1,
      1.939437,
      NULL,
      NULL,
      4,
      4.741858,
      1.299540,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.997959,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.458470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.917497,
      1,
      1.665921,
      0,
      NULL,
      NULL,
      1.882375,
      NULL,
      NULL,
      8.448017,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.626187,
      NULL,
      0.186606,
      1.912477,
      NULL,
      1,
      8.360010,
      2.858316,
      NULL,
      3,
      0.104076,
      NULL,
      1.606199,
      0,
      1.739684,
      3.055856,
      0.301888,
      1.739370,
      0.812174,
      NULL,
      NULL,
      5.941408,
      NULL,
      1,
      NULL,
      4,
      2,
      1,
      2,
      3,
      0.205355,
      1,
      1.665488,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.984727,
      NULL,
      NULL,
      0.282822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.325075,
      NULL,
      NULL,
      1.693441,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.184657,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      5.994004,
      NULL,
      NULL,
      2,
      1.032081,
      0,
      1.439476,
      2.811432,
      2,
      0,
      NULL,
      9,
      NULL,
      0,
      NULL,
      5.219569,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.781352,
      NULL,
      1.517886,
      3,
      1.677761,
      NULL,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.691158,
      1.699241,
      NULL,
      NULL,
      0,
      3,
      0.952230,
      NULL,
      0.153694,
      1.605367,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0.241268,
      NULL,
      NULL,
      1.231968,
      1,
      NULL,
      1,
      NULL,
      1.744949,
      NULL,
      NULL,
      2,
      0.181646,
      NULL,
      1,
      0.376352,
      2.286245,
      NULL,
      1.822553,
      0.797017,
      1.938735,
      NULL,
      0,
      0,
      0,
      NULL,
      3,
      NULL,
      1.720340,
      NULL,
      1.337888,
      5,
      5.813221,
      NULL,
      7.591416,
      1.169042,
      3,
      8,
      3,
      3,
      18.883638,
      NULL,
      NULL,
      NULL,
      3.178838,
      1.305806,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.889033,
      3.748638,
      2.342711,
      3.126010,
      4,
      0.006921,
      NULL,
      NULL,
      0.564482,
      115,
      NULL,
      1,
      0.942244,
      0,
      NULL,
      0,
      0.099003,
      0.102906,
      1,
      0,
      2,
      0,
      2.521449,
      NULL,
      0,
      1,
      1.211513,
      NULL,
      3.087836,
      NULL,
      3,
      NULL,
      0.217273,
      NULL,
      0.289335,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      101,
      NULL,
      NULL,
      NULL,
      33,
      3.222262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.880242,
      NULL,
      1.308333,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.059970,
      NULL,
      0.165504,
      NULL,
      1,
      NULL,
      1.538279,
      NULL,
      0.619214,
      2,
      NULL,
      0.115188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.682979,
      NULL,
      3.416238,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.666747,
      NULL,
      1.696405,
      NULL,
      0.898899,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.890030,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.926092,
      NULL,
      1.462130,
      NULL,
      1.466489,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885732,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001876,
      NULL,
      NULL,
      1.802385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      32,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.308879,
      0.084682,
      0.988203,
      0,
      0,
      0,
      3,
      1,
      3,
      0.484718,
      1.028923,
      1,
      1,
      NULL,
      1,
      1.245867,
      2.985769,
      2.926126,
      NULL,
      NULL,
      0,
      1,
      0,
      1.365326,
      NULL,
      0.331490,
      1.691825,
      NULL,
      NULL,
      NULL,
      0,
      0.191006,
      NULL,
      0,
      1.200746,
      NULL,
      1.523501,
      3,
      1,
      1,
      3.911222,
      0,
      3,
      0.870094,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.180302,
      1,
      0,
      NULL,
      0.104782,
      1.979509,
      NULL,
      0,
      2,
      0.037522,
      NULL,
      NULL,
      1.693035,
      NULL,
      5,
      4,
      2.850817,
      NULL,
      '00312',
      '',
      0,
      '',
      '',
      '',
      0.161341,
      '',
      '',
      '');
commit;
end;
/


