set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104509';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      2.210684,
      1.473036,
      2,
      NULL,
      NULL,
      1.054678,
      1.261866,
      NULL,
      NULL,
      ' 4-25-1975',
      1.621886,
      NULL,
      NULL,
      NULL,
      1,
      '10-25-1995',
      32.119183,
      1.639031,
      334,
      NULL,
      2,
      ' 3- 7-2001',
      ' 8-15-1992',
      ' 3-29-1985',
      1.189504,
      NULL,
      0.927761,
      3,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      12.845581,
      NULL,
      18,
      9.992103,
      2,
      11,
      1,
      2,
      0.149640,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.111421,
      1,
      0,
      0.222130,
      NULL,
      0.434302,
      NULL,
      1,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      2,
      1,
      2,
      0,
      4,
      1,
      3.759047,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.290557,
      NULL,
      NULL,
      4,
      1,
      1.143028,
      0,
      1.232572,
      0.498156,
      0,
      NULL,
      2,
      1.866570,
      2,
      1.265730,
      NULL,
      0,
      0.213703,
      0.713890,
      1.517323,
      0,
      0.138797,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      3,
      1.568280,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      4,
      2,
      0,
      0,
      4,
      0,
      1,
      0,
      1,
      0.683763,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      1,
      2,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      3,
      NULL,
      3,
      0,
      0,
      1,
      2,
      2,
      0,
      0,
      0,
      1,
      ' 9-26-1985',
      24,
      ' 6- 2-2002',
      40,
      2.490110,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      4,
      0,
      1,
      0.084469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.694131,
      0.942513,
      1.449215,
      0,
      1,
      0.635916,
      0.586399,
      1.479524,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.428874,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951982,
      0,
      1,
      1,
      1.056178,
      NULL,
      92.461032,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      3,
      NULL,
      1,
      0.632712,
      3.747234,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.921994,
      1,
      1.185686,
      1.377525,
      1,
      1.365325,
      1,
      NULL,
      4.781734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591100,
      NULL,
      29,
      53,
      12.404096,
      1,
      0,
      1.492373,
      '00122',
      '',
      '',
      0.179120,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      2,
      40.558181,
      NULL,
      47.056850,
      1,
      49,
      NULL,
      0.160623,
      NULL,
      1.494702,
      3,
      NULL,
      0.791540,
      NULL,
      NULL,
      0.000562,
      NULL,
      NULL,
      1,
      3.570775,
      NULL,
      0,
      NULL,
      NULL,
      0.917150,
      1,
      1.885801,
      0.754831,
      1.534261,
      0,
      0,
      NULL,
      NULL,
      1.934813,
      6.934292,
      3,
      0.762572,
      1.781036,
      0.501777,
      2.069361,
      NULL,
      0.065679,
      0,
      NULL,
      NULL,
      6.319549,
      9,
      NULL,
      0,
      0.281256,
      NULL,
      NULL,
      NULL,
      0.668033,
      NULL,
      NULL,
      NULL,
      1,
      2.616943,
      1.718872,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.791670,
      0,
      1.836682,
      2.160663,
      1,
      NULL,
      NULL,
      0,
      0.729223,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0.543141,
      0,
      NULL,
      NULL,
      2,
      1.567447,
      1.129731,
      3,
      1,
      6.021518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.759070,
      NULL,
      NULL,
      NULL,
      1.308906,
      NULL,
      NULL,
      NULL,
      3,
      0.088312,
      3,
      1,
      0,
      0.899368,
      NULL,
      NULL,
      7.196606,
      5,
      3,
      0.963936,
      0.444287,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992617,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.177238,
      NULL,
      NULL,
      1.829525,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.842282,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.352447,
      NULL,
      NULL,
      NULL,
      3.902466,
      0,
      0,
      NULL,
      NULL,
      4,
      1.160890,
      NULL,
      1.550312,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.386690,
      NULL,
      1,
      5,
      1.441349,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1.525318,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.152650,
      NULL,
      NULL,
      0.655508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.410407,
      0,
      1,
      1,
      NULL,
      1.646128,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.165913,
      NULL,
      NULL,
      NULL,
      1.073811,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.812121,
      NULL,
      NULL,
      NULL,
      0.461201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.675666,
      NULL,
      2.350626,
      9.220960,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.912258,
      0.655426,
      1.737671,
      1.052231,
      0.425970,
      1,
      1,
      0,
      0.141922,
      1.707599,
      0.523252,
      0,
      0,
      0.591903,
      0.563652,
      1,
      0.064473,
      0.786314,
      1,
      0,
      1.226079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.907625,
      NULL,
      0.901151,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.699217,
      NULL,
      1,
      NULL,
      1.743735,
      1.081745,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.349419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.785793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.540476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      0,
      NULL,
      1,
      2,
      6.584038,
      NULL,
      1.307460,
      0.907021,
      2.275734,
      3.498047,
      NULL,
      0,
      NULL,
      NULL,
      2.190642,
      1.505959,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.262313,
      0,
      NULL,
      3.065297,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1.840962,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.502767,
      1.687825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.456962,
      NULL,
      1,
      1,
      6,
      2.596618,
      1.786475,
      3.593324,
      36,
      46.553719,
      2,
      0,
      1.405802,
      '02021',
      '',
      '',
      3,
      '11210',
      '',
      '',
      0.768824,
      '',
      '',
      NULL);
commit;
end;
/


