set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9318626';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '0200244',
      1,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-19-1984',
      NULL,
      NULL,
      0,
      0.851119,
      0.798991,
      ' 8-28-1996',
      31.693459,
      2.579382,
      110,
      120,
      1,
      NULL,
      ' 2- 2-1977',
      ' 8- 5-1989',
      2.284559,
      NULL,
      3.556788,
      0,
      0.635731,
      1.281995,
      NULL,
      NULL,
      1.415458,
      17.828579,
      8,
      14.698644,
      5.379851,
      11,
      NULL,
      3,
      10,
      2,
      NULL,
      8.352181,
      0,
      0,
      NULL,
      1.032641,
      NULL,
      0.763481,
      1.100198,
      0.238757,
      NULL,
      1.442846,
      1.748461,
      0,
      2,
      5,
      3.498127,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.374356,
      3,
      1,
      1,
      2.629731,
      3.374045,
      0,
      2.813917,
      0,
      1.891524,
      0.903507,
      1,
      0.277334,
      2,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      0.663907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      5,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      4,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.115511,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.051491,
      0,
      0.349180,
      NULL,
      0,
      0,
      NULL,
      1.740961,
      0,
      2,
      3.812455,
      1,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.197728,
      0,
      1.522034,
      1.664800,
      1,
      0.873661,
      1,
      2,
      33.645214,
      1.816603,
      1.368198,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      2,
      NULL,
      18,
      39.413196,
      153.413650,
      126.663601,
      153.842657,
      88.770016,
      NULL,
      0.218418,
      0,
      0,
      183.305259,
      118.750944,
      177.446216,
      0,
      0.480728,
      4,
      NULL,
      4.487733,
      3,
      6.227622,
      1.782791,
      NULL,
      3,
      4.355567,
      1,
      0.672728,
      2,
      NULL,
      NULL,
      17,
      0,
      3.891070,
      NULL,
      71,
      4,
      NULL,
      4,
      1,
      2,
      '42103',
      '',
      '',
      2,
      '40443',
      NULL,
      '',
      1.744389,
      NULL,
      NULL,
      '',
      NULL,
      24,
      69.012340,
      8,
      0.600769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.629094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.031724,
      NULL,
      NULL,
      0.485292,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.838388,
      0.737121,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.949425,
      1.003685,
      0.500970,
      0,
      2.201224,
      3,
      2.922069,
      2.462971,
      1,
      NULL,
      0,
      0,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.789716,
      NULL,
      NULL,
      0.439458,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.533400,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.696415,
      4,
      NULL,
      0.668346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.431462,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.795842,
      NULL,
      NULL,
      1.634970,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.702897,
      1.084425,
      4.218066,
      3.488838,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.411695,
      2,
      0.353191,
      2.579081,
      1.406126,
      1.646140,
      3.325516,
      4.506721,
      3.974667,
      1.820527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.164064,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      1.827237,
      0.003862,
      0.316782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355111,
      0.876682,
      3,
      NULL,
      0.857556,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.028106,
      NULL,
      NULL,
      0.799407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083870,
      NULL,
      NULL,
      1.848809,
      NULL,
      1,
      NULL,
      7.680951,
      0,
      1,
      0.309640,
      NULL,
      0,
      0,
      1,
      1.339670,
      0.118714,
      1,
      0.699629,
      1.548907,
      NULL,
      NULL,
      1,
      1.679739,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800398,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044348,
      1.940922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.053482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773110,
      1.159998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419880,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.465144,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.915750,
      NULL,
      1.737739,
      NULL,
      NULL,
      NULL,
      0.876386,
      NULL,
      1.592345,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.985867,
      1.199873,
      2.269852,
      2.361929,
      3,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.174335,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.444376,
      NULL,
      NULL,
      1.835451,
      NULL,
      NULL,
      0.173669,
      NULL,
      NULL,
      1.351873,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.869040,
      NULL,
      NULL,
      1.020420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.775643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.331184,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.547676,
      NULL,
      0,
      NULL,
      10.134414,
      0.010850,
      0,
      1,
      NULL,
      1.453831,
      NULL,
      1,
      NULL,
      3,
      NULL,
      5,
      1,
      NULL,
      NULL,
      84.663039,
      26,
      4,
      NULL,
      3,
      '00041',
      NULL,
      NULL,
      2,
      '10204',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


