set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6711972';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2.421479,
      3.278764,
      NULL,
      56,
      ' 3-22-1981',
      82.978048,
      NULL,
      5,
      0.053003,
      0,
      ' 2-22-1997',
      78,
      2,
      140.945905,
      36.410730,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.700450,
      1,
      0,
      1.290715,
      1,
      NULL,
      1.439223,
      NULL,
      2,
      18.558596,
      7,
      9,
      20.780074,
      4,
      3.978137,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.622421,
      1,
      0.960054,
      0.294368,
      NULL,
      1,
      NULL,
      2,
      3,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.043031,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.774939,
      1,
      0,
      NULL,
      0.195847,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      4,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.479860,
      0,
      5,
      2,
      2,
      2,
      4,
      3,
      4,
      3,
      NULL,
      4,
      3,
      1,
      2,
      3,
      4,
      5,
      3,
      0,
      0,
      NULL,
      3,
      3,
      1,
      5,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      3,
      NULL,
      3.091126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.392977,
      6,
      0,
      1.086792,
      2.158485,
      0.923252,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.372661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.724290,
      3.059642,
      0.894589,
      1.791037,
      1,
      1,
      1,
      0.486475,
      NULL,
      3.197280,
      1.571059,
      NULL,
      NULL,
      NULL,
      0,
      1.165373,
      1,
      1,
      NULL,
      3,
      0,
      2,
      0,
      0,
      0,
      1,
      0,
      2,
      3.846087,
      3.920389,
      5,
      0,
      NULL,
      6.664784,
      1,
      0.957989,
      3.465572,
      0,
      1,
      3.407921,
      NULL,
      3,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      1,
      5.660443,
      1,
      0.310290,
      NULL,
      2.781424,
      NULL,
      0,
      NULL,
      NULL,
      28,
      2,
      0,
      44,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.609546,
      '42231',
      '',
      '',
      1.810958,
      '',
      '',
      '',
      0.429117,
      '13433',
      '1134',
      NULL,
      1.436046,
      51.911506,
      2.339940,
      5,
      2.242241,
      14,
      6.987381,
      1.904331,
      0,
      3.949708,
      0.775939,
      2,
      0,
      3.593894,
      NULL,
      0.690539,
      NULL,
      0.617046,
      0.683627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.725131,
      3.806233,
      NULL,
      1,
      1.381496,
      NULL,
      NULL,
      1.551821,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.240465,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.179209,
      6,
      4.485940,
      NULL,
      0.793472,
      NULL,
      NULL,
      NULL,
      0.652686,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.800427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.130874,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.933177,
      0.214595,
      0,
      1.143865,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.571666,
      5,
      NULL,
      3.676778,
      1,
      0.409275,
      NULL,
      NULL,
      0.813423,
      0.539661,
      0.664579,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.192536,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.724648,
      NULL,
      NULL,
      2.554571,
      0,
      2.338027,
      3.140459,
      1.046033,
      2,
      NULL,
      2.900696,
      9.931847,
      2,
      5.092980,
      NULL,
      0.701532,
      3.230694,
      0,
      NULL,
      1,
      1,
      2.416582,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      7.020043,
      1.674942,
      0.797037,
      0.950328,
      3,
      NULL,
      1,
      0.557881,
      3.660591,
      0.126849,
      1.893060,
      2,
      NULL,
      0.518313,
      7.701530,
      2,
      0.861403,
      0.479447,
      7.890937,
      8,
      3,
      1,
      1,
      0,
      0,
      1.564684,
      1.245065,
      0.600685,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257702,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.992757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.617606,
      1.684208,
      2.913972,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      5.684108,
      2,
      NULL,
      NULL,
      28.890695,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.894478,
      0.555837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.651928,
      NULL,
      NULL,
      NULL,
      2.299162,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931943,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      0.943896,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      3.695385,
      NULL,
      NULL,
      3.468250,
      1.622948,
      NULL,
      NULL,
      1.100042,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.973624,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      459,
      0,
      0,
      184.642058,
      78,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.105313,
      40,
      0,
      NULL,
      52,
      1.745766,
      1.727623,
      0,
      0,
      NULL,
      NULL,
      1,
      2.087623,
      0.698836,
      3,
      1.112043,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.270925,
      NULL,
      NULL,
      NULL,
      0.493549,
      NULL,
      1.719004,
      NULL,
      108,
      NULL,
      1.028222,
      47.347563,
      15.548479,
      0.906173,
      0.661918,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.083555,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.770407,
      NULL,
      0.181501,
      0.659471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      9,
      1,
      1,
      3.270264,
      2,
      2,
      1.934529,
      NULL,
      NULL,
      0.959765,
      0,
      0,
      NULL,
      0.010064,
      2,
      1,
      0,
      2.839914,
      0.288909,
      NULL,
      1,
      2.231470,
      0.195023,
      NULL,
      NULL,
      0,
      2.973679,
      3,
      0,
      0.273725,
      0,
      2.723958,
      2.992719,
      0,
      0,
      1.946785,
      2.427143,
      0.369855,
      1.772757,
      1,
      3.018464,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.972266,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0.157110,
      NULL,
      1.517954,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.828237,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      7,
      0.822767,
      NULL,
      0,
      0,
      1,
      3,
      NULL,
      1.538008,
      4,
      3,
      6,
      2.086624,
      3,
      3.057144,
      46.033900,
      1.906047,
      3,
      1,
      3.017293,
      '03313',
      '44313',
      '',
      1,
      '',
      '',
      '',
      5.911540,
      NULL,
      '4231',
      '');
commit;
end;
/


