set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908830';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      1.730410,
      NULL,
      3,
      1,
      '0000',
      0.904068,
      1.817420,
      NULL,
      NULL,
      ' 2-19-1977',
      6,
      NULL,
      3,
      2.089440,
      0,
      ' 0- 4-1984',
      NULL,
      3.828516,
      235,
      22,
      0,
      ' 3-18-1986',
      ' 9-15-1981',
      ' 8-11-1996',
      0,
      0,
      NULL,
      3,
      1.669940,
      3.238347,
      3,
      0.344302,
      1.688802,
      0.588849,
      4,
      10.311601,
      NULL,
      40.565630,
      9,
      3,
      12,
      3,
      2,
      4,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1.793282,
      NULL,
      NULL,
      1,
      5,
      0,
      2,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1.731669,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.304557,
      0.839246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.438375,
      0,
      1,
      NULL,
      1.297797,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      1,
      0,
      NULL,
      0.474690,
      NULL,
      1.836054,
      1,
      0,
      1,
      3,
      0,
      4,
      5,
      NULL,
      5,
      3,
      NULL,
      3,
      NULL,
      2,
      3,
      3,
      4,
      3,
      4,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      5,
      0,
      ' 8-12-1983',
      634.989237,
      '10-25-2002',
      192,
      0.568825,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      38.817546,
      3.003835,
      1.827666,
      0,
      1,
      NULL,
      3.875284,
      0.350069,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.537142,
      11,
      6.546719,
      0,
      1.657425,
      0,
      NULL,
      NULL,
      NULL,
      2.748265,
      4.670728,
      3,
      0,
      2,
      NULL,
      7.885073,
      ' 9-22-1998',
      73.953286,
      ' 8- 7-1976',
      23,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.506510,
      1,
      2.427838,
      29,
      1.543667,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.569396,
      NULL,
      0,
      2,
      0,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      1,
      5.358415,
      0.982975,
      NULL,
      1,
      1.927921,
      1.535108,
      3,
      0.547971,
      NULL,
      0.246171,
      1,
      0.776373,
      1,
      0.852704,
      NULL,
      0,
      1.972701,
      3,
      0,
      3,
      11.731579,
      1,
      9.518365,
      2,
      7.400236,
      2.263107,
      NULL,
      7,
      NULL,
      1,
      NULL,
      11.341558,
      1,
      2,
      NULL,
      14,
      39,
      60,
      2,
      0,
      NULL,
      '00112',
      NULL,
      '',
      1,
      '23142',
      NULL,
      '',
      0,
      '',
      '',
      '',
      3.841242,
      25.399365,
      71,
      26,
      2.758582,
      19,
      3,
      NULL,
      2,
      2,
      1,
      0,
      0.248172,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.818265,
      NULL,
      1.940272,
      1.495727,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948686,
      NULL,
      NULL,
      1.704252,
      NULL,
      0.101146,
      0,
      NULL,
      NULL,
      8,
      NULL,
      2.843669,
      0,
      1.876499,
      NULL,
      NULL,
      NULL,
      0.704473,
      NULL,
      NULL,
      NULL,
      1.925970,
      NULL,
      NULL,
      1.800506,
      NULL,
      NULL,
      0.066569,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.431798,
      NULL,
      NULL,
      0.010699,
      0.449681,
      1.869168,
      3.629516,
      1,
      1.235112,
      2.477789,
      0.662325,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.827616,
      0.987039,
      2,
      3,
      0.176735,
      0.843617,
      3,
      1.172316,
      3,
      NULL,
      NULL,
      3.569125,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.306730,
      NULL,
      1.510184,
      NULL,
      NULL,
      0.009753,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.908804,
      NULL,
      NULL,
      0.519141,
      0,
      3,
      0.830475,
      0,
      1,
      2,
      NULL,
      1,
      1.459271,
      NULL,
      0,
      3.387126,
      NULL,
      3,
      0,
      1.870122,
      1,
      3.967884,
      0,
      3.240982,
      2,
      0.439222,
      1.920890,
      NULL,
      2.894353,
      NULL,
      0.223528,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      3.155401,
      1.886272,
      10.268012,
      2,
      3.502012,
      10.747326,
      0,
      1,
      0,
      4,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.167200,
      NULL,
      NULL,
      3.571970,
      NULL,
      NULL,
      1.534112,
      NULL,
      NULL,
      1.026594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.158764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      11.971750,
      49.873019,
      NULL,
      NULL,
      0.645882,
      3,
      NULL,
      NULL,
      NULL,
      1.613716,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.575101,
      0.888741,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.182033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.298378,
      NULL,
      NULL,
      1.930781,
      NULL,
      NULL,
      NULL,
      NULL,
      0.795034,
      NULL,
      NULL,
      1.706038,
      0,
      NULL,
      NULL,
      1,
      8,
      NULL,
      NULL,
      0.515541,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      NULL,
      NULL,
      NULL,
      1.139088,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.517394,
      NULL,
      NULL,
      1.877992,
      NULL,
      NULL,
      0.402653,
      NULL,
      1.493878,
      342.874690,
      0.095622,
      0.579880,
      NULL,
      0.709305,
      1.919455,
      0,
      1,
      0.378590,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0.284371,
      0,
      0.299412,
      1.840741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0.193436,
      1,
      1.629473,
      1.720213,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.258696,
      1.558976,
      NULL,
      0,
      2,
      NULL,
      3.172317,
      3.469059,
      NULL,
      0.771300,
      0,
      NULL,
      1.143865,
      1,
      NULL,
      1.054211,
      0,
      NULL,
      0,
      2.859213,
      NULL,
      1.135979,
      0,
      NULL,
      0,
      0.607378,
      NULL,
      NULL,
      0.826228,
      NULL,
      NULL,
      0,
      NULL,
      2.999891,
      1.295431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479145,
      2,
      NULL,
      0.728334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.557106,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.044571,
      NULL,
      NULL,
      NULL,
      0.783023,
      NULL,
      1,
      NULL,
      0.409667,
      NULL,
      15.004587,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      2,
      NULL,
      2,
      2.435851,
      3,
      NULL,
      1,
      NULL,
      '14241',
      '',
      NULL,
      1,
      '23400',
      '',
      '',
      0.328897,
      '',
      '',
      '');
commit;
end;
/


