set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611385';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '4000221',
      3,
      1,
      4,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      ' 8-16-1982',
      61,
      NULL,
      NULL,
      NULL,
      0.718721,
      ' 0- 4-1982',
      NULL,
      2.847095,
      NULL,
      53,
      2,
      ' 3-15-1974',
      NULL,
      ' 4-19-2000',
      3.615992,
      NULL,
      0.398216,
      1.424598,
      NULL,
      1.576677,
      3,
      0,
      NULL,
      4.348647,
      4,
      13.918824,
      1,
      142,
      22.879368,
      1,
      23,
      3,
      NULL,
      NULL,
      2.862863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      4,
      0,
      3,
      2,
      0,
      0,
      5,
      0,
      7.350562,
      1,
      1,
      1,
      2,
      0.550115,
      NULL,
      NULL,
      1.003031,
      NULL,
      NULL,
      4,
      5,
      3,
      1,
      2,
      0.438983,
      2.525379,
      3.435824,
      2.445762,
      NULL,
      1,
      3,
      NULL,
      0,
      1.196038,
      1,
      1.386589,
      2.194979,
      NULL,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      5,
      1.672446,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      1,
      1.249599,
      NULL,
      0.047883,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      2,
      2,
      1,
      2,
      0,
      5,
      0,
      4,
      2,
      NULL,
      1,
      5,
      4,
      3,
      3,
      1,
      3,
      3.664331,
      NULL,
      120,
      ' 9- 8-1979',
      62.460187,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      1.492625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.925302,
      1.615938,
      NULL,
      3,
      1.510699,
      NULL,
      NULL,
      2,
      1,
      5.062355,
      2.915267,
      2.684936,
      3,
      0,
      1,
      1,
      1.827506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895213,
      1,
      0.065546,
      NULL,
      0.958391,
      0,
      NULL,
      0.600530,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.696026,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      3,
      0.142417,
      3,
      4.228429,
      NULL,
      46.342695,
      53,
      172,
      NULL,
      83,
      1.482198,
      0,
      0.151132,
      NULL,
      1.426948,
      0.606053,
      NULL,
      1,
      5.898956,
      1.255244,
      5,
      2,
      NULL,
      1.248545,
      6.598754,
      NULL,
      NULL,
      1,
      3,
      3.658939,
      1,
      0,
      NULL,
      0,
      3.595918,
      NULL,
      36,
      38,
      12.600250,
      2,
      2.128805,
      0.492036,
      '11130',
      '',
      NULL,
      1,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      4,
      NULL,
      35.967383,
      2,
      NULL,
      NULL,
      1.795369,
      1,
      NULL,
      3.431382,
      1.693654,
      1.046044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      0,
      0.947287,
      0.620466,
      1,
      NULL,
      3,
      0,
      2.765576,
      0.406223,
      1.988032,
      NULL,
      2,
      NULL,
      3.037704,
      2,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0.767542,
      4.816217,
      5.146975,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.115637,
      NULL,
      NULL,
      NULL,
      0.949337,
      3,
      1,
      3,
      NULL,
      2.868373,
      1.922785,
      2.545435,
      2.344269,
      2.569267,
      2.965418,
      3.697585,
      3,
      0.244758,
      2,
      0.957912,
      1.815350,
      3,
      2,
      2.376526,
      1,
      NULL,
      0,
      2.695620,
      3.462462,
      NULL,
      3.362005,
      0,
      0.200455,
      0.054836,
      3.277872,
      0.313234,
      NULL,
      NULL,
      1.510846,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.447716,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.377871,
      1.194366,
      0.706839,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.488291,
      NULL,
      NULL,
      0.515190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.967952,
      1.469646,
      0.977835,
      3,
      5.920359,
      5,
      NULL,
      NULL,
      3,
      3,
      NULL,
      2.769582,
      6.934485,
      NULL,
      3,
      1.768063,
      0,
      0,
      3.458121,
      3.870652,
      2,
      3.939537,
      5,
      5,
      3,
      3.968603,
      NULL,
      1.915907,
      0,
      2,
      2.594178,
      NULL,
      3.431318,
      NULL,
      2.720886,
      NULL,
      2.672780,
      8.927141,
      5.233467,
      4.272819,
      3.539073,
      2.018686,
      3.146633,
      2,
      2,
      2,
      1.960200,
      NULL,
      0.406996,
      0.527402,
      1.189540,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810360,
      1,
      1.539906,
      0,
      NULL,
      NULL,
      1.852064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.620691,
      3.741001,
      3,
      0.111499,
      NULL,
      3.165866,
      0.772476,
      NULL,
      NULL,
      0.582879,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      183,
      NULL,
      1.387058,
      1,
      0.738560,
      1,
      1.493314,
      1,
      1.532779,
      1,
      0,
      NULL,
      1,
      0.555038,
      1.594449,
      0,
      NULL,
      NULL,
      0,
      1.818336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.888529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.761036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.677671,
      2.759970,
      NULL,
      0.069654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.742491,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.704371,
      NULL,
      3,
      NULL,
      4.716790,
      NULL,
      3.510895,
      NULL,
      3.870107,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022550,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.113784,
      NULL,
      0.803715,
      NULL,
      1.153141,
      NULL,
      NULL,
      NULL,
      0.487544,
      NULL,
      1,
      NULL,
      NULL,
      0.115330,
      3.452681,
      53,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      2,
      0.365458,
      NULL,
      2.442106,
      2,
      2,
      1.059134,
      1,
      1.445403,
      NULL,
      NULL,
      NULL,
      0.057007,
      1.126650,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1.423132,
      0.316694,
      NULL,
      NULL,
      0,
      NULL,
      0.105450,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      2.470735,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.751529,
      NULL,
      3,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      36.937783,
      1,
      2,
      2.068129,
      '20333',
      '40120',
      NULL,
      1,
      '',
      '',
      '',
      0.909288,
      '',
      '',
      NULL);
commit;
end;
/


