set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7941726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3,
      0,
      2.303706,
      3,
      1.356516,
      0.586578,
      NULL,
      NULL,
      NULL,
      79.400575,
      83.358599,
      '1100244',
      NULL,
      1.717738,
      4,
      2,
      '1303',
      NULL,
      0,
      NULL,
      NULL,
      ' 7-18-1995',
      78,
      41.403822,
      NULL,
      0,
      0,
      ' 5-26-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '11-24-1997',
      NULL,
      0.164530,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      282,
      5,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      7,
      2.674848,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      5,
      2,
      NULL,
      0,
      1,
      1,
      6.282413,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175865,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      0,
      3.764544,
      0,
      1.563492,
      NULL,
      1.779370,
      NULL,
      0,
      NULL,
      3.385300,
      2,
      1,
      0,
      0,
      0,
      NULL,
      1,
      8,
      NULL,
      2,
      0,
      1.338602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      5,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      0.611710,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      4,
      0,
      0,
      0,
      1,
      NULL,
      5,
      0,
      NULL,
      2,
      4,
      5,
      NULL,
      NULL,
      2,
      5,
      1,
      0,
      NULL,
      1,
      NULL,
      ' 3-25-1990',
      25,
      ' 3-24-1985',
      1252,
      3.333266,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0.958263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633468,
      0,
      3,
      0,
      0.744057,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.838779,
      1,
      9.898532,
      6.713797,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.955749,
      1.928793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.543320,
      NULL,
      NULL,
      0,
      1.512950,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1,
      3,
      3,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      2.547115,
      1,
      1.372055,
      0,
      1,
      2,
      0.015643,
      1.691874,
      3,
      0,
      0,
      0.107965,
      1.511555,
      0.158319,
      0,
      NULL,
      0.305655,
      0,
      NULL,
      10.283276,
      0,
      6.677897,
      1.172210,
      4,
      5,
      3.448221,
      4,
      1,
      3.794726,
      0,
      6.390496,
      1,
      0.491800,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.516666,
      1.615159,
      '20414',
      NULL,
      '',
      0.800055,
      '',
      '',
      '',
      0.102082,
      '03103',
      '',
      '',
      0.831766,
      13,
      325.772592,
      29.632631,
      2,
      40.216174,
      9,
      37,
      3,
      1.848511,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.873359,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.285678,
      NULL,
      NULL,
      0.770062,
      0.237455,
      3.085172,
      2.028547,
      0.297796,
      3.443701,
      3,
      0,
      NULL,
      3,
      NULL,
      1,
      3,
      0,
      1,
      1,
      1.647404,
      1,
      3.172856,
      0.097432,
      9.973635,
      NULL,
      0.744082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      3.984384,
      0.193130,
      NULL,
      0,
      1.537731,
      3,
      0,
      1.947969,
      NULL,
      0,
      1.714627,
      1,
      0.932791,
      2,
      0,
      2.021833,
      NULL,
      NULL,
      0.207972,
      1,
      1,
      1,
      1.462540,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.745517,
      NULL,
      0.938492,
      9,
      0.058721,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338534,
      0.124309,
      1,
      2.194271,
      0.738794,
      NULL,
      NULL,
      1.380647,
      0,
      1,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1.471450,
      NULL,
      1,
      3,
      0.188104,
      NULL,
      0,
      0.319435,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158355,
      NULL,
      NULL,
      1.761409,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.748567,
      NULL,
      NULL,
      1.598557,
      1,
      1.317436,
      1.350085,
      0.061706,
      5.675105,
      NULL,
      1,
      6.272477,
      1,
      NULL,
      NULL,
      3.634082,
      1.872485,
      2,
      1.075127,
      1,
      3,
      1,
      2.187520,
      2,
      8,
      1.091147,
      5,
      3.056891,
      1,
      2,
      3,
      0,
      1.454840,
      2,
      NULL,
      NULL,
      NULL,
      1.289231,
      NULL,
      9,
      0,
      8,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1.954581,
      0.622033,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.965697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.401565,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1.713804,
      1,
      0.637123,
      NULL,
      NULL,
      1.886980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.986332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.509150,
      NULL,
      NULL,
      NULL,
      0.896416,
      NULL,
      NULL,
      NULL,
      3.690577,
      NULL,
      NULL,
      NULL,
      0.462712,
      NULL,
      NULL,
      NULL,
      2.161034,
      34.241972,
      297,
      2,
      4,
      2.994414,
      0.873125,
      NULL,
      NULL,
      2,
      18.858658,
      NULL,
      NULL,
      1.930229,
      1,
      0.448039,
      NULL,
      NULL,
      0.903617,
      NULL,
      1.883851,
      98.305990,
      NULL,
      0,
      1.965194,
      0.058706,
      0,
      1.001462,
      0.278279,
      NULL,
      0.650172,
      0,
      NULL,
      1.490192,
      1.062955,
      1.029832,
      0,
      0.894518,
      1,
      1.492912,
      1.369140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.196706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.859111,
      NULL,
      1.637331,
      NULL,
      0.614471,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.115591,
      NULL,
      NULL,
      0.911349,
      0.521460,
      NULL,
      1.847541,
      NULL,
      0.112838,
      NULL,
      NULL,
      NULL,
      0.776652,
      NULL,
      1.300419,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.533965,
      NULL,
      0.957287,
      NULL,
      1.637070,
      NULL,
      NULL,
      NULL,
      0.583744,
      NULL,
      NULL,
      NULL,
      1.286136,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.404015,
      0,
      NULL,
      0.316670,
      NULL,
      0.109391,
      NULL,
      NULL,
      NULL,
      1.635500,
      NULL,
      2,
      0.940534,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.780305,
      0,
      0,
      NULL,
      3,
      42,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1.042765,
      0.555380,
      0,
      0,
      1.828157,
      0,
      NULL,
      0.120869,
      0.994641,
      1.111979,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527417,
      1.515198,
      NULL,
      1,
      1.169146,
      NULL,
      0.255806,
      0.904736,
      NULL,
      NULL,
      1.565266,
      NULL,
      0.830825,
      NULL,
      NULL,
      1.636297,
      2,
      NULL,
      0.334807,
      0.393496,
      NULL,
      0.840356,
      0,
      NULL,
      1,
      3.603693,
      NULL,
      2,
      1.061321,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.375770,
      NULL,
      3,
      3,
      6,
      NULL,
      NULL,
      2.597265,
      NULL,
      75.308621,
      4,
      1.144091,
      4,
      '12404',
      '43402',
      '',
      1.351390,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '',
      '');
commit;
end;
/


