set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9681977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      2,
      0.488117,
      2,
      0,
      NULL,
      5,
      3,
      '130',
      '04112440',
      19,
      52.867822,
      '0331202',
      NULL,
      1.276016,
      3,
      0,
      '1304',
      1,
      NULL,
      NULL,
      NULL,
      '10- 2-1993',
      70.209781,
      141.554679,
      NULL,
      1.998722,
      2.384742,
      ' 2-21-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '11- 4-1993',
      1.544770,
      0.623589,
      0.978646,
      NULL,
      1,
      3,
      1,
      1.790827,
      NULL,
      NULL,
      NULL,
      13.977843,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1,
      1.507158,
      4,
      NULL,
      0,
      2,
      1,
      0,
      5,
      5,
      NULL,
      0,
      4,
      NULL,
      7.358980,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      0.203944,
      NULL,
      NULL,
      4,
      NULL,
      5.103809,
      3,
      1.739484,
      3.117174,
      3,
      2,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      1,
      3.143036,
      1,
      1,
      1.232677,
      1,
      0,
      0,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      0.655066,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      5,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.750509,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      5,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      5,
      1,
      5,
      3,
      0,
      2,
      0,
      1,
      1.620605,
      0,
      '10-25-1979',
      81.014453,
      ' 6-23-1977',
      7.571597,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2,
      2,
      1,
      0.330637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      9.857216,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.944873,
      0.800965,
      0,
      1.172843,
      NULL,
      NULL,
      4,
      1,
      0,
      3.064258,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175979,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.497323,
      0.719735,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      2,
      NULL,
      2,
      3,
      NULL,
      1,
      1,
      3,
      2,
      NULL,
      0,
      NULL,
      3.397556,
      1.179979,
      0.069510,
      0,
      NULL,
      1.570159,
      0.394084,
      NULL,
      0.772963,
      0,
      0,
      1,
      NULL,
      NULL,
      3.221174,
      0.978013,
      11.043238,
      NULL,
      0,
      4.523395,
      6.776397,
      NULL,
      1,
      1.793148,
      3,
      0,
      1.273393,
      1,
      25,
      3,
      0.665750,
      64,
      NULL,
      NULL,
      NULL,
      0,
      0.544710,
      4,
      '02441',
      '22423',
      NULL,
      1.912021,
      '',
      '',
      NULL,
      0.843295,
      '',
      '',
      NULL,
      NULL,
      2,
      NULL,
      16,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.962335,
      3.905875,
      0.157634,
      NULL,
      NULL,
      0.611976,
      NULL,
      NULL,
      0,
      0.274352,
      1.597552,
      0,
      NULL,
      NULL,
      1.742406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.978367,
      0.483890,
      0.629758,
      0.747062,
      1,
      1,
      0,
      1,
      1.724836,
      1.167836,
      1,
      NULL,
      NULL,
      NULL,
      3.295318,
      2,
      NULL,
      0,
      0.703577,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.966955,
      NULL,
      3,
      2.770710,
      1,
      2,
      1.131826,
      0,
      1.099821,
      1,
      NULL,
      NULL,
      1.804685,
      2,
      0,
      1.398110,
      2.793648,
      0.219937,
      0.882090,
      2.720000,
      1,
      2,
      NULL,
      1,
      1.835173,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.523099,
      0.824057,
      NULL,
      1.646940,
      1,
      NULL,
      0,
      0.188216,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.708866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234338,
      NULL,
      NULL,
      1.673205,
      NULL,
      NULL,
      2.226715,
      1,
      1.755167,
      1.009203,
      NULL,
      NULL,
      3.971062,
      NULL,
      NULL,
      0.312158,
      NULL,
      NULL,
      1.797779,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.141338,
      NULL,
      NULL,
      0.938831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.819419,
      NULL,
      0.014104,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.216399,
      NULL,
      NULL,
      0.452878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.074298,
      1.880234,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.927193,
      1,
      1.681042,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      5,
      1.404560,
      1.804258,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.463482,
      0.831560,
      0,
      1,
      0.259026,
      NULL,
      NULL,
      NULL,
      1.263533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.402208,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.255145,
      NULL,
      NULL,
      2.755025,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1,
      1.290209,
      0,
      1.622941,
      0.175138,
      0,
      1.451497,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.390670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.765603,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.108821,
      NULL,
      NULL,
      NULL,
      1.218724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.035979,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.038979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.609046,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.532620,
      NULL,
      NULL,
      1.334838,
      NULL,
      NULL,
      NULL,
      NULL,
      1.016769,
      14,
      1,
      0.989159,
      0,
      0.241284,
      0.202896,
      0.948886,
      1.416458,
      NULL,
      0.758596,
      NULL,
      1,
      NULL,
      NULL,
      0.654983,
      0.763201,
      0.239507,
      0,
      2,
      1.806383,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.415302,
      NULL,
      42.998617,
      NULL,
      0,
      NULL,
      31,
      NULL,
      0,
      1.919674,
      NULL,
      0.974148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.216624,
      NULL,
      1.758241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.192797,
      NULL,
      1.163416,
      NULL,
      3.206677,
      0.369317,
      0.810439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.560319,
      NULL,
      NULL,
      NULL,
      1.693346,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.841848,
      NULL,
      1,
      1.534540,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.558431,
      NULL,
      1.751259,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.198602,
      3.731228,
      NULL,
      NULL,
      NULL,
      86.705257,
      NULL,
      1.883736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203439,
      1,
      7,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3,
      1.870959,
      3.756245,
      1,
      1,
      0,
      6.612961,
      3.881227,
      3.398430,
      0,
      1,
      1.813073,
      NULL,
      1,
      NULL,
      NULL,
      0.606374,
      0,
      NULL,
      1,
      0.671412,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.282120,
      NULL,
      0.302789,
      2.613840,
      NULL,
      NULL,
      0.968367,
      NULL,
      0.996800,
      0.938095,
      NULL,
      1.168903,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.089934,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      29.195905,
      1,
      4.939556,
      7,
      '40332',
      '43342',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


