set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925188';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      3.779143,
      0,
      4,
      NULL,
      '3041',
      2.734019,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1986',
      27.079655,
      NULL,
      3,
      0,
      2,
      '10- 6-1976',
      32.570741,
      NULL,
      NULL,
      NULL,
      3,
      ' 6-20-1995',
      ' 9-13-1977',
      NULL,
      1,
      0.746310,
      NULL,
      0.885060,
      0.961086,
      0.599751,
      NULL,
      1.542614,
      NULL,
      NULL,
      NULL,
      13,
      0,
      15.833749,
      6,
      1,
      18,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.231418,
      1,
      1,
      3.372487,
      1,
      0.013620,
      0,
      3,
      4,
      4,
      0,
      NULL,
      0,
      0,
      3,
      4,
      1,
      5,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      2,
      NULL,
      1.401792,
      NULL,
      NULL,
      1.970255,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      3,
      3,
      NULL,
      1,
      1,
      3,
      1,
      0,
      6.222838,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1.520626,
      NULL,
      3,
      NULL,
      1,
      1,
      3,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      3,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      2,
      1,
      0,
      1,
      8,
      2.745979,
      ' 2- 9-1990',
      7,
      ' 8- 3-1987',
      1,
      0,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.581605,
      1.682165,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.418918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543394,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      13.971451,
      NULL,
      0.178159,
      NULL,
      NULL,
      NULL,
      3,
      0.898051,
      1,
      1,
      2,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314257,
      13.964479,
      13,
      NULL,
      NULL,
      1.178731,
      NULL,
      0.503480,
      1.574889,
      0.285732,
      NULL,
      0,
      1,
      0.510830,
      0.529800,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505751,
      NULL,
      6,
      53,
      61,
      5,
      1.903596,
      0.548935,
      '44310',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.914428,
      23.291548,
      6.985530,
      19,
      1.315244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.756971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.084029,
      NULL,
      NULL,
      1.290930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.896121,
      NULL,
      NULL,
      0.638862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.758961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.745400,
      NULL,
      1.764488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821171,
      5,
      0.381268,
      NULL,
      0.507784,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.294311,
      0,
      NULL,
      NULL,
      0.814722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.009474,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.199803,
      NULL,
      NULL,
      NULL,
      4.948403,
      2.760777,
      3,
      NULL,
      NULL,
      NULL,
      3,
      3.604503,
      0.936930,
      1.690889,
      NULL,
      NULL,
      0.343117,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      7.184200,
      3,
      3.089786,
      2,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      1.256191,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.901317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.906828,
      1.074251,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747896,
      1.671236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.103587,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.008809,
      1.869505,
      NULL,
      NULL,
      1.524930,
      0.895573,
      NULL,
      NULL,
      1,
      0.157655,
      NULL,
      NULL,
      1.925055,
      1,
      NULL,
      NULL,
      0.956034,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.766194,
      NULL,
      NULL,
      NULL,
      1.092535,
      NULL,
      NULL,
      NULL,
      0.948864,
      NULL,
      NULL,
      0.013495,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.224401,
      1,
      0.089946,
      0.725767,
      1.195944,
      NULL,
      1,
      0.923805,
      0,
      0,
      NULL,
      NULL,
      1.291357,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.891514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      3.202382,
      NULL,
      2.658591,
      NULL,
      2,
      6.353700,
      3,
      NULL,
      3.199905,
      0,
      0,
      0.076119,
      1,
      1,
      1,
      NULL,
      1.390917,
      0.810885,
      0,
      1.961182,
      1,
      0,
      1,
      0,
      0.069208,
      1.675540,
      NULL,
      3.807785,
      NULL,
      3.030734,
      3,
      2.990333,
      2,
      0.969290,
      1,
      0.478419,
      NULL,
      2,
      0.307692,
      1,
      1.017447,
      1,
      0.595895,
      1.455815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.096110,
      0,
      0.383642,
      1,
      NULL,
      0,
      NULL,
      4,
      0.627425,
      NULL,
      NULL,
      77.018870,
      NULL,
      4,
      0,
      2,
      '21240',
      '12200',
      '',
      0.259838,
      '01440',
      '',
      '',
      1,
      NULL,
      NULL,
      '');
commit;
end;
/


