set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925188';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '2204033',
      0.589024,
      NULL,
      NULL,
      NULL,
      '3123',
      3,
      1,
      NULL,
      NULL,
      ' 2- 3-1979',
      20,
      NULL,
      5,
      1,
      1,
      '11- 2-1979',
      17.583258,
      NULL,
      85.102091,
      26.620402,
      1,
      ' 0-14-1997',
      ' 5-15-2001',
      NULL,
      2.020509,
      NULL,
      2.895608,
      2.328133,
      NULL,
      3,
      0,
      2.210668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      21.468096,
      1,
      0,
      7,
      1.191272,
      2,
      NULL,
      0,
      NULL,
      1.017440,
      0.981226,
      0,
      0.149261,
      NULL,
      NULL,
      3,
      0,
      5,
      2.641421,
      0,
      0,
      0,
      3,
      0,
      1,
      3,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      1,
      0.686010,
      NULL,
      NULL,
      1.005829,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.132956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      0,
      NULL,
      2,
      5,
      1,
      NULL,
      1,
      2,
      0,
      1,
      7.407526,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1.119712,
      1,
      0,
      0,
      1,
      2,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      5,
      NULL,
      NULL,
      5,
      7,
      1.414182,
      ' 1- 4-1999',
      5,
      NULL,
      0,
      1.793063,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      1,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.513906,
      0,
      NULL,
      4.624213,
      1.447336,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.402397,
      1.026205,
      0,
      NULL,
      0.963270,
      NULL,
      10,
      3.779563,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.508751,
      3,
      1,
      2,
      3,
      0,
      3,
      1,
      0,
      0,
      0,
      5,
      NULL,
      3.851779,
      3.481949,
      NULL,
      44.031604,
      NULL,
      165.810608,
      102.724352,
      1,
      1.268357,
      NULL,
      1.931359,
      NULL,
      NULL,
      1,
      9,
      3.169018,
      0.433454,
      3,
      6,
      NULL,
      2,
      1.639277,
      4,
      0.779036,
      1.914951,
      NULL,
      3.907566,
      0.823880,
      0.734710,
      28,
      2,
      3,
      NULL,
      4,
      5,
      54.695986,
      5,
      0,
      2.584857,
      '12403',
      '',
      '',
      0.044480,
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      1.053963,
      4,
      11,
      20.297467,
      1.910510,
      NULL,
      NULL,
      NULL,
      NULL,
      0.804005,
      NULL,
      NULL,
      1.098841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.224859,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.582578,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.864074,
      NULL,
      NULL,
      1.286851,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.525894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.100092,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.787541,
      NULL,
      0.769182,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.035770,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.366706,
      1,
      1.853058,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.174381,
      NULL,
      0.141176,
      NULL,
      NULL,
      3.071273,
      3,
      1.970426,
      0,
      NULL,
      NULL,
      3,
      2,
      0,
      1.700839,
      NULL,
      NULL,
      10.815330,
      NULL,
      NULL,
      1.464893,
      NULL,
      NULL,
      1,
      NULL,
      0.744998,
      3,
      5.105352,
      NULL,
      NULL,
      7,
      3,
      2,
      2,
      2,
      1,
      1.352866,
      0.831834,
      1,
      1,
      0.205460,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.878230,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.718555,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.716356,
      NULL,
      NULL,
      NULL,
      0,
      0.423896,
      1.712472,
      1,
      2.420204,
      2.591730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.738266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.369011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445422,
      0,
      NULL,
      NULL,
      0.608624,
      1.387469,
      NULL,
      NULL,
      0,
      0.976580,
      NULL,
      NULL,
      0.613563,
      1.228118,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.125188,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.868040,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.757628,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.401711,
      1.237660,
      NULL,
      0.169481,
      1.219286,
      1.931135,
      0.356811,
      0.330830,
      0.361198,
      0.232528,
      1.900373,
      0,
      1.809347,
      0,
      1,
      1.392641,
      0,
      0.853290,
      0.526774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      7.733290,
      2,
      1,
      NULL,
      NULL,
      4.218982,
      3.886871,
      0,
      3,
      1,
      0,
      1.224821,
      1.842462,
      NULL,
      0.051555,
      1,
      1.810295,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.836976,
      0,
      3.658435,
      3.187280,
      NULL,
      NULL,
      3.113221,
      NULL,
      NULL,
      1.036226,
      0,
      0,
      0,
      0.315332,
      NULL,
      3.075488,
      NULL,
      1.178282,
      0.270155,
      2.156457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.075832,
      2,
      4,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      66.515691,
      4,
      1,
      0.253829,
      NULL,
      '02200',
      '',
      1.817869,
      '30412',
      '34342',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


