set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9607352';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      3,
      '4020',
      3,
      0,
      NULL,
      NULL,
      ' 6-23-1983',
      31.531413,
      NULL,
      0,
      NULL,
      NULL,
      ' 3-28-1993',
      NULL,
      3.464725,
      235,
      106.427215,
      0,
      ' 0- 3-1990',
      ' 2-14-1984',
      ' 8-23-1983',
      2.221852,
      0.444860,
      NULL,
      NULL,
      0.061031,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.076345,
      NULL,
      13,
      0.120684,
      1,
      9,
      3,
      3,
      6,
      0.787410,
      1,
      NULL,
      1,
      1.407066,
      1,
      NULL,
      1.885269,
      0.633878,
      2.847401,
      0.506496,
      3,
      NULL,
      4,
      2,
      NULL,
      0,
      1,
      5,
      NULL,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.318547,
      0,
      1.840914,
      1.307581,
      2.300456,
      2,
      1.512734,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.054952,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      4,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.669048,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      4,
      3,
      0,
      0,
      2,
      1,
      1,
      0,
      5,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.196533,
      0,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      2,
      2,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      2,
      NULL,
      1,
      ' 9-20-1983',
      385.598679,
      ' 4-14-1975',
      9.041055,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0.525032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.737021,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375966,
      0,
      1.782016,
      0,
      0,
      NULL,
      0.935176,
      7,
      NULL,
      0.402282,
      NULL,
      1.665967,
      NULL,
      NULL,
      NULL,
      1.227950,
      3.696794,
      1.769209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.095299,
      0,
      NULL,
      0,
      0.104820,
      0,
      1,
      1,
      18,
      3.387328,
      0.616226,
      NULL,
      NULL,
      NULL,
      0,
      1.189320,
      2.888956,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      2.612309,
      3,
      1,
      1.242766,
      0,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.075471,
      0.567759,
      1,
      1,
      3,
      3.423656,
      0.440894,
      8.350122,
      1.428599,
      NULL,
      6.366693,
      NULL,
      3.257370,
      NULL,
      0,
      7,
      2.761171,
      3,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      66,
      70,
      4,
      NULL,
      1.008656,
      '14031',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      '2124',
      NULL,
      '',
      1,
      NULL,
      23,
      16,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.082580,
      NULL,
      NULL,
      1.714723,
      NULL,
      NULL,
      0.172212,
      NULL,
      NULL,
      0.944808,
      NULL,
      NULL,
      0.624627,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.366856,
      NULL,
      NULL,
      1.998935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.694779,
      1.893221,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.440574,
      NULL,
      NULL,
      NULL,
      0.632952,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682103,
      NULL,
      NULL,
      1.479237,
      NULL,
      NULL,
      0,
      0,
      0.548215,
      2.365561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439017,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0.638694,
      NULL,
      NULL,
      5,
      1.031510,
      0,
      NULL,
      0,
      0,
      1.963439,
      1.777968,
      1,
      NULL,
      0.009877,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.703582,
      NULL,
      NULL,
      1.692334,
      0,
      1,
      1.725405,
      NULL,
      NULL,
      4.997836,
      2.678698,
      NULL,
      0.456161,
      2.657123,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.558453,
      NULL,
      2,
      NULL,
      0.824564,
      NULL,
      1.159979,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.146273,
      NULL,
      NULL,
      1.212989,
      NULL,
      1,
      6,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480905,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.234084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.755521,
      2,
      0,
      0.065789,
      NULL,
      2,
      NULL,
      NULL,
      0,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.048571,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.076901,
      NULL,
      NULL,
      1.306751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.162650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0.324553,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.231109,
      3.336203,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.858825,
      0,
      NULL,
      NULL,
      0,
      7.301448,
      NULL,
      NULL,
      2.845521,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.743677,
      3,
      2,
      0.838259,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.470148,
      0,
      1,
      0.485456,
      NULL,
      NULL,
      1.008769,
      1,
      1.238189,
      0.687747,
      1,
      1.747299,
      NULL,
      NULL,
      1.601150,
      1.714329,
      0,
      NULL,
      0,
      0,
      NULL,
      1.130374,
      NULL,
      1.792813,
      NULL,
      1,
      NULL,
      0.832806,
      NULL,
      1.819047,
      NULL,
      1,
      NULL,
      1.911450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.323811,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.452636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.528231,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.895335,
      NULL,
      1,
      NULL,
      1.801640,
      NULL,
      1,
      NULL,
      1.494970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900712,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.071117,
      NULL,
      2.660793,
      NULL,
      0,
      NULL,
      223,
      NULL,
      1,
      NULL,
      1.812729,
      NULL,
      0,
      1,
      NULL,
      5,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.527101,
      0,
      1.228281,
      1.530557,
      2,
      3,
      0,
      3.808311,
      2,
      NULL,
      1.352539,
      0.706187,
      NULL,
      0.495826,
      2.924215,
      1,
      1,
      16,
      NULL,
      3,
      NULL,
      3.963214,
      2.471979,
      3.205875,
      NULL,
      2,
      2.824670,
      1.509996,
      0.197694,
      0,
      1.827569,
      1,
      1.168749,
      0,
      0,
      0,
      3.883079,
      1.294765,
      2,
      0,
      1,
      1.960271,
      0.226105,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.816233,
      NULL,
      0,
      NULL,
      4,
      NULL,
      1.306499,
      NULL,
      NULL,
      42.496957,
      17,
      0,
      2,
      4.629521,
      '04000',
      '14203',
      '',
      1.729450,
      NULL,
      '',
      NULL,
      1,
      '2203',
      '',
      NULL);
commit;
end;
/


