set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '41',
      '31',
      13.801822,
      3.797948,
      '0332202',
      1,
      0.610403,
      NULL,
      2,
      '1032',
      0.274102,
      1,
      NULL,
      NULL,
      NULL,
      49,
      11.938619,
      NULL,
      1,
      6.986963,
      ' 3-27-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 1-20-1985',
      NULL,
      0.539534,
      0.076667,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5.112676,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.931754,
      0,
      1,
      1,
      0,
      0.258512,
      0,
      1.345503,
      0.609478,
      0,
      0,
      NULL,
      1,
      1,
      0.491621,
      0,
      NULL,
      1,
      1,
      NULL,
      4,
      2,
      4,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.108088,
      NULL,
      NULL,
      5,
      0,
      1.308502,
      1,
      0.979778,
      1,
      0,
      0.382260,
      2,
      1.046726,
      NULL,
      NULL,
      2,
      1,
      3.951651,
      1.992397,
      1,
      0.801478,
      1,
      3,
      2,
      1,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      1.223652,
      0,
      0,
      1,
      0,
      0.508612,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      3,
      4,
      3,
      1,
      NULL,
      NULL,
      1,
      2,
      2,
      ' 7-13-1998',
      NULL,
      NULL,
      6.203140,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      2,
      0,
      3.854973,
      NULL,
      0.377387,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      10.745418,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981698,
      0.912622,
      4,
      0,
      0.820317,
      2.311990,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.859888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.373422,
      NULL,
      1.592659,
      1,
      1.894782,
      0,
      NULL,
      NULL,
      9.547198,
      1.287557,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      0.305547,
      1.313156,
      7,
      1,
      NULL,
      0.153677,
      NULL,
      1.629532,
      NULL,
      1,
      1.386259,
      1.129868,
      1,
      0.741397,
      1,
      0,
      1.878232,
      NULL,
      1,
      6,
      NULL,
      7,
      2,
      10,
      NULL,
      5.869520,
      0.110714,
      7.649499,
      2,
      3,
      1,
      70,
      3,
      1.886440,
      61,
      NULL,
      2,
      3.087234,
      0,
      1.659042,
      0.689355,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.411471,
      NULL,
      '',
      '',
      1,
      48,
      37.251077,
      NULL,
      1.627441,
      NULL,
      NULL,
      NULL,
      NULL,
      2.919597,
      NULL,
      0.184065,
      NULL,
      NULL,
      NULL,
      0.242910,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.260563,
      NULL,
      NULL,
      0.787681,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.583423,
      5,
      0,
      0,
      1.230416,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.486582,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200025,
      NULL,
      NULL,
      1.273241,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.061768,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.414872,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.813065,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470862,
      NULL,
      NULL,
      1.201118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.651836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.209061,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.367683,
      NULL,
      NULL,
      1.619432,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899422,
      NULL,
      NULL,
      0,
      3,
      0.409561,
      0,
      NULL,
      NULL,
      0.483019,
      NULL,
      NULL,
      NULL,
      1.542882,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.955628,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0.274514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.448216,
      1.797694,
      1,
      0.845818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.729972,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      0.605129,
      NULL,
      NULL,
      0.062650,
      NULL,
      NULL,
      1.055988,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      47,
      592.187701,
      1,
      0,
      0,
      NULL,
      1.021511,
      1.558545,
      0,
      1.265451,
      1,
      1.572916,
      1,
      0,
      1.332654,
      NULL,
      1,
      NULL,
      0.084367,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.672522,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.254421,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.842284,
      NULL,
      1,
      1.885319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      2.112271,
      2,
      2,
      NULL,
      0,
      8.788850,
      0,
      NULL,
      0.794771,
      0.282045,
      0.895651,
      NULL,
      0,
      1.047667,
      NULL,
      2.209649,
      0.929574,
      NULL,
      0.736525,
      1,
      NULL,
      NULL,
      0.774685,
      NULL,
      0,
      1.707449,
      NULL,
      0.440756,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.257457,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.221872,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.023837,
      NULL,
      0.294986,
      NULL,
      1,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      80.295482,
      4,
      0.583191,
      3.285548,
      '43043',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


