set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6.500990,
      0,
      1.708380,
      3.496912,
      0,
      2,
      NULL,
      0,
      '303',
      NULL,
      17,
      57.112708,
      NULL,
      4.696597,
      1,
      0,
      2,
      '0223',
      2.366394,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.402851,
      1,
      ' 1- 0-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 3-19-1993',
      NULL,
      ' 2- 5-1991',
      0.817554,
      1,
      NULL,
      0.369276,
      1.753215,
      2,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.640199,
      0,
      1,
      0.050982,
      0.168281,
      3,
      NULL,
      0,
      1.886365,
      1.434167,
      0.296123,
      3,
      3,
      1,
      3.549219,
      3,
      1,
      NULL,
      0,
      1,
      3,
      NULL,
      1,
      1,
      0,
      0,
      1,
      3.307294,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      3.843500,
      1,
      2,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      NULL,
      0,
      2,
      0.958448,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      1.856075,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850654,
      NULL,
      1,
      3,
      1,
      0,
      1,
      5,
      1,
      0,
      2,
      4,
      5,
      3,
      1,
      NULL,
      1,
      5,
      2,
      0,
      5,
      2,
      3,
      2,
      2,
      1,
      1,
      1,
      0.855503,
      1.331900,
      ' 6-16-2001',
      25.829302,
      NULL,
      NULL,
      0.459962,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      0.130823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      1.572443,
      0.027468,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.391931,
      0,
      4,
      4,
      5.273533,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      3,
      NULL,
      '11-13-1998',
      0.684600,
      ' 2-10-2003',
      7,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      10,
      NULL,
      3,
      65,
      8,
      26,
      NULL,
      0.363915,
      NULL,
      0,
      NULL,
      1,
      3,
      2,
      0,
      1,
      3,
      3,
      NULL,
      3.067883,
      1,
      1.733940,
      1,
      1.153817,
      0.078529,
      0,
      1,
      0.456167,
      1,
      0.539858,
      0,
      1,
      1.619184,
      1,
      1,
      NULL,
      1.661717,
      1,
      0.173055,
      2.103438,
      4.740901,
      NULL,
      9.716727,
      2.300759,
      4.512925,
      1,
      6,
      2,
      NULL,
      3.131478,
      42.132299,
      NULL,
      NULL,
      11,
      NULL,
      62,
      33,
      NULL,
      0.414737,
      3,
      '42342',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      111,
      45,
      3.939126,
      59,
      3.582057,
      0,
      1,
      1,
      3.237995,
      NULL,
      0.015939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569445,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.543942,
      NULL,
      1.961891,
      1,
      NULL,
      NULL,
      1.876509,
      NULL,
      NULL,
      1.099960,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488298,
      NULL,
      NULL,
      NULL,
      0.880274,
      0.746671,
      0.838651,
      0,
      0.546769,
      0.892745,
      0.565498,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.278102,
      1.754331,
      1,
      NULL,
      2.871113,
      1.905878,
      1,
      2,
      NULL,
      1,
      3,
      2,
      0,
      NULL,
      1,
      1.234570,
      3.730329,
      1.704517,
      NULL,
      1.789868,
      NULL,
      NULL,
      10.700635,
      NULL,
      0,
      1,
      0.441233,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.677311,
      0.207623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940042,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.280689,
      NULL,
      NULL,
      1.459422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.146912,
      NULL,
      NULL,
      5,
      0.774873,
      1.187101,
      5.256488,
      1.020952,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.901398,
      0,
      3,
      0,
      0.611659,
      0,
      1.893514,
      0.158888,
      3.060566,
      0.120257,
      3.825358,
      1.899832,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.133327,
      2,
      1,
      3.110551,
      NULL,
      NULL,
      7,
      0.339766,
      7.182115,
      NULL,
      0.545090,
      2,
      1,
      3,
      3,
      0,
      0,
      0,
      0.041074,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714813,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.071593,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0.046519,
      NULL,
      2,
      NULL,
      3.058451,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.314070,
      1.967261,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.223014,
      NULL,
      NULL,
      0.575103,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.065816,
      0.600363,
      NULL,
      0,
      0.980848,
      1.031102,
      NULL,
      1,
      0,
      1.401170,
      NULL,
      2,
      0.753292,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      0.325882,
      NULL,
      0,
      1.007570,
      0.659476,
      NULL,
      3,
      10.351713,
      0.063792,
      NULL,
      1.721702,
      1,
      NULL,
      NULL,
      NULL,
      1.485040,
      NULL,
      1.714336,
      NULL,
      3.035987,
      0.378557,
      1.222626,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.742734,
      NULL,
      NULL,
      NULL,
      NULL,
      1.350108,
      315,
      2.516369,
      1.677076,
      NULL,
      0.837418,
      NULL,
      0.377351,
      0,
      0,
      0,
      1,
      0.002512,
      0,
      1,
      0.375865,
      1,
      1.829827,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107029,
      0.588804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.411858,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.731063,
      1.942676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366868,
      0.204110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.135356,
      1.428814,
      NULL,
      3.855954,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.791802,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.413220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.987200,
      2.320658,
      0,
      NULL,
      2,
      2,
      3.126160,
      NULL,
      0,
      0,
      0.944554,
      1.278916,
      NULL,
      0.788779,
      1,
      3.123053,
      NULL,
      1.287927,
      0,
      1.385375,
      NULL,
      1.281430,
      1,
      NULL,
      1,
      1.723399,
      0.707615,
      NULL,
      0,
      0.272463,
      1,
      NULL,
      1.399783,
      1,
      NULL,
      0,
      3.661713,
      0.366257,
      0.033788,
      NULL,
      NULL,
      0.030768,
      1.702271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276960,
      0,
      0,
      0,
      1,
      NULL,
      3,
      1,
      0.701741,
      1,
      0.094819,
      43,
      83.845326,
      5,
      1.833921,
      0,
      '24303',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


