set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621028';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '1444433',
      2.970442,
      0,
      4,
      1,
      '4040',
      1,
      0,
      NULL,
      NULL,
      ' 4-11-1983',
      12,
      NULL,
      4,
      0,
      1.806185,
      ' 0-15-1991',
      28.304739,
      1.737008,
      18.348235,
      170.769202,
      3,
      ' 8- 9-1974',
      ' 9- 2-1977',
      ' 4-28-1990',
      NULL,
      3,
      0,
      NULL,
      1,
      3,
      NULL,
      0.853083,
      NULL,
      NULL,
      NULL,
      1.214421,
      NULL,
      19,
      21,
      0,
      16.118330,
      2,
      3,
      5.273061,
      3.032788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      2,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      0,
      2,
      2,
      0,
      1.246449,
      NULL,
      NULL,
      0.320686,
      NULL,
      NULL,
      3,
      0,
      1,
      2,
      NULL,
      1,
      2.618234,
      2.825407,
      NULL,
      3.831585,
      2.275989,
      0,
      1.941315,
      2,
      NULL,
      0,
      2.449984,
      3,
      1,
      1,
      NULL,
      1,
      9,
      NULL,
      NULL,
      2.880837,
      NULL,
      NULL,
      NULL,
      0.486351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      1,
      1,
      0,
      0,
      3,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      1,
      5,
      2,
      1,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      4,
      0,
      1,
      0,
      0,
      5,
      5,
      NULL,
      NULL,
      3,
      1,
      ' 4- 2-1996',
      230,
      ' 3-13-1992',
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.537007,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1.477244,
      0,
      16.814754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.118442,
      1,
      0,
      3,
      1,
      0,
      3,
      1,
      1,
      2,
      1,
      2,
      3.199227,
      NULL,
      NULL,
      0,
      NULL,
      1,
      5,
      NULL,
      1.852894,
      NULL,
      NULL,
      0,
      1,
      1,
      1.315591,
      1,
      0,
      2,
      0,
      NULL,
      1.055625,
      5.419425,
      0,
      11.866931,
      NULL,
      5,
      0.512332,
      5,
      2,
      0,
      0.283028,
      32.692320,
      NULL,
      NULL,
      NULL,
      54,
      3,
      63.045786,
      NULL,
      3,
      0.225236,
      '21012',
      '',
      '',
      1,
      '',
      '',
      '',
      1.866149,
      '',
      '',
      '',
      2,
      20.947487,
      116,
      9.454526,
      1,
      35,
      5.812472,
      4.365583,
      3,
      1,
      3.029128,
      2.359046,
      1.171580,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.963714,
      NULL,
      0.243863,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.951063,
      3.251782,
      1,
      1.578257,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.653264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136440,
      NULL,
      NULL,
      1.857865,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.372089,
      1,
      2.885311,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      2,
      NULL,
      1.052294,
      0.464361,
      NULL,
      1.864705,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.390748,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      2.729045,
      1,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      4.580202,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.263333,
      NULL,
      NULL,
      1.397736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691993,
      NULL,
      NULL,
      1.545450,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.539287,
      2,
      2,
      0.242380,
      3.653236,
      1,
      0,
      1,
      3.549313,
      4,
      NULL,
      0.177468,
      NULL,
      1.820969,
      NULL,
      3,
      2,
      1.787734,
      2,
      2.768781,
      NULL,
      2.520087,
      NULL,
      0.499562,
      1,
      1.199957,
      2,
      NULL,
      2.233641,
      2.497873,
      NULL,
      0.566476,
      3,
      1.727669,
      0,
      0.686834,
      3,
      2.540049,
      2.370962,
      5.632119,
      5.531110,
      0.328308,
      6,
      2.204366,
      0.855503,
      0,
      2,
      2,
      0,
      1.063265,
      0.270468,
      NULL,
      0.880455,
      3,
      NULL,
      NULL,
      1.909951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222182,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.653818,
      NULL,
      NULL,
      5.979413,
      NULL,
      NULL,
      0.445727,
      0,
      1.824547,
      1.014623,
      NULL,
      3.832144,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520272,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.432494,
      NULL,
      NULL,
      NULL,
      1.020040,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.017676,
      NULL,
      NULL,
      NULL,
      1.852254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.527865,
      0.575933,
      NULL,
      NULL,
      1.161295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      27,
      5,
      NULL,
      1,
      0.710662,
      1.326460,
      1.141589,
      0.074119,
      0,
      1,
      0,
      0.898348,
      NULL,
      1,
      1.821564,
      NULL,
      1,
      0.739809,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.670375,
      1.714550,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.872430,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.259502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787911,
      0.571150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.440016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      5.223153,
      2,
      5.124519,
      3,
      0,
      2,
      2.914689,
      NULL,
      1.552222,
      0,
      0.151379,
      NULL,
      0,
      0.541278,
      NULL,
      0.792778,
      1.093626,
      NULL,
      1.668387,
      NULL,
      NULL,
      0.209552,
      0.848205,
      NULL,
      0.497370,
      2.694519,
      NULL,
      1.662987,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.435591,
      1,
      NULL,
      1.018281,
      0,
      NULL,
      3,
      0,
      0.588555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      2,
      1,
      NULL,
      NULL,
      NULL,
      28,
      3,
      1,
      3,
      NULL,
      '',
      '',
      1.342814,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


