set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5.894703,
      3.932195,
      2,
      1,
      0,
      2.356901,
      NULL,
      0.135187,
      '433',
      '20101032',
      40,
      NULL,
      '0131101',
      7,
      NULL,
      6,
      NULL,
      NULL,
      5.065437,
      NULL,
      NULL,
      NULL,
      NULL,
      49.430816,
      221.932288,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 1-24-1986',
      0.819307,
      1.771641,
      1.356343,
      3.813144,
      NULL,
      0.645697,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      10.786389,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      1,
      0,
      1.399380,
      1,
      1,
      NULL,
      1,
      1.707482,
      0.901836,
      1.842879,
      3,
      0,
      6,
      0,
      2,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      3,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      5,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.196149,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      5,
      0,
      NULL,
      0,
      5,
      3,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0.072996,
      NULL,
      1,
      0,
      4,
      0,
      0,
      0,
      3,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0,
      5,
      0,
      NULL,
      3,
      1,
      1,
      NULL,
      1,
      2,
      5.622566,
      3.082345,
      NULL,
      23.584824,
      NULL,
      NULL,
      0,
      0,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      2,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.503660,
      2,
      1,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477244,
      NULL,
      1.774681,
      NULL,
      0.371739,
      0.905497,
      1,
      0,
      NULL,
      0,
      0.469633,
      NULL,
      NULL,
      NULL,
      1,
      0.520163,
      0,
      NULL,
      1,
      NULL,
      2,
      3,
      1,
      2,
      3,
      0,
      0,
      2,
      3.523591,
      3,
      NULL,
      0,
      1,
      1,
      0.637351,
      NULL,
      NULL,
      0,
      1.085890,
      0,
      1,
      NULL,
      NULL,
      1.217989,
      2,
      0,
      NULL,
      3.784808,
      2,
      1,
      0,
      2,
      NULL,
      1,
      6,
      1,
      0.552926,
      2,
      11,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      '02403',
      '',
      '',
      1.894295,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      57,
      25,
      24.663734,
      3,
      35.262327,
      NULL,
      3.151150,
      NULL,
      1,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.689649,
      NULL,
      NULL,
      2.762909,
      1.733025,
      2.511056,
      3,
      3.040000,
      3.972556,
      2,
      3,
      2,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.211148,
      0.257981,
      1.884136,
      0,
      NULL,
      NULL,
      7.612045,
      11,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.841892,
      NULL,
      NULL,
      NULL,
      0.065447,
      1,
      3,
      2.810164,
      NULL,
      1.971605,
      NULL,
      NULL,
      0,
      3.102272,
      NULL,
      0,
      3,
      0,
      1,
      2,
      0,
      0,
      3,
      3.808697,
      2,
      3,
      3,
      1,
      0,
      1.964599,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      8.012832,
      6.630667,
      1,
      0.346807,
      NULL,
      NULL,
      NULL,
      0.882953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      2,
      1.640017,
      0.035819,
      1,
      NULL,
      NULL,
      2,
      3.988206,
      2,
      2.989199,
      3.480505,
      2,
      0.063408,
      1.750125,
      1.737700,
      5,
      6.663461,
      NULL,
      0.438818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7.467517,
      0,
      NULL,
      1.219381,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.498788,
      1.195437,
      0,
      3.783030,
      2,
      8.588552,
      0,
      4,
      1.264818,
      3.818363,
      NULL,
      NULL,
      NULL,
      1.552740,
      1,
      1.868427,
      1,
      2.033003,
      2.991644,
      3,
      8.407975,
      4,
      0.255444,
      2.451337,
      1.169830,
      5.726311,
      NULL,
      2,
      NULL,
      1.743562,
      0.666482,
      NULL,
      1.564019,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154584,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.073110,
      NULL,
      NULL,
      1.208562,
      NULL,
      NULL,
      1.439996,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.197173,
      NULL,
      NULL,
      4.511651,
      NULL,
      NULL,
      1.659134,
      1.064338,
      0.862010,
      NULL,
      0.708716,
      1.454251,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.649543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.388969,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.003635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276581,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1.309247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.990920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.266783,
      NULL,
      0,
      611.921154,
      1.796875,
      1.292282,
      0,
      1,
      NULL,
      NULL,
      1.842577,
      1.194309,
      0,
      0,
      NULL,
      1.883718,
      0.226972,
      1,
      1.423612,
      1,
      0.516500,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      2,
      2,
      3,
      NULL,
      2,
      2.239071,
      1,
      1.736072,
      1,
      NULL,
      0.431302,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.251081,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.838840,
      NULL,
      NULL,
      0.579646,
      NULL,
      1.196076,
      NULL,
      NULL,
      0.465544,
      0,
      NULL,
      1.754140,
      0.354523,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364843,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      130,
      0,
      1.400976,
      NULL,
      NULL,
      '',
      '',
      0.799218,
      '',
      '',
      '',
      1.392725,
      '',
      '',
      '');
commit;
end;
/


