set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      0,
      4.047326,
      0.824716,
      3.756363,
      NULL,
      NULL,
      2,
      '324',
      NULL,
      34,
      23.158422,
      '0113424',
      0,
      NULL,
      2,
      2,
      '1301',
      5.583767,
      1,
      NULL,
      NULL,
      ' 1-21-1991',
      NULL,
      96,
      NULL,
      1,
      0,
      ' 2- 3-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 1-18-1990',
      ' 0-19-1996',
      '10-12-1977',
      3.185352,
      NULL,
      NULL,
      3.983907,
      NULL,
      1.367134,
      NULL,
      NULL,
      NULL,
      5.663001,
      4,
      15,
      7.666200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      0.134436,
      1,
      0.194620,
      NULL,
      1,
      3.562082,
      NULL,
      1,
      3,
      1,
      5,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      2,
      6.789949,
      0,
      1,
      NULL,
      2,
      0.546962,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      0.764030,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.105422,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      7.961564,
      NULL,
      1,
      0,
      0,
      1.150500,
      NULL,
      0.063149,
      0,
      NULL,
      2,
      1,
      0,
      4,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      5,
      NULL,
      4,
      4,
      0,
      5,
      3,
      5,
      3,
      3,
      4.952749,
      0,
      ' 4- 8-1990',
      110,
      '10-29-1996',
      214.081580,
      0.545455,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665209,
      NULL,
      5.204589,
      1,
      0.414324,
      3.262490,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101918,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.872830,
      1.785458,
      0.536281,
      NULL,
      1,
      NULL,
      0.420700,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.878609,
      0.669378,
      NULL,
      1,
      1,
      2,
      0,
      1,
      0,
      3,
      2,
      1,
      0.293001,
      0.121808,
      3,
      0.851431,
      0,
      1,
      1,
      0.578077,
      1.592580,
      0.960651,
      1.005830,
      1.153864,
      0,
      1.861737,
      1.353544,
      0,
      0,
      NULL,
      0.673284,
      10.465634,
      4.927242,
      6,
      5.436635,
      4,
      5.752753,
      1,
      0,
      3,
      2,
      0,
      0.594035,
      0.057744,
      1,
      1.770566,
      27,
      NULL,
      1,
      61.711471,
      1,
      5,
      NULL,
      '32442',
      '',
      '',
      1.818989,
      NULL,
      NULL,
      '',
      1.508170,
      '',
      '',
      NULL,
      2.471547,
      37,
      24,
      20,
      0.681485,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0.645920,
      NULL,
      NULL,
      0.800296,
      NULL,
      NULL,
      NULL,
      3.946450,
      0,
      1,
      3.251285,
      0,
      3,
      1,
      1.874893,
      0.948046,
      NULL,
      0,
      2.467666,
      3.207680,
      2,
      3,
      1.488004,
      3,
      NULL,
      NULL,
      NULL,
      3,
      2.011950,
      3,
      1,
      NULL,
      NULL,
      9,
      7.379366,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.258870,
      3.013545,
      3.303988,
      1,
      0,
      1,
      3,
      0.693122,
      2,
      2,
      0.547146,
      0.835446,
      1.148228,
      2.936840,
      2,
      0,
      NULL,
      NULL,
      2.370696,
      2,
      3.943499,
      3.515175,
      0.112308,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.138729,
      NULL,
      NULL,
      6.917387,
      7.282562,
      5.842516,
      0,
      0.486516,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.500988,
      NULL,
      NULL,
      3.853840,
      3,
      1,
      2,
      0.317242,
      0,
      1,
      NULL,
      NULL,
      3.793913,
      1.988078,
      1.843150,
      0.023869,
      3.630142,
      1.008220,
      0.432095,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.016987,
      NULL,
      NULL,
      1.905910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.091992,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242056,
      0.311315,
      NULL,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.564850,
      1,
      2,
      2,
      2.905409,
      10,
      NULL,
      3.120882,
      3,
      NULL,
      3.944744,
      0.986979,
      3,
      NULL,
      1.459282,
      2.313303,
      3,
      3.695736,
      NULL,
      1.099083,
      5,
      NULL,
      1,
      3,
      NULL,
      4,
      2.763196,
      1,
      2,
      1.406798,
      0.858717,
      NULL,
      0.108406,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.297047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      4.248909,
      NULL,
      NULL,
      1,
      1.328621,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.182611,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.850603,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.243400,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.838645,
      NULL,
      NULL,
      NULL,
      3.357350,
      4.953797,
      5,
      1.544596,
      NULL,
      NULL,
      1.965770,
      NULL,
      NULL,
      1.693010,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.939133,
      NULL,
      NULL,
      1,
      NULL,
      0.000631,
      55,
      0,
      0,
      1.105288,
      1.575944,
      1,
      0.309365,
      1,
      1,
      1,
      NULL,
      1.566956,
      1.486498,
      1.431474,
      NULL,
      NULL,
      0,
      0.708347,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      6,
      1,
      5,
      0.703722,
      2,
      7,
      0,
      0.739515,
      1,
      1.714769,
      NULL,
      NULL,
      NULL,
      0.630501,
      NULL,
      0.229673,
      0,
      NULL,
      0,
      1.240419,
      NULL,
      0,
      0.599671,
      NULL,
      0,
      NULL,
      NULL,
      3.496341,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.818814,
      NULL,
      NULL,
      NULL,
      NULL,
      1.479543,
      0,
      1.896136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057114,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      65,
      69,
      NULL,
      0.525757,
      2.361797,
      '44443',
      '',
      '',
      1.390805,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


