set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9026888';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '2324021',
      0,
      1.169775,
      0,
      0,
      '1300',
      1.556183,
      0.972564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.050150,
      0.676706,
      NULL,
      47,
      2,
      NULL,
      148,
      3,
      ' 3-23-1998',
      ' 2-27-1986',
      '10- 0-1995',
      2.119883,
      0,
      3,
      1,
      0.574293,
      3,
      3,
      1.638495,
      0,
      2,
      2,
      6,
      8,
      19,
      1,
      5,
      25,
      4,
      3,
      6.536833,
      0.568034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      3,
      0,
      0,
      1,
      NULL,
      1,
      0,
      2,
      NULL,
      2,
      1,
      1,
      6,
      0,
      NULL,
      NULL,
      NULL,
      1.306042,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      5.203607,
      0.869246,
      0.841423,
      1.193240,
      NULL,
      1.572075,
      3,
      1,
      1.021376,
      1,
      1.307053,
      3,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      5,
      5,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      4,
      3,
      0,
      0,
      5,
      1,
      1,
      1,
      3.309515,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.721350,
      5,
      1,
      4,
      NULL,
      1,
      0,
      2,
      0,
      1,
      2,
      5,
      NULL,
      0,
      NULL,
      5,
      1,
      3,
      4,
      2,
      NULL,
      1,
      5,
      NULL,
      NULL,
      1,
      1.612391,
      3,
      ' 1-18-1995',
      1192.044363,
      ' 4-12-1978',
      777.658264,
      0.762931,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      0.627613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.983808,
      2,
      2,
      NULL,
      0.203599,
      4.400336,
      1.463508,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.162061,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.183062,
      1.611397,
      NULL,
      1,
      1.065661,
      1.651779,
      2,
      43,
      2,
      0.473492,
      NULL,
      NULL,
      NULL,
      1,
      1.638565,
      0.846838,
      NULL,
      2,
      2,
      1,
      0,
      3,
      3,
      3,
      2,
      3,
      NULL,
      3,
      0,
      1.674120,
      1.952009,
      1,
      NULL,
      1,
      1.712222,
      0,
      0,
      1.167386,
      1,
      0.774633,
      0,
      0,
      1.260481,
      3,
      1.714482,
      10,
      NULL,
      2.691664,
      8.848453,
      8,
      0.882524,
      NULL,
      0.972708,
      NULL,
      NULL,
      3,
      NULL,
      53.300912,
      0,
      2.210673,
      NULL,
      75,
      15,
      73,
      5,
      NULL,
      0,
      NULL,
      '',
      '',
      1.415591,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL,
      2.127357,
      46,
      47.139450,
      40.012894,
      2,
      NULL,
      3,
      3.826057,
      0,
      3,
      1,
      0.277293,
      1,
      NULL,
      NULL,
      1.448662,
      NULL,
      NULL,
      0.153006,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.717111,
      NULL,
      NULL,
      2.951551,
      2.024528,
      3.000833,
      0.001114,
      NULL,
      NULL,
      1.713498,
      3.371799,
      2,
      1.473238,
      NULL,
      NULL,
      0.585167,
      3,
      1.473961,
      0.324012,
      NULL,
      NULL,
      9.731400,
      NULL,
      4,
      1,
      1.917267,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.204373,
      0,
      0,
      1.116449,
      1.397006,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      0.621105,
      3,
      0.651463,
      0,
      NULL,
      0,
      1,
      0.571790,
      1.332048,
      2.442139,
      1,
      0,
      0.440020,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.499044,
      5,
      5,
      1.472592,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834913,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.400892,
      NULL,
      NULL,
      0.609045,
      NULL,
      NULL,
      1.482191,
      NULL,
      NULL,
      0,
      1,
      1.794997,
      1.313122,
      NULL,
      NULL,
      3,
      0.647728,
      0,
      0.280715,
      NULL,
      NULL,
      0.783223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.226954,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.026371,
      1,
      NULL,
      0.197892,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.182358,
      1.275108,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      3.485768,
      3.671639,
      1,
      NULL,
      0.501805,
      0.721163,
      1,
      NULL,
      1.338164,
      2,
      3,
      1,
      3.172836,
      1,
      1,
      1.797353,
      6.207413,
      1,
      NULL,
      1,
      1,
      0,
      0.259072,
      2,
      4,
      1.587061,
      1,
      0,
      1,
      1.776963,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.230583,
      NULL,
      NULL,
      1,
      0.215701,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.249827,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.951529,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.490532,
      NULL,
      NULL,
      NULL,
      0.590444,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712243,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0.180041,
      NULL,
      NULL,
      NULL,
      3.587965,
      136,
      128,
      1.640478,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      0.786787,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      87,
      41.323843,
      NULL,
      0.023505,
      0,
      1.233252,
      1.752913,
      1,
      0.753358,
      1,
      1,
      0,
      1,
      1.973275,
      1.236119,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.552873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.388576,
      NULL,
      0.761986,
      NULL,
      0.704132,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.835424,
      3,
      NULL,
      0.826776,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.045656,
      1.217541,
      1,
      NULL,
      NULL,
      1,
      0.758714,
      0,
      1.849727,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3.587771,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.309733,
      1.621932,
      1,
      0.158938,
      NULL,
      NULL,
      NULL,
      2.610350,
      NULL,
      2.020023,
      NULL,
      NULL,
      1.148637,
      0.447152,
      NULL,
      1,
      1.154169,
      NULL,
      0.323709,
      0,
      NULL,
      1,
      1.340210,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.287291,
      0,
      NULL,
      0.681950,
      NULL,
      NULL,
      0,
      NULL,
      0.714314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116608,
      NULL,
      1.730679,
      NULL,
      1,
      NULL,
      3,
      6,
      2,
      NULL,
      1,
      3,
      3,
      37.665570,
      NULL,
      0.971673,
      1.087754,
      '32402',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


