set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '2103203',
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.744194,
      0,
      NULL,
      NULL,
      '10-17-1995',
      31,
      NULL,
      5,
      2,
      0,
      '10-26-2001',
      22,
      3.758966,
      43.703486,
      102.495285,
      NULL,
      ' 4- 6-1978',
      ' 5-28-1997',
      '10-28-2000',
      NULL,
      0,
      0.133041,
      1,
      NULL,
      1.586526,
      0,
      1.926821,
      NULL,
      4.376321,
      1,
      15,
      4,
      NULL,
      0,
      3,
      NULL,
      4,
      3,
      4,
      0,
      0,
      NULL,
      0,
      0.381137,
      1,
      0.520091,
      1,
      1,
      NULL,
      0.292604,
      0,
      5,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      3,
      0,
      1,
      5,
      5,
      2,
      1,
      6.743997,
      1,
      2,
      2,
      1,
      0.163456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.740324,
      3.709802,
      0,
      1.137233,
      0.497876,
      NULL,
      2.316118,
      2,
      0.568291,
      1,
      0,
      3.656519,
      1,
      NULL,
      2.543372,
      1,
      3.680992,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      1.700857,
      1.039262,
      NULL,
      NULL,
      0.518778,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0.441713,
      NULL,
      1.710730,
      1,
      1,
      NULL,
      5,
      0,
      0,
      3,
      1,
      1,
      NULL,
      1,
      3,
      4,
      0,
      0,
      3,
      4,
      0,
      3,
      NULL,
      2,
      NULL,
      4,
      1,
      0,
      0,
      1.470405,
      '11-13-1989',
      10.521221,
      ' 3-28-1992',
      53,
      0.501956,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1.938403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.889764,
      0.432579,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.390350,
      NULL,
      2.872965,
      5.286115,
      1.242582,
      9.324519,
      1.808656,
      NULL,
      NULL,
      NULL,
      3.958465,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0.689228,
      0.328099,
      5.029657,
      1.426564,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.853900,
      2.642767,
      0,
      2,
      NULL,
      0,
      1,
      1,
      3,
      2,
      1,
      3,
      1.378841,
      0,
      NULL,
      NULL,
      1.564468,
      1,
      1,
      NULL,
      1.282483,
      0,
      0.404999,
      1.199379,
      0.211753,
      0.889091,
      1,
      NULL,
      NULL,
      NULL,
      0.871228,
      NULL,
      0,
      5.064953,
      7,
      11.551365,
      5.521633,
      5,
      1.983616,
      NULL,
      3.339800,
      2,
      1.733346,
      NULL,
      2,
      3,
      NULL,
      29,
      55,
      3.516339,
      2,
      1,
      0,
      '00032',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      '',
      0,
      17.369239,
      NULL,
      NULL,
      1,
      10.654025,
      2.538516,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.564152,
      1.446569,
      2.638818,
      3.661082,
      1.153846,
      0.725537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.421150,
      NULL,
      NULL,
      NULL,
      NULL,
      2.336232,
      3.277992,
      0.803683,
      1.517220,
      2,
      NULL,
      3,
      1,
      0.472759,
      1.302450,
      NULL,
      NULL,
      3,
      5.905508,
      0.832210,
      NULL,
      0.421799,
      NULL,
      NULL,
      NULL,
      2.745850,
      0,
      1.886169,
      1,
      0,
      1.609246,
      3,
      0,
      2,
      0,
      2,
      1.906200,
      NULL,
      3.053825,
      1.146398,
      1,
      3,
      1,
      1,
      3.179084,
      0,
      1.290684,
      0.980085,
      NULL,
      0.968330,
      1,
      0.767691,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.604007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.231315,
      1.258727,
      9,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.176568,
      2.094918,
      NULL,
      0.530279,
      NULL,
      NULL,
      1.065325,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185112,
      0.683503,
      NULL,
      NULL,
      NULL,
      4.092269,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.726516,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.888609,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935158,
      NULL,
      NULL,
      1.716440,
      2.716694,
      1.422472,
      4.848147,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.854462,
      0.758401,
      0,
      1.063603,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.120855,
      NULL,
      2.145710,
      NULL,
      0.163386,
      5.596477,
      4.863437,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      4,
      0,
      1,
      0,
      0.850563,
      1,
      3,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.697931,
      NULL,
      NULL,
      0.090871,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      3.076304,
      3.406631,
      NULL,
      3.090727,
      NULL,
      0,
      NULL,
      2.162784,
      NULL,
      NULL,
      NULL,
      7.047754,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.312655,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113572,
      1.433860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606091,
      2,
      NULL,
      NULL,
      0.424605,
      NULL,
      NULL,
      NULL,
      0.961787,
      0.580813,
      NULL,
      NULL,
      0.100212,
      NULL,
      NULL,
      NULL,
      1.501806,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      2,
      2.362145,
      NULL,
      NULL,
      4,
      1.829155,
      NULL,
      NULL,
      0.416122,
      2.609295,
      NULL,
      2,
      NULL,
      2,
      35.835340,
      12.155353,
      2,
      0,
      2,
      1.011484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215754,
      NULL,
      NULL,
      1.666754,
      NULL,
      NULL,
      0,
      NULL,
      0,
      16306.329335,
      304.129420,
      0,
      1.192949,
      1.562215,
      1,
      1,
      NULL,
      0.617275,
      0,
      1.299168,
      0.152238,
      1.085753,
      NULL,
      1,
      0,
      1.656358,
      1,
      1.699370,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.023785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      5.091982,
      1.997369,
      4,
      3.536317,
      1,
      13.126979,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.612478,
      1.439311,
      NULL,
      2.315338,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0.939708,
      3,
      NULL,
      2,
      NULL,
      NULL,
      1.655566,
      0,
      NULL,
      0.477492,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      2.549269,
      1.727331,
      NULL,
      1.739902,
      NULL,
      1.375448,
      NULL,
      1.181810,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.683109,
      NULL,
      1.145892,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.377203,
      NULL,
      0.279593,
      NULL,
      149.609212,
      1,
      NULL,
      1.886394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631333,
      NULL,
      NULL,
      NULL,
      0.819315,
      NULL,
      4,
      2,
      2,
      NULL,
      NULL,
      NULL,
      54,
      130,
      5,
      0.836731,
      2.996003,
      '32310',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '21204',
      '00123',
      '');
commit;
end;
/


