set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '3321310',
      3,
      0,
      0,
      1,
      '4144',
      3.166889,
      1,
      NULL,
      NULL,
      '10-12-1981',
      NULL,
      NULL,
      NULL,
      1,
      0,
      ' 1- 9-1996',
      22.872787,
      0,
      NULL,
      21,
      1,
      ' 8- 7-1984',
      ' 8-13-1992',
      ' 7- 6-1980',
      0.187017,
      3.316814,
      NULL,
      2,
      1,
      0,
      1,
      0,
      NULL,
      1.124449,
      NULL,
      18.546972,
      3,
      6,
      19,
      3,
      NULL,
      2,
      3,
      NULL,
      1.813495,
      NULL,
      1,
      0,
      NULL,
      0.024606,
      0,
      1,
      0,
      0.100346,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      1,
      0,
      1,
      1,
      2,
      0,
      1,
      2,
      1,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      1.631583,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      0,
      0,
      0,
      2.511920,
      2.537109,
      0.069719,
      2.872204,
      1.459036,
      1.662546,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.245674,
      NULL,
      1,
      1.051751,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.484079,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063632,
      NULL,
      1,
      NULL,
      2,
      1,
      3,
      1,
      0,
      4,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      4,
      1,
      4,
      NULL,
      2,
      3,
      NULL,
      3,
      3,
      1,
      1.036530,
      2,
      '11-19-1993',
      185.502845,
      ' 6-14-1989',
      148,
      3,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.328255,
      1,
      2.548493,
      1,
      4.719460,
      1.972177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.667077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      0.337105,
      0,
      1,
      1.951632,
      33,
      0.576257,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      3,
      3,
      0,
      NULL,
      1,
      2,
      3,
      3,
      2,
      1,
      5.141178,
      2.876690,
      1,
      1.440600,
      1,
      0,
      0.816485,
      1,
      NULL,
      1,
      1,
      1.816425,
      1.608316,
      0.508286,
      0,
      1,
      5.253236,
      1,
      1.872409,
      4,
      NULL,
      0.523637,
      1,
      3.395292,
      3,
      0,
      5,
      2,
      NULL,
      3.509525,
      53,
      NULL,
      2.668047,
      NULL,
      33,
      67,
      12.082243,
      NULL,
      1,
      1.707585,
      '14244',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '30221',
      '33311',
      '',
      0.330010,
      15.591673,
      45,
      35.520259,
      NULL,
      35.401641,
      0.851559,
      0,
      2,
      2.808660,
      2,
      1.683511,
      0,
      NULL,
      NULL,
      0.556721,
      3.065334,
      0,
      0.742628,
      2,
      1,
      0.843659,
      NULL,
      NULL,
      1.860035,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.724500,
      NULL,
      NULL,
      NULL,
      2,
      0.100519,
      3,
      2.149663,
      3,
      2.996374,
      0.256653,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.183334,
      1.776822,
      NULL,
      1,
      2,
      2,
      3,
      NULL,
      2.398674,
      0.733612,
      1,
      1.372878,
      1,
      0.623841,
      NULL,
      NULL,
      3.400074,
      2,
      NULL,
      0.579000,
      0.656369,
      1.842450,
      0.898444,
      1.040327,
      1,
      2,
      0.391919,
      0.670978,
      2.259026,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      2.882262,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.482237,
      1,
      1.992592,
      NULL,
      NULL,
      0.873279,
      NULL,
      NULL,
      1,
      2,
      1.188846,
      1.840165,
      NULL,
      NULL,
      7,
      1,
      0,
      0,
      NULL,
      NULL,
      1.760306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.430511,
      NULL,
      NULL,
      1.446132,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.746346,
      NULL,
      5.756048,
      2,
      1.999997,
      NULL,
      NULL,
      2.327361,
      1,
      1.840889,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.580688,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.072489,
      NULL,
      0,
      2,
      2,
      2.706477,
      1,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      1.296864,
      NULL,
      1.753702,
      NULL,
      3,
      NULL,
      NULL,
      5.620441,
      NULL,
      NULL,
      11.847492,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.779361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.791214,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.757495,
      NULL,
      NULL,
      3.798400,
      NULL,
      NULL,
      1.408111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.144005,
      NULL,
      NULL,
      NULL,
      2,
      3.441318,
      1,
      0.118888,
      2,
      0.948935,
      NULL,
      4.255206,
      0.381055,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.136560,
      NULL,
      NULL,
      NULL,
      1.663049,
      NULL,
      NULL,
      NULL,
      1.321962,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.521505,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.217451,
      2,
      NULL,
      NULL,
      0.790848,
      3.060727,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.839042,
      NULL,
      NULL,
      3.204589,
      1,
      NULL,
      NULL,
      3.584805,
      8.970401,
      NULL,
      NULL,
      2.289041,
      3.750272,
      0,
      8,
      3,
      2,
      20.466440,
      0,
      2.342368,
      NULL,
      1.043584,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.657979,
      NULL,
      NULL,
      0.973031,
      NULL,
      1,
      NULL,
      691.752039,
      0.290060,
      0.163050,
      0,
      NULL,
      1.862613,
      NULL,
      NULL,
      0.221264,
      0.591532,
      1.190662,
      NULL,
      0.469525,
      1,
      0,
      NULL,
      0.729174,
      0.932059,
      1.738749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      5,
      3,
      2,
      7.495826,
      2,
      1.376286,
      0,
      1,
      0.585255,
      NULL,
      1,
      0.238042,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0.495792,
      NULL,
      0,
      3,
      NULL,
      0.447913,
      0.187745,
      NULL,
      1.724161,
      2.919018,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.097274,
      NULL,
      0,
      2.456388,
      NULL,
      1.324985,
      0.095312,
      NULL,
      0.616846,
      0,
      0,
      0.261441,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.799295,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.458817,
      NULL,
      0.721377,
      NULL,
      1.971795,
      NULL,
      NULL,
      NULL,
      3.625696,
      NULL,
      1.398086,
      NULL,
      NULL,
      0.005131,
      NULL,
      0.807120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.726417,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3,
      4,
      1.589659,
      NULL,
      NULL,
      NULL,
      145,
      0,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.876091,
      '',
      '',
      '',
      0.070506,
      '00424',
      NULL,
      '');
commit;
end;
/


