set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '1410102',
      3,
      0,
      4,
      3,
      '3140',
      1,
      NULL,
      NULL,
      NULL,
      ' 2-15-1989',
      22,
      NULL,
      NULL,
      1.058703,
      NULL,
      '10- 7-1982',
      0.544605,
      0.719979,
      NULL,
      55,
      3,
      ' 8- 4-1981',
      ' 8-23-1981',
      ' 8-17-1993',
      0.421274,
      NULL,
      3.216631,
      NULL,
      0.051156,
      1.227216,
      1,
      NULL,
      1.858158,
      NULL,
      NULL,
      8.555368,
      7,
      157.315761,
      76.097280,
      0,
      NULL,
      NULL,
      0,
      2,
      0.837989,
      0,
      0,
      0,
      1.292717,
      1,
      1.361190,
      2,
      1,
      0.704614,
      0.762787,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      9.579380,
      1,
      1,
      0,
      0,
      0.481790,
      NULL,
      NULL,
      1.835827,
      NULL,
      NULL,
      4,
      0,
      1,
      NULL,
      1,
      1.433851,
      1,
      3.723791,
      NULL,
      NULL,
      2,
      1.096746,
      2,
      NULL,
      1.964629,
      0,
      0.741757,
      0.831422,
      NULL,
      0,
      NULL,
      2,
      2.237917,
      3,
      2,
      0,
      1.112420,
      NULL,
      NULL,
      1.134271,
      NULL,
      NULL,
      0,
      2,
      5,
      0,
      3,
      0,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.624732,
      NULL,
      3,
      0,
      1,
      0,
      3,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      0,
      NULL,
      0,
      2,
      ' 0-10-1976',
      125.913280,
      NULL,
      21,
      0,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0.757344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1496.933938,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8.927640,
      1,
      1,
      1.411879,
      1.758609,
      NULL,
      NULL,
      NULL,
      1.321140,
      0.538834,
      1.659283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.980603,
      1,
      1.278016,
      NULL,
      0,
      1.356245,
      2.446406,
      NULL,
      1.219023,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      18,
      27,
      62,
      3,
      NULL,
      2.101021,
      '01020',
      NULL,
      '',
      1.069679,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      1.225910,
      30.015606,
      1.547892,
      8.859933,
      NULL,
      NULL,
      3.105047,
      NULL,
      2,
      NULL,
      3,
      3.504145,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.901644,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.930700,
      0.922020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114937,
      NULL,
      NULL,
      0.224356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.758577,
      NULL,
      0,
      1.696829,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005528,
      NULL,
      1,
      1.271547,
      2.716728,
      2.710318,
      0.744433,
      1.297610,
      1.275418,
      0,
      0,
      2.330335,
      0,
      1.512927,
      1,
      3.880451,
      1,
      NULL,
      NULL,
      1.435348,
      0,
      0,
      0,
      0.315782,
      0.491099,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.918312,
      NULL,
      NULL,
      11,
      10,
      9.957099,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      3.668614,
      NULL,
      1.671113,
      0.003203,
      NULL,
      NULL,
      3.949772,
      2,
      4,
      NULL,
      0.691500,
      0,
      NULL,
      NULL,
      NULL,
      5,
      4,
      1,
      0.171545,
      NULL,
      NULL,
      1.669064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.410415,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.032855,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.950155,
      NULL,
      1,
      1.597800,
      NULL,
      NULL,
      0,
      6.708968,
      7.045756,
      3,
      NULL,
      0.517673,
      NULL,
      2,
      0.041807,
      NULL,
      NULL,
      NULL,
      2.581158,
      0,
      NULL,
      10.995303,
      7,
      9.569874,
      NULL,
      NULL,
      NULL,
      0.104676,
      3,
      2,
      1.739637,
      1.730201,
      1.065393,
      0.007180,
      1.394625,
      1,
      NULL,
      NULL,
      0.844651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498775,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.211659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.186662,
      1,
      1.497282,
      NULL,
      1,
      3.377428,
      2.491487,
      NULL,
      NULL,
      1.457383,
      1.178836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.640382,
      NULL,
      NULL,
      1.854876,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.375949,
      NULL,
      NULL,
      0.557282,
      NULL,
      NULL,
      NULL,
      2.923699,
      NULL,
      NULL,
      NULL,
      2.987973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      2.245870,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.507100,
      1,
      NULL,
      NULL,
      3,
      0.260694,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.359220,
      NULL,
      NULL,
      1.900745,
      2.504737,
      2,
      0,
      2,
      37.863275,
      NULL,
      1.044278,
      NULL,
      NULL,
      1.404370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861897,
      NULL,
      NULL,
      0,
      NULL,
      0,
      13180.335918,
      1192.588973,
      NULL,
      0.141447,
      0.433795,
      0,
      0.367318,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1.626927,
      0.734293,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.867452,
      0.475171,
      2.352854,
      3,
      2,
      9.514695,
      NULL,
      NULL,
      0.014450,
      1.678393,
      0.705496,
      NULL,
      0.977252,
      1.822516,
      0,
      1.235093,
      2.555542,
      1.933324,
      1,
      NULL,
      0.187463,
      1,
      1,
      1.254970,
      1.367948,
      0,
      2.891209,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      0.537887,
      1,
      0,
      NULL,
      3,
      3,
      0.914715,
      0,
      NULL,
      2,
      0.488216,
      1.309385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626407,
      0,
      0.432912,
      2.172341,
      1.016058,
      1.281161,
      NULL,
      NULL,
      1.744727,
      NULL,
      0,
      2,
      1.946954,
      3,
      1.836374,
      0.388551,
      1.400001,
      1,
      NULL,
      NULL,
      0,
      1,
      0.778027,
      1,
      1,
      0.548072,
      55.997163,
      0,
      567.612415,
      0,
      1,
      3.579238,
      0,
      0,
      1.704615,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      61.889673,
      35.802173,
      2,
      0,
      3.023552,
      '14244',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.233615,
      '',
      '',
      '');
commit;
end;
/


