set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9030654';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '3310443',
      1.259702,
      0.497732,
      NULL,
      3,
      '2304',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      NULL,
      4,
      0,
      1,
      ' 3-19-1992',
      47.106811,
      3,
      149,
      17.929988,
      0,
      ' 5- 9-1999',
      ' 6-29-1986',
      ' 3-19-1988',
      1,
      3,
      0.408780,
      0,
      NULL,
      1.233489,
      6,
      0.019900,
      0.468257,
      36.401428,
      6,
      3,
      10.710162,
      20,
      18,
      1,
      17.719615,
      2,
      1,
      9,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.443559,
      NULL,
      NULL,
      1.160810,
      1,
      1.070758,
      0,
      1.260406,
      3,
      2,
      NULL,
      NULL,
      1.180689,
      0.798439,
      3,
      3,
      1,
      0,
      1,
      1,
      2,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      1.345870,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      1.691218,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1.691375,
      3,
      0,
      0,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      4,
      NULL,
      3,
      1,
      1,
      1,
      3.287263,
      NULL,
      233.597079,
      '10-16-1977',
      NULL,
      1,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.909434,
      0.182163,
      1,
      1.838389,
      1,
      0.662931,
      NULL,
      NULL,
      NULL,
      0,
      0.500412,
      0.900257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.806261,
      0,
      0.949264,
      1,
      0.196761,
      0.686892,
      NULL,
      2,
      10,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      2,
      0,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      0.650339,
      0,
      2.682451,
      NULL,
      NULL,
      0,
      0,
      1.459180,
      1.839800,
      0.299761,
      0.341640,
      0.429395,
      3,
      1.316735,
      1.808295,
      NULL,
      1,
      NULL,
      0,
      11.511518,
      NULL,
      NULL,
      10.771123,
      11,
      7,
      4,
      3.081110,
      2,
      1.159290,
      0,
      3,
      55.833990,
      0,
      2.086928,
      NULL,
      17,
      NULL,
      63.973283,
      0,
      0,
      1,
      '14404',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      NULL,
      34,
      17,
      3.643633,
      1,
      2,
      27.801960,
      3,
      1.851608,
      0,
      1,
      0.125782,
      NULL,
      NULL,
      1.899088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.413787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.033415,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      0.339048,
      1.188614,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.925590,
      0,
      0.021476,
      1,
      NULL,
      NULL,
      1.037640,
      NULL,
      NULL,
      3.379035,
      1.340924,
      0.121014,
      NULL,
      NULL,
      2.205692,
      NULL,
      2,
      1.184351,
      NULL,
      1,
      1.933380,
      1.524869,
      3.347732,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.664164,
      0.904700,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.324489,
      NULL,
      NULL,
      2,
      1,
      2.655199,
      NULL,
      NULL,
      NULL,
      3.146729,
      1,
      5.678675,
      1,
      NULL,
      NULL,
      1.990680,
      NULL,
      NULL,
      1.763546,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.992738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077931,
      2,
      0.998280,
      1,
      NULL,
      NULL,
      3.159098,
      3,
      4.573431,
      0.228783,
      1,
      0,
      3.486204,
      0.353360,
      0,
      0.446554,
      1,
      3,
      0.507309,
      NULL,
      NULL,
      0.529961,
      0.654463,
      NULL,
      4,
      0,
      2.324468,
      2.656636,
      NULL,
      1.517775,
      2,
      3,
      3,
      0,
      1.198418,
      0.677300,
      2,
      3,
      1,
      3,
      NULL,
      2,
      0.603569,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1.360993,
      1,
      2.048642,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851216,
      NULL,
      NULL,
      1,
      0,
      1.075029,
      1.512813,
      1.825859,
      1.315498,
      0.250805,
      NULL,
      NULL,
      2.762013,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.550215,
      NULL,
      NULL,
      NULL,
      0.369492,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693701,
      NULL,
      NULL,
      NULL,
      0.707293,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489814,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.627824,
      NULL,
      NULL,
      NULL,
      3.402467,
      0,
      2,
      2,
      1,
      101,
      163,
      1,
      NULL,
      NULL,
      1.741040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008117,
      NULL,
      NULL,
      1.153355,
      NULL,
      NULL,
      1,
      NULL,
      0.367413,
      386.564283,
      21,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0.901191,
      0.708243,
      0.463642,
      0,
      NULL,
      1.948959,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039713,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.145002,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.737069,
      NULL,
      NULL,
      NULL,
      1.170809,
      NULL,
      0,
      0,
      2,
      NULL,
      0.094011,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.395285,
      NULL,
      1,
      NULL,
      1.150490,
      0.572331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.728032,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417570,
      NULL,
      1,
      NULL,
      1.498037,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      3.889764,
      0,
      0.880980,
      1.500168,
      NULL,
      1.149146,
      1,
      2,
      NULL,
      0.332053,
      0,
      NULL,
      0.742142,
      NULL,
      NULL,
      1.635943,
      1.821232,
      NULL,
      0.398719,
      1.763583,
      NULL,
      0.785586,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.900581,
      NULL,
      NULL,
      0.228606,
      1,
      NULL,
      0.131203,
      0,
      NULL,
      NULL,
      0.195698,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017902,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      5,
      0.999124,
      NULL,
      2.871764,
      20,
      11,
      NULL,
      0,
      NULL,
      '42303',
      '',
      '',
      0,
      '',
      '',
      '',
      0.327108,
      '',
      NULL,
      '');
commit;
end;
/


