set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      1.356736,
      NULL,
      2,
      0,
      NULL,
      1.759084,
      NULL,
      NULL,
      NULL,
      ' 5- 9-2001',
      27.290569,
      NULL,
      4,
      NULL,
      0,
      ' 6-28-1980',
      19,
      2.851721,
      250,
      7.541841,
      0,
      ' 6-15-1975',
      ' 7-14-1998',
      ' 5-21-1985',
      3,
      0.827906,
      2.706054,
      0.884460,
      1.883233,
      1.023500,
      3,
      1,
      0.198860,
      11,
      1,
      9.036197,
      0.279563,
      26.165829,
      28.162240,
      4,
      17,
      3,
      NULL,
      5.491267,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2,
      1,
      1,
      1,
      4,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      8.154328,
      0,
      2,
      1,
      2,
      0.031307,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      2,
      NULL,
      2,
      0,
      1,
      3,
      0.525307,
      3,
      0.493207,
      0.420958,
      NULL,
      NULL,
      1.698517,
      1.587819,
      NULL,
      1.138748,
      NULL,
      1.788476,
      1,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      2,
      NULL,
      1,
      4,
      NULL,
      1,
      1,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      2,
      4,
      NULL,
      4,
      1,
      0,
      2,
      4,
      NULL,
      4,
      NULL,
      2,
      5,
      NULL,
      NULL,
      3,
      8.407995,
      0.617093,
      ' 7-18-1988',
      302.189790,
      NULL,
      NULL,
      3.374808,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      2,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      23,
      3.946883,
      1.974228,
      NULL,
      1.144008,
      3.704433,
      0,
      1,
      2,
      2,
      0,
      0,
      3.513622,
      NULL,
      NULL,
      7,
      3,
      7.285964,
      1.063900,
      3.695176,
      10,
      0.663322,
      NULL,
      NULL,
      NULL,
      1,
      1.303887,
      3.291351,
      1,
      3,
      NULL,
      2.908312,
      ' 9- 8-1990',
      47,
      ' 3-22-2003',
      26,
      NULL,
      0,
      NULL,
      2,
      2.966349,
      NULL,
      0,
      1,
      1.546170,
      0.806221,
      3.187255,
      NULL,
      2,
      1.903819,
      NULL,
      NULL,
      NULL,
      1,
      0.495759,
      1,
      2,
      2,
      2,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      2,
      3.176942,
      0.994417,
      1.780842,
      2.575062,
      1,
      NULL,
      2.865210,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.474791,
      1,
      1,
      2.636632,
      3.321216,
      1.742736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      NULL,
      NULL,
      3,
      0,
      0.159758,
      '23114',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0.808509,
      '',
      '',
      '',
      0.634855,
      26,
      NULL,
      25.597941,
      0.596811,
      36,
      1,
      NULL,
      2,
      0,
      3.571010,
      2,
      NULL,
      NULL,
      NULL,
      3.903957,
      2.505124,
      NULL,
      0,
      0.749754,
      1.011049,
      1.767066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.615580,
      0,
      NULL,
      0,
      1.307781,
      0,
      2,
      NULL,
      NULL,
      3,
      0,
      0,
      0.915964,
      NULL,
      NULL,
      4,
      11.468531,
      3,
      0,
      1.446209,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.213920,
      3.984784,
      3.822241,
      0,
      NULL,
      0,
      0,
      0.670301,
      3.844675,
      1.367397,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0.098339,
      NULL,
      0.239461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672415,
      NULL,
      9.737139,
      10.955661,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.523563,
      0.876779,
      0,
      3,
      2,
      2.134752,
      1,
      NULL,
      NULL,
      1,
      5.151807,
      1,
      0.334898,
      NULL,
      NULL,
      1,
      0.225612,
      NULL,
      0,
      NULL,
      NULL,
      0.691050,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.500674,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.820297,
      0,
      2,
      0,
      NULL,
      NULL,
      2,
      2.130636,
      7.689801,
      7,
      NULL,
      5.712428,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.216859,
      3.254878,
      1.062319,
      NULL,
      3,
      2.661255,
      3,
      1,
      0,
      1.609419,
      2.942979,
      NULL,
      0.480224,
      NULL,
      0.798691,
      0,
      3.176754,
      3,
      3,
      6.626903,
      NULL,
      2.954221,
      0.094570,
      11,
      4.629784,
      0,
      0,
      3,
      0.338322,
      NULL,
      0.588166,
      NULL,
      1.332606,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.582405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.337902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      0.358489,
      1,
      0.501641,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.289452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474290,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.738806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309921,
      NULL,
      NULL,
      NULL,
      1.951299,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      0.471281,
      NULL,
      NULL,
      NULL,
      1,
      42.968390,
      NULL,
      1,
      19,
      NULL,
      0.113061,
      8.015418,
      NULL,
      0.224176,
      15,
      NULL,
      3.944471,
      434.806935,
      NULL,
      0.043039,
      NULL,
      NULL,
      1,
      0,
      1.625281,
      11083.551300,
      1819.193370,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.076915,
      0.565679,
      1.304389,
      1,
      NULL,
      1.782181,
      0,
      1,
      0,
      1,
      0.632060,
      1.184779,
      2.001003,
      NULL,
      1.278045,
      NULL,
      0,
      NULL,
      0.263429,
      NULL,
      NULL,
      NULL,
      0.867691,
      NULL,
      0,
      NULL,
      0.286717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658741,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154808,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.195799,
      0.353008,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.138514,
      1.816446,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988785,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.305574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      6.097621,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.524835,
      0,
      0,
      0,
      NULL,
      2.793265,
      2.541531,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      1.899557,
      0,
      NULL,
      3,
      2,
      NULL,
      0.582877,
      1.258216,
      NULL,
      0.224860,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      0.136785,
      NULL,
      1,
      1,
      3.282620,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.344654,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.116426,
      NULL,
      0.517235,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.364266,
      NULL,
      1.386766,
      1.361208,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.869097,
      NULL,
      0,
      NULL,
      0.112340,
      NULL,
      3.000639,
      NULL,
      0.264623,
      NULL,
      0.340189,
      NULL,
      1,
      NULL,
      1.065691,
      NULL,
      0,
      NULL,
      1.554720,
      NULL,
      130.947418,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.638968,
      NULL,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      92,
      86,
      2,
      1.533049,
      0.893452,
      '11042',
      NULL,
      '',
      2,
      NULL,
      '',
      '',
      1.660936,
      '',
      NULL,
      '');
commit;
end;
/


