set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      '1233',
      1.874488,
      NULL,
      NULL,
      NULL,
      ' 9-13-1979',
      31,
      NULL,
      4,
      1.011438,
      0.534162,
      ' 7- 7-1998',
      15,
      3.689951,
      119.472941,
      NULL,
      0,
      '11-29-1993',
      ' 2-18-2001',
      '11-27-1976',
      0.998044,
      0.272091,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1.475004,
      NULL,
      1,
      14,
      NULL,
      36,
      NULL,
      5,
      5.846203,
      3,
      3,
      2.575977,
      NULL,
      0,
      1,
      0.740503,
      NULL,
      NULL,
      0,
      2.116572,
      5,
      0,
      1,
      0,
      0,
      4,
      3,
      1,
      0,
      3,
      5,
      2,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      2,
      1,
      NULL,
      0,
      0,
      0.286767,
      NULL,
      NULL,
      0.364115,
      2,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.954702,
      0,
      2,
      0.852964,
      NULL,
      0,
      0,
      2,
      3.259204,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      10,
      NULL,
      NULL,
      1.244436,
      1,
      NULL,
      NULL,
      2.437852,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.935737,
      1.780006,
      2.552772,
      2,
      0,
      1,
      2,
      0,
      NULL,
      5,
      1,
      4,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2,
      3,
      NULL,
      1,
      NULL,
      0,
      4,
      NULL,
      4,
      2,
      5,
      10,
      3,
      ' 7-29-1982',
      269.952051,
      ' 5- 6-1997',
      381.415836,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.501093,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168607,
      1,
      6,
      1,
      1.138261,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1.950804,
      1,
      NULL,
      0,
      6,
      ' 8- 5-1998',
      2,
      ' 8-27-1997',
      16.516054,
      0.290142,
      0,
      NULL,
      0.848068,
      3.395644,
      1.245796,
      NULL,
      0,
      0,
      2.901374,
      0.168997,
      82,
      0.267784,
      1.307351,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      1,
      2,
      2,
      3,
      2,
      2,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3.939315,
      1,
      NULL,
      NULL,
      1,
      0.053432,
      NULL,
      1.633262,
      1,
      0.355241,
      NULL,
      0,
      0,
      0.499991,
      2,
      3.066860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      48.439559,
      0,
      0.250729,
      0.968833,
      '43003',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      33.703377,
      148.721351,
      46.042572,
      0.711101,
      46.103311,
      2,
      1.016262,
      2,
      3.390377,
      1.695442,
      3,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      3.351737,
      3.320349,
      1.251490,
      1,
      3.713986,
      0,
      1,
      2.127196,
      NULL,
      NULL,
      NULL,
      3.540271,
      1.903367,
      18.934989,
      NULL,
      NULL,
      2.564072,
      10,
      5.241038,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1.497882,
      NULL,
      NULL,
      1.028602,
      NULL,
      7.933358,
      1,
      1.495301,
      NULL,
      NULL,
      NULL,
      0.118588,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.901245,
      12.537518,
      2,
      3.910194,
      13,
      NULL,
      NULL,
      0,
      1.261899,
      NULL,
      1.398605,
      NULL,
      0.679126,
      0.052948,
      1,
      NULL,
      0.354045,
      NULL,
      0,
      0,
      1,
      NULL,
      2.156675,
      1.692364,
      1,
      0,
      NULL,
      NULL,
      3.467229,
      0,
      0,
      0,
      4,
      0.075712,
      1,
      0.308702,
      NULL,
      NULL,
      NULL,
      1.914016,
      NULL,
      NULL,
      NULL,
      0.468166,
      NULL,
      NULL,
      2.784747,
      1.523507,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      5,
      8.153347,
      0,
      2.839243,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.722106,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.618640,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.643143,
      NULL,
      NULL,
      1,
      2.882191,
      NULL,
      0.915833,
      NULL,
      NULL,
      5.441955,
      NULL,
      2.866964,
      4.803779,
      NULL,
      3.248785,
      0,
      NULL,
      NULL,
      2.764111,
      3,
      NULL,
      2,
      0,
      1,
      2,
      3,
      1,
      2.291819,
      NULL,
      6.493131,
      2.006698,
      1,
      0,
      2,
      NULL,
      17.908668,
      2.423885,
      3,
      0,
      3.531750,
      0.744570,
      2,
      9,
      NULL,
      0.795992,
      NULL,
      7,
      NULL,
      3.342547,
      2,
      0,
      1,
      NULL,
      1.768957,
      0,
      0,
      3.397273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.590669,
      NULL,
      NULL,
      2.224885,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.778967,
      NULL,
      NULL,
      3.949866,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.651226,
      NULL,
      NULL,
      12.648067,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.275387,
      NULL,
      NULL,
      1,
      1.709531,
      1,
      0.346812,
      0.145489,
      2,
      3.700031,
      NULL,
      NULL,
      3.040474,
      2,
      NULL,
      NULL,
      1603.462189,
      997.197440,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.088934,
      NULL,
      NULL,
      7,
      0.025836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709115,
      2,
      NULL,
      NULL,
      10.468019,
      12.010012,
      NULL,
      NULL,
      17,
      6.285243,
      NULL,
      NULL,
      NULL,
      2.200416,
      NULL,
      NULL,
      3.774675,
      6,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      0.251324,
      NULL,
      NULL,
      0.797830,
      0.270287,
      NULL,
      NULL,
      1.504411,
      1.140474,
      NULL,
      NULL,
      0.650514,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      9.832003,
      NULL,
      NULL,
      12.038837,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      53.403960,
      NULL,
      3,
      3.499122,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1754.461807,
      NULL,
      1,
      364,
      NULL,
      1,
      NULL,
      NULL,
      1.178051,
      NULL,
      NULL,
      8978,
      NULL,
      0.359364,
      0,
      1.485308,
      0,
      1.559376,
      1,
      1.908317,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1.935378,
      1.596887,
      0.579711,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584101,
      0.524966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073456,
      0.829379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.094087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.373583,
      1.281568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168679,
      2.579174,
      NULL,
      1.571363,
      NULL,
      1.770311,
      NULL,
      NULL,
      NULL,
      1.289122,
      NULL,
      0.682639,
      NULL,
      1,
      0,
      1.881641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      7.274473,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      10.744324,
      0.861597,
      NULL,
      1,
      1,
      NULL,
      2,
      15.965098,
      NULL,
      NULL,
      NULL,
      NULL,
      2.281628,
      0.038397,
      NULL,
      NULL,
      3,
      NULL,
      0.779267,
      1.021470,
      NULL,
      NULL,
      1.400983,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.871776,
      0.887991,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.803732,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.284407,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      114,
      0.820953,
      NULL,
      0.408626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1.479450,
      0,
      69,
      45.285238,
      2,
      0,
      3.151820,
      '30003',
      '',
      '',
      0,
      '',
      '',
      '',
      0.703347,
      '',
      '',
      '');
commit;
end;
/


