set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1030122',
      0,
      0.241187,
      4,
      3,
      '0422',
      1,
      0.537286,
      NULL,
      NULL,
      ' 5- 1-1979',
      11.637981,
      NULL,
      5,
      1,
      1,
      ' 4-21-2002',
      NULL,
      0,
      NULL,
      94,
      NULL,
      ' 3-10-2000',
      ' 9- 2-1983',
      ' 3-11-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      10,
      6,
      NULL,
      NULL,
      32,
      NULL,
      0,
      18.076007,
      1,
      2,
      6,
      0,
      2,
      NULL,
      1,
      1,
      1,
      0.443813,
      0.566881,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      4,
      0,
      1,
      2,
      2,
      0,
      0,
      NULL,
      0,
      9,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.112492,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0.145261,
      NULL,
      1.432264,
      NULL,
      0,
      NULL,
      0.515981,
      1,
      NULL,
      0,
      0.033249,
      1.742084,
      0.349848,
      0.002043,
      0,
      3,
      1,
      NULL,
      2.643449,
      1,
      2,
      2,
      1,
      NULL,
      NULL,
      3.943448,
      2,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      NULL,
      0,
      0,
      4,
      5,
      NULL,
      1,
      2,
      2,
      4,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      NULL,
      0,
      4,
      2,
      2,
      4,
      0,
      0,
      5,
      9,
      0,
      NULL,
      672.581834,
      ' 1- 7-1991',
      91,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      0,
      1,
      1,
      0.258045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      11.863833,
      3.782597,
      1,
      NULL,
      NULL,
      0.090364,
      1,
      0,
      5.983514,
      NULL,
      0,
      1.199840,
      2,
      0,
      3,
      5.773533,
      1.872504,
      NULL,
      1.156927,
      6,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      5,
      0.680439,
      2,
      4,
      0,
      7.394883,
      ' 2-11-1987',
      6,
      ' 4- 1-1999',
      40,
      0.052138,
      0,
      1,
      NULL,
      3.645307,
      0.012435,
      NULL,
      0.076602,
      0.492081,
      NULL,
      2,
      70,
      2,
      1.983899,
      NULL,
      NULL,
      NULL,
      0,
      1.699390,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      3,
      3,
      0,
      2,
      2,
      3.976966,
      1.323864,
      NULL,
      0.949578,
      NULL,
      1,
      0.011417,
      NULL,
      NULL,
      0.504894,
      0,
      0.975807,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102705,
      NULL,
      17,
      46,
      15.395313,
      3,
      0.127390,
      0,
      '12330',
      '',
      NULL,
      1.977804,
      '',
      '',
      NULL,
      0.030161,
      '',
      '',
      NULL,
      3,
      4,
      102.750281,
      NULL,
      3,
      NULL,
      6,
      2.222915,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.641369,
      NULL,
      1.724167,
      1,
      NULL,
      2,
      0,
      2.257593,
      1.670231,
      NULL,
      1.698861,
      1.575469,
      3,
      3.939018,
      0,
      1.130059,
      2.066047,
      1,
      1.401351,
      2.589000,
      2,
      3,
      1,
      NULL,
      2.980879,
      3.783155,
      3,
      0,
      NULL,
      NULL,
      NULL,
      11.266635,
      0,
      1,
      0.012511,
      NULL,
      NULL,
      NULL,
      1.235820,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      1,
      NULL,
      1.761906,
      0.422273,
      1,
      NULL,
      0.260624,
      1,
      NULL,
      3,
      NULL,
      3.559361,
      2,
      1,
      2.820555,
      0.358604,
      0.987417,
      2,
      1.369653,
      1.830927,
      1,
      1,
      NULL,
      0.181716,
      1.633294,
      NULL,
      NULL,
      2.427272,
      1,
      NULL,
      4.545477,
      6.538530,
      6.216658,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.524539,
      NULL,
      NULL,
      2.775187,
      3.221808,
      1,
      3.462113,
      2.420255,
      NULL,
      0.004781,
      NULL,
      NULL,
      NULL,
      1,
      1.072448,
      3,
      3,
      1.547142,
      0,
      0.824907,
      NULL,
      NULL,
      7.583805,
      1,
      0.294660,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.825384,
      NULL,
      NULL,
      0.109142,
      NULL,
      NULL,
      0.825345,
      NULL,
      NULL,
      1.279558,
      NULL,
      NULL,
      NULL,
      2.652509,
      1.034045,
      1.095655,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      4,
      6.555065,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.978989,
      1.774948,
      0,
      0,
      NULL,
      3.315980,
      3,
      5.816896,
      NULL,
      1,
      3.653024,
      NULL,
      1.523497,
      1,
      1.637907,
      0.999467,
      2.198552,
      NULL,
      1,
      NULL,
      3,
      3,
      0.094840,
      0,
      9,
      10,
      1,
      8,
      3,
      NULL,
      NULL,
      0.914844,
      2,
      NULL,
      1.934413,
      NULL,
      NULL,
      NULL,
      NULL,
      5.247654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.984282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.502038,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.404784,
      NULL,
      1,
      NULL,
      0,
      1,
      1.326806,
      NULL,
      NULL,
      1.971287,
      NULL,
      NULL,
      NULL,
      3.629731,
      NULL,
      NULL,
      NULL,
      2.870121,
      NULL,
      NULL,
      NULL,
      1.456364,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739197,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.236851,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.475949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      0.529544,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      25.548842,
      0.391873,
      31.122504,
      1,
      3.056217,
      2.126836,
      631.865212,
      NULL,
      17.180776,
      5,
      3,
      774.551685,
      1144,
      0.558064,
      NULL,
      NULL,
      2,
      13.039637,
      NULL,
      15363,
      NULL,
      NULL,
      0,
      0.492740,
      0,
      0.611180,
      0,
      1,
      1,
      0.612639,
      1,
      1.835922,
      1.101207,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.548612,
      NULL,
      1.864626,
      NULL,
      1.368833,
      NULL,
      1,
      NULL,
      1.820393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.707255,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.707528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.054587,
      NULL,
      0,
      NULL,
      1.514879,
      NULL,
      NULL,
      NULL,
      1.845220,
      1.882374,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.251622,
      NULL,
      0.549448,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      2,
      3,
      7.316182,
      0.636154,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3.092469,
      NULL,
      NULL,
      3.261159,
      NULL,
      1,
      2.756035,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.297289,
      NULL,
      1,
      0,
      NULL,
      1.815418,
      0,
      NULL,
      1.056168,
      0.417829,
      NULL,
      3,
      3,
      NULL,
      0.782871,
      0.593812,
      NULL,
      2.639618,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.888901,
      NULL,
      2.063776,
      NULL,
      0.761443,
      NULL,
      1.713794,
      NULL,
      1,
      NULL,
      1.061819,
      NULL,
      1.866027,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.350391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.193028,
      NULL,
      0,
      NULL,
      2.870714,
      NULL,
      1,
      NULL,
      0.889819,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.173779,
      NULL,
      NULL,
      NULL,
      2.551909,
      NULL,
      0,
      NULL,
      186.137574,
      0.495137,
      NULL,
      1.199062,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      68.282802,
      53.055044,
      NULL,
      NULL,
      0,
      '20014',
      '',
      '',
      0.203047,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


