set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '1444401',
      5,
      0,
      NULL,
      NULL,
      '2342',
      1.645550,
      0.632825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.390288,
      0,
      ' 3-13-1975',
      65.792767,
      NULL,
      107.103811,
      NULL,
      NULL,
      ' 1- 4-1987',
      '11-13-1985',
      ' 9- 7-1978',
      1.345678,
      NULL,
      0.509965,
      1,
      NULL,
      2,
      2,
      NULL,
      NULL,
      12.943599,
      NULL,
      12,
      2.104271,
      19.323957,
      17.744503,
      NULL,
      9,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      2.134204,
      1,
      0,
      2,
      1,
      2,
      5,
      5,
      4,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      2,
      2,
      2,
      1.001218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      3.336706,
      1.957659,
      2,
      3,
      0,
      1.360193,
      NULL,
      NULL,
      3.049251,
      NULL,
      2.455507,
      NULL,
      0,
      1.473649,
      2,
      1,
      3,
      9.072812,
      NULL,
      1,
      3.511557,
      1,
      NULL,
      NULL,
      0.288381,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1.867675,
      1,
      0,
      0,
      0,
      0.344477,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      4,
      1,
      4,
      3,
      4,
      1,
      NULL,
      NULL,
      2,
      ' 6- 4-1996',
      8.086270,
      ' 3-28-1994',
      9.487600,
      1,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0.645605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461655,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      1,
      3.576991,
      1,
      0,
      2.734520,
      6.777663,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0.211049,
      1.067413,
      1,
      7,
      NULL,
      1.919572,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      3,
      2,
      2,
      3,
      2,
      NULL,
      2,
      1,
      3,
      2.822153,
      0.785439,
      NULL,
      2,
      1,
      0.574415,
      0.949774,
      0,
      0.482105,
      0,
      0,
      0,
      0.870907,
      NULL,
      0.132131,
      1,
      1,
      0.091670,
      0.347673,
      NULL,
      NULL,
      5.538915,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.501854,
      1.382837,
      0.669667,
      71.472026,
      3,
      NULL,
      NULL,
      25,
      29,
      68,
      NULL,
      NULL,
      5,
      NULL,
      '01301',
      '',
      1,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      2,
      30.445214,
      254.655270,
      15,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3.487400,
      NULL,
      0.570382,
      NULL,
      NULL,
      1.882576,
      3.938591,
      3.093971,
      NULL,
      3.268746,
      0,
      1,
      3.141282,
      2.788823,
      NULL,
      3,
      1.815818,
      NULL,
      2,
      0.791068,
      NULL,
      NULL,
      3.606301,
      3.885430,
      3,
      2.337159,
      1,
      1,
      0.148483,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.224070,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.862820,
      0.480701,
      0,
      0.541038,
      0,
      0,
      1.923355,
      3.689219,
      1.065939,
      NULL,
      1.224160,
      NULL,
      NULL,
      0.991372,
      3.696717,
      NULL,
      0.776070,
      0.825587,
      0,
      1,
      1,
      0.075372,
      0.492718,
      2.814379,
      2.926834,
      1.569104,
      0,
      NULL,
      NULL,
      1.981480,
      1,
      1.017360,
      NULL,
      1.558771,
      7,
      1,
      0.495480,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798815,
      1,
      1,
      0.495358,
      2.534546,
      1,
      0.474256,
      NULL,
      NULL,
      1.323270,
      3,
      0.570701,
      NULL,
      0.618415,
      0,
      1,
      NULL,
      1,
      3.822406,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.977606,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.485048,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.452177,
      NULL,
      1.708742,
      1.909217,
      NULL,
      NULL,
      NULL,
      3,
      0.711952,
      4,
      2,
      NULL,
      1.586765,
      NULL,
      2.434952,
      3.556227,
      0,
      1.417635,
      NULL,
      0.883362,
      1.714016,
      0.184090,
      0.550211,
      3.710269,
      5.302324,
      0.683743,
      2.645806,
      0.035697,
      0.205801,
      0,
      NULL,
      0.284118,
      NULL,
      0.830453,
      3,
      2,
      2.740987,
      2,
      1,
      0.295537,
      1,
      7,
      NULL,
      NULL,
      5,
      0.381074,
      0,
      3,
      1.848494,
      2,
      3,
      NULL,
      1.720999,
      0.028246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.514193,
      NULL,
      NULL,
      1.779317,
      NULL,
      NULL,
      2.449193,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.860959,
      NULL,
      NULL,
      1.294436,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.794520,
      NULL,
      NULL,
      1,
      3.749433,
      3,
      0.699927,
      NULL,
      2,
      3.465497,
      NULL,
      4,
      NULL,
      0.784135,
      NULL,
      46.632401,
      2.704175,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.998392,
      0.075028,
      1.867988,
      NULL,
      1.776841,
      1,
      0.966413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.133704,
      1.959513,
      2,
      NULL,
      3,
      1.892546,
      NULL,
      NULL,
      NULL,
      0.559373,
      0.996369,
      NULL,
      3.306708,
      3.973252,
      0.855445,
      NULL,
      NULL,
      1.756345,
      1,
      NULL,
      NULL,
      2.471010,
      NULL,
      NULL,
      0,
      3.934007,
      0,
      NULL,
      0,
      0.992012,
      0,
      NULL,
      1.163232,
      2,
      3.872752,
      NULL,
      3.389624,
      NULL,
      NULL,
      NULL,
      1,
      6,
      NULL,
      NULL,
      0.895759,
      0,
      NULL,
      NULL,
      NULL,
      3,
      43.011827,
      31,
      1.302834,
      NULL,
      3,
      NULL,
      4,
      1205,
      3,
      105,
      NULL,
      1,
      NULL,
      3.629210,
      2,
      78,
      7,
      NULL,
      55.098756,
      0,
      117.956668,
      1.989078,
      2.660387,
      1,
      NULL,
      1.702752,
      1.987433,
      NULL,
      NULL,
      0,
      0,
      1.849402,
      NULL,
      1,
      1.788243,
      NULL,
      1,
      0,
      0.135312,
      0.592560,
      1,
      NULL,
      0,
      NULL,
      0.150329,
      NULL,
      0.309565,
      NULL,
      2,
      NULL,
      243.516529,
      NULL,
      0.970324,
      NULL,
      20,
      NULL,
      1.828192,
      1,
      NULL,
      0.704232,
      NULL,
      1,
      NULL,
      1.965599,
      NULL,
      1.715738,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.629691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004524,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686421,
      0.416572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449466,
      1.299221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.771692,
      NULL,
      0.707935,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      NULL,
      1.240392,
      NULL,
      NULL,
      NULL,
      1.430964,
      NULL,
      0.988117,
      NULL,
      0.946913,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3.107632,
      NULL,
      3.933696,
      1.069655,
      1,
      NULL,
      2.728305,
      1,
      1.422117,
      NULL,
      0.815140,
      NULL,
      3,
      0.215990,
      2.067128,
      2,
      1.518429,
      NULL,
      0.997555,
      NULL,
      0.827735,
      0,
      2.052516,
      1,
      3,
      2,
      3,
      NULL,
      NULL,
      3.263845,
      1,
      0.663251,
      3,
      1.156162,
      1.320923,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      0.669114,
      2,
      1.027502,
      NULL,
      1,
      1.437844,
      0,
      0.283716,
      1,
      0,
      0.562299,
      2.445077,
      1.543812,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1.712990,
      0,
      1.013524,
      1,
      1.614563,
      1,
      NULL,
      0.114985,
      0.359021,
      0.474086,
      35,
      1,
      NULL,
      3.075930,
      3.829932,
      3,
      1,
      2.637121,
      1,
      1.786306,
      2.162961,
      1.457363,
      0,
      3.978178,
      0.602346,
      0,
      2.046462,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0.872927,
      3,
      2,
      0,
      2.157039,
      1,
      0,
      89.070501,
      NULL,
      NULL,
      0.820388,
      0,
      0.027534,
      NULL,
      NULL,
      1,
      2,
      1,
      6,
      3,
      0,
      1.185924,
      28,
      23,
      4,
      0.941968,
      NULL,
      '02322',
      NULL,
      '',
      1.360097,
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


