set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800889';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      NULL,
      NULL,
      1.813168,
      NULL,
      3,
      3,
      1,
      '421',
      '44203103',
      39,
      NULL,
      '0123121',
      2,
      1.911938,
      2,
      0,
      '1312',
      3,
      1.084419,
      NULL,
      NULL,
      ' 6-11-1997',
      NULL,
      59.189465,
      NULL,
      3,
      2.248636,
      '10- 2-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 0- 9-2000',
      '11-16-1975',
      ' 0- 8-1983',
      3,
      3.205412,
      NULL,
      1.094355,
      NULL,
      0,
      6,
      1.424769,
      NULL,
      NULL,
      NULL,
      11,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      2.802935,
      NULL,
      1,
      4,
      NULL,
      1,
      4,
      4,
      NULL,
      3,
      4,
      NULL,
      0,
      2.110928,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1.621519,
      1.297196,
      0.920219,
      0.206043,
      2,
      2,
      1,
      3,
      3,
      0,
      1,
      0.091865,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      7.546242,
      1,
      NULL,
      0.873272,
      0.404386,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      3,
      3,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      2,
      3,
      1,
      0,
      3,
      1,
      0,
      0,
      2,
      5,
      NULL,
      NULL,
      3,
      5,
      5,
      NULL,
      1,
      5,
      4,
      1,
      2,
      NULL,
      ' 9- 5-1997',
      NULL,
      NULL,
      NULL,
      3.835327,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0,
      3,
      2.914408,
      0,
      4,
      0.006148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.263662,
      2,
      1.019599,
      5,
      NULL,
      9,
      NULL,
      9.229827,
      3.593381,
      5.669937,
      1,
      NULL,
      NULL,
      0,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874587,
      1.376611,
      1,
      NULL,
      NULL,
      1.950120,
      1,
      2.609079,
      39.193343,
      1.180028,
      1.511361,
      NULL,
      NULL,
      NULL,
      0,
      0.909889,
      NULL,
      0,
      3,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.320186,
      0.663393,
      4.253648,
      NULL,
      NULL,
      2,
      0,
      0,
      0.974064,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1.231142,
      1.259323,
      3,
      0.179073,
      0.560785,
      0,
      10,
      NULL,
      NULL,
      2,
      NULL,
      3.867494,
      1.881817,
      2.593055,
      52,
      3,
      2,
      17,
      NULL,
      NULL,
      17.336445,
      1,
      4,
      0,
      '23423',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      122.100701,
      30.220728,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.964916,
      0.712797,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0.072394,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.054523,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      2,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      10,
      9.809266,
      5.412916,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.014216,
      NULL,
      NULL,
      NULL,
      1,
      0.450933,
      0.356692,
      1.215029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.578712,
      0.131030,
      0,
      NULL,
      3.149919,
      0.859114,
      2.335073,
      NULL,
      0,
      NULL,
      0.992601,
      0.088037,
      2,
      NULL,
      0,
      0.239636,
      1,
      3,
      2.151324,
      0,
      NULL,
      NULL,
      NULL,
      1.024477,
      0,
      8.576593,
      1.013450,
      0.407744,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.506049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305832,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.703223,
      NULL,
      NULL,
      5,
      1,
      0.077779,
      0.276645,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736117,
      0.578602,
      NULL,
      0,
      NULL,
      NULL,
      0.962428,
      NULL,
      NULL,
      0.146687,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.478632,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183308,
      1,
      0,
      2.134435,
      NULL,
      7.249978,
      4.949339,
      2,
      3,
      7.525967,
      1.365530,
      2,
      2,
      NULL,
      NULL,
      3,
      0.837763,
      NULL,
      3.451274,
      NULL,
      0,
      4.234054,
      NULL,
      3,
      NULL,
      1.396932,
      2.733397,
      2,
      2.807235,
      0,
      2,
      0,
      1,
      3,
      NULL,
      2.840489,
      1,
      2,
      2.702521,
      0.451281,
      NULL,
      1,
      2.299482,
      2,
      4,
      0.738109,
      1,
      NULL,
      0,
      1.305219,
      3.289582,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718279,
      NULL,
      NULL,
      0.150954,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.383606,
      NULL,
      NULL,
      1.193561,
      NULL,
      NULL,
      0.648313,
      NULL,
      NULL,
      1.947316,
      NULL,
      NULL,
      0.499238,
      NULL,
      NULL,
      0,
      0.580457,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.016669,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.719225,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.854426,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388202,
      NULL,
      NULL,
      1,
      1.879808,
      0.380964,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981811,
      NULL,
      1.262070,
      73.620945,
      NULL,
      0.798240,
      0.948241,
      NULL,
      NULL,
      1.958499,
      0,
      0,
      1,
      1.913687,
      0.489900,
      1,
      1,
      1.880442,
      1.503142,
      0.147033,
      1.766308,
      1.924229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.465200,
      0.443872,
      1.448850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.462329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.569528,
      NULL,
      0.997147,
      NULL,
      1.520778,
      NULL,
      NULL,
      NULL,
      0.425510,
      NULL,
      0,
      NULL,
      0.546522,
      NULL,
      0.914677,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.610633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389119,
      1,
      NULL,
      1,
      NULL,
      1.351955,
      NULL,
      NULL,
      NULL,
      0.757982,
      NULL,
      NULL,
      NULL,
      1.701874,
      0,
      1.419904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2.689303,
      NULL,
      2.832730,
      2,
      2.925987,
      NULL,
      0,
      1.549264,
      1.160107,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3.687953,
      2.306949,
      NULL,
      1,
      NULL,
      NULL,
      3.613065,
      NULL,
      NULL,
      1.824411,
      1.764468,
      NULL,
      1,
      1.306119,
      NULL,
      1.319313,
      2.535461,
      NULL,
      1.195932,
      NULL,
      NULL,
      1.303375,
      3,
      NULL,
      0.157596,
      2,
      NULL,
      3.302900,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691061,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      6,
      3,
      NULL,
      0.967143,
      30,
      65.327638,
      1,
      5,
      NULL,
      '40033',
      '',
      '',
      1.925331,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


