set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8928592';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '4324001',
      1.690520,
      0,
      3,
      0,
      '1023',
      NULL,
      2,
      0.946307,
      40,
      ' 4-17-1976',
      33.160898,
      NULL,
      2,
      0.244792,
      NULL,
      '11-28-1981',
      36,
      1.245262,
      88.083097,
      66.231254,
      1,
      NULL,
      NULL,
      ' 9-29-1988',
      0.225921,
      0,
      NULL,
      1,
      0.223498,
      1.870545,
      3,
      0,
      NULL,
      NULL,
      6,
      2,
      0.462080,
      12,
      15,
      NULL,
      16,
      3,
      3,
      2,
      1.560516,
      0,
      NULL,
      1.632615,
      1,
      1,
      5.691768,
      1.116163,
      3.736235,
      0.267526,
      1,
      4,
      1,
      6,
      1.375238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      0,
      1,
      3,
      NULL,
      0,
      3,
      3.285775,
      2,
      1.140990,
      0,
      NULL,
      1.725585,
      0,
      0,
      1,
      1,
      1.043020,
      NULL,
      NULL,
      1.327113,
      1,
      0,
      0,
      3,
      1.048870,
      1,
      6,
      NULL,
      1.241356,
      2,
      5,
      0,
      3.680013,
      7.012970,
      3.181682,
      2.084101,
      0,
      7.095285,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.555398,
      24.687043,
      NULL,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.012243,
      NULL,
      NULL,
      0.340909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392806,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.790854,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.975345,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304151,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083971,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.946214,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723591,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.181926,
      NULL,
      NULL,
      1.925001,
      NULL,
      NULL,
      1.571508,
      3,
      5,
      0.123772,
      NULL,
      NULL,
      2,
      4.653973,
      5,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.117659,
      NULL,
      NULL,
      0.158803,
      NULL,
      NULL,
      0.233323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229864,
      NULL,
      NULL,
      0.405686,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.574315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.402898,
      1,
      1,
      3,
      2,
      0.962829,
      3,
      0.821409,
      NULL,
      1.817662,
      1.889063,
      NULL,
      1,
      NULL,
      NULL,
      0.990689,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1.831788,
      1,
      NULL,
      NULL,
      0.703148,
      NULL,
      NULL,
      0.827589,
      NULL,
      0.069664,
      0.829001,
      0.576958,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.305915,
      NULL,
      3.297742,
      1,
      1,
      1.355335,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.253038,
      NULL,
      NULL,
      NULL,
      1.263135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333407,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.335344,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10.379135,
      NULL,
      NULL,
      NULL,
      0.611201,
      NULL,
      0.723564,
      NULL,
      NULL,
      NULL,
      1.861390,
      NULL,
      NULL,
      0.069259,
      NULL,
      NULL,
      0.314894,
      NULL,
      NULL,
      0,
      NULL,
      38,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.963786,
      NULL,
      0.350612,
      1.846392,
      1.381919,
      NULL,
      NULL,
      1.594026,
      1,
      0.863112,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0.746306,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      4,
      2,
      1.811777,
      3,
      3,
      6,
      3.454335,
      1,
      1.941591,
      0.018820,
      0.091775,
      1.423817,
      1,
      0,
      1.979798,
      NULL,
      1.286684,
      0,
      0.004012,
      0.931731,
      0.774091,
      0.574387,
      NULL,
      0.528467,
      3.606268,
      2,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0.475019,
      0,
      1.682442,
      NULL,
      NULL,
      0,
      NULL,
      0.668989,
      NULL,
      NULL,
      1.333991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022925,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3,
      1.369459,
      NULL,
      NULL,
      125,
      144.965804,
      4,
      0,
      NULL,
      '10220',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      4.971887,
      '1104',
      NULL,
      '20240');
commit;
end;
/


