set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8335717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1983-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1134130',
      1,
      0.055180,
      3,
      2,
      '2134',
      1.708638,
      NULL,
      NULL,
      NULL,
      ' 0-18-1975',
      45,
      NULL,
      5,
      1.154909,
      8.267539,
      ' 0- 4-1985',
      38.685245,
      2.721592,
      175.891288,
      30,
      0,
      ' 8-15-2002',
      '11- 3-1992',
      ' 8- 4-1976',
      2.771826,
      1,
      1,
      0,
      0,
      1.349077,
      3,
      0.332326,
      NULL,
      NULL,
      5,
      14,
      11.946522,
      NULL,
      93.099619,
      1,
      4,
      3,
      0,
      0.576106,
      1.024247,
      0,
      0,
      0.357675,
      NULL,
      0.478483,
      0.513045,
      1,
      0.380003,
      1,
      0.369430,
      2,
      5,
      1,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      0,
      2,
      0,
      3,
      1,
      1,
      0,
      0,
      1,
      0.659037,
      NULL,
      NULL,
      1.134078,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.229177,
      1,
      NULL,
      1,
      0.327857,
      1,
      0.011569,
      0.442081,
      1,
      1.212076,
      NULL,
      0,
      1.796117,
      1.259491,
      0.825552,
      1,
      0,
      1,
      0,
      7.402618,
      1,
      NULL,
      NULL,
      1.571267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      5,
      NULL,
      5,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.601213,
      1,
      1,
      0,
      0,
      0.078565,
      NULL,
      1.347693,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      5,
      1,
      NULL,
      4,
      NULL,
      NULL,
      0,
      2.194132,
      3,
      ' 9-27-1977',
      434.694590,
      ' 5-12-1984',
      310,
      NULL,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1.440001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      14.890045,
      0.285209,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3.194349,
      NULL,
      0.606859,
      NULL,
      0,
      0,
      0.792542,
      3.766275,
      1,
      2,
      0.418384,
      NULL,
      NULL,
      NULL,
      1.760103,
      NULL,
      1.153453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576135,
      0.078601,
      0.537139,
      0.171661,
      0,
      0,
      0.922501,
      3.765867,
      27.509294,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.001284,
      NULL,
      3,
      NULL,
      5,
      16,
      23,
      5,
      0.156615,
      2,
      '02132',
      '',
      '',
      1.453904,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      3,
      16.991282,
      33.656493,
      35.241487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.815004,
      2,
      NULL,
      NULL,
      NULL,
      1.979489,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.331606,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.444965,
      NULL,
      9.811030,
      0.788578,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.141414,
      NULL,
      NULL,
      1.915855,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.037000,
      1,
      NULL,
      1,
      1.797677,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2.967169,
      1.190387,
      NULL,
      0.672949,
      0,
      0,
      0.125077,
      1.069268,
      1.756892,
      0.261014,
      1.641957,
      NULL,
      0.438349,
      1.446084,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.443858,
      NULL,
      NULL,
      2.796341,
      4.296092,
      3.162798,
      0,
      1.776072,
      NULL,
      NULL,
      NULL,
      0.087239,
      NULL,
      NULL,
      NULL,
      1.817401,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      8.228730,
      1.763668,
      0,
      NULL,
      NULL,
      0.862163,
      1.922523,
      1.706612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810908,
      NULL,
      NULL,
      0.361557,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106578,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.754197,
      NULL,
      NULL,
      2.012176,
      NULL,
      NULL,
      0.637115,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.999776,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      1.421007,
      NULL,
      3,
      13.323272,
      NULL,
      1.205969,
      NULL,
      17.587289,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      1.890548,
      1,
      NULL,
      1.444169,
      2,
      NULL,
      NULL,
      2.309472,
      NULL,
      NULL,
      17.338926,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.746427,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.828945,
      NULL,
      NULL,
      3.228362,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.084383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      1.301860,
      NULL,
      NULL,
      1,
      1,
      1,
      1.577133,
      1.919704,
      0.732592,
      NULL,
      NULL,
      NULL,
      5.503524,
      NULL,
      NULL,
      NULL,
      59.277092,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.721309,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.994144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.929020,
      NULL,
      NULL,
      NULL,
      1.626831,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1.558461,
      NULL,
      NULL,
      NULL,
      0.760197,
      4,
      0.632924,
      1,
      1,
      0.893920,
      0.160467,
      NULL,
      NULL,
      0.785406,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.814991,
      NULL,
      1.781544,
      19484,
      NULL,
      1.353491,
      NULL,
      NULL,
      NULL,
      0,
      1.101531,
      NULL,
      3.015327,
      0.869654,
      0,
      1,
      NULL,
      0,
      0.541564,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.056449,
      NULL,
      1.614044,
      NULL,
      1.345532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.993363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.424131,
      NULL,
      NULL,
      NULL,
      1,
      0.761333,
      0.266820,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.520843,
      NULL,
      NULL,
      NULL,
      1.528359,
      1.456068,
      0.177605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      6,
      2,
      2.047661,
      2.954986,
      NULL,
      6.936798,
      0,
      1.534855,
      0,
      NULL,
      12.139910,
      NULL,
      6,
      17,
      NULL,
      11.923845,
      12,
      NULL,
      2.022981,
      1.530650,
      NULL,
      NULL,
      3,
      NULL,
      7,
      14,
      NULL,
      7,
      11,
      NULL,
      8,
      7,
      NULL,
      9,
      15,
      NULL,
      17.028060,
      NULL,
      NULL,
      9,
      11,
      NULL,
      1.541034,
      1.824998,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      1,
      1.900730,
      NULL,
      NULL,
      NULL,
      99,
      2,
      NULL,
      3,
      '32143',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '');
commit;
end;
/


