set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.936910,
      NULL,
      3.970098,
      2,
      1.296600,
      NULL,
      0.832574,
      3.845330,
      '324',
      '20402343',
      13.749832,
      39,
      '4202320',
      0.979285,
      1,
      NULL,
      NULL,
      NULL,
      4,
      1.052571,
      NULL,
      NULL,
      NULL,
      6.264224,
      49,
      NULL,
      0,
      2,
      ' 6-21-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11-13-1974',
      '10-27-1995',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.142217,
      1,
      5.925569,
      8,
      8,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      4,
      3.129029,
      5,
      NULL,
      0,
      0,
      0,
      3,
      0,
      3,
      0,
      3,
      NULL,
      0,
      7.282713,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.726113,
      0.208817,
      1,
      1.346017,
      NULL,
      1.212604,
      NULL,
      1.609544,
      3.102085,
      NULL,
      1.751310,
      1,
      0,
      1.171288,
      3.748182,
      2.922172,
      2,
      2,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.734877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2,
      3,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      2.815670,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      5,
      1,
      NULL,
      NULL,
      0,
      5,
      2,
      0.671371,
      2.167441,
      '10-14-1995',
      531.952420,
      ' 5-22-1990',
      NULL,
      2.042741,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.800207,
      NULL,
      NULL,
      NULL,
      2.873878,
      NULL,
      7.874675,
      4.198558,
      2,
      NULL,
      NULL,
      1.423859,
      NULL,
      NULL,
      0.171190,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.959168,
      NULL,
      1.750709,
      NULL,
      NULL,
      1,
      NULL,
      1.665962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.216886,
      0.387523,
      0,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      1,
      NULL,
      2,
      0.908914,
      3,
      NULL,
      1.316905,
      0.897567,
      1.789370,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1.721638,
      0,
      0.653512,
      NULL,
      1.548879,
      4,
      0.395251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      29,
      NULL,
      2,
      3,
      NULL,
      '02313',
      '20004',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      12.260026,
      167.756092,
      NULL,
      1.064113,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990347,
      NULL,
      0.440466,
      1.990119,
      NULL,
      NULL,
      0.531611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.271545,
      0,
      0,
      NULL,
      NULL,
      1.127446,
      3.810155,
      1.737929,
      NULL,
      0.901254,
      NULL,
      NULL,
      2.301147,
      0.806709,
      0.186100,
      1,
      NULL,
      NULL,
      NULL,
      0.509628,
      0.697207,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      0.231753,
      NULL,
      NULL,
      NULL,
      1.240056,
      NULL,
      NULL,
      NULL,
      3,
      0.528671,
      0.809527,
      NULL,
      NULL,
      1.966818,
      0.132764,
      NULL,
      NULL,
      2,
      0.957935,
      1,
      NULL,
      0.261606,
      NULL,
      0.879717,
      3,
      0,
      1,
      NULL,
      NULL,
      1.684232,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      0.030382,
      NULL,
      NULL,
      0.902505,
      NULL,
      NULL,
      3,
      1,
      1.350053,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.573330,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.880621,
      NULL,
      NULL,
      2.662004,
      NULL,
      NULL,
      1.797659,
      NULL,
      NULL,
      0.964305,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.423910,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.604186,
      NULL,
      NULL,
      0.052351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.279979,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.633054,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.252114,
      3,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.541041,
      3.805920,
      NULL,
      NULL,
      3,
      NULL,
      4,
      0,
      5.569909,
      1.097027,
      NULL,
      2.304683,
      1.948362,
      0,
      0,
      2.834626,
      3,
      2,
      0,
      1,
      2.799862,
      0.288094,
      3.535751,
      4,
      1.731926,
      1.143056,
      4.287919,
      3,
      NULL,
      4,
      1,
      0,
      1,
      1.281848,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.475543,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.775879,
      0.527238,
      1,
      NULL,
      4,
      NULL,
      5.700629,
      NULL,
      49,
      NULL,
      57,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.071744,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2,
      NULL,
      3.581024,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.794050,
      NULL,
      0.130225,
      NULL,
      1.118658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.954378,
      NULL,
      3,
      NULL,
      2.176120,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.393515,
      NULL,
      NULL,
      NULL,
      0.732633,
      NULL,
      1.944770,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.673333,
      NULL,
      0.567743,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.981239,
      NULL,
      NULL,
      0.288680,
      NULL,
      0.816462,
      0,
      NULL,
      0,
      0,
      1.830517,
      0,
      0,
      0,
      0.866626,
      NULL,
      1.939383,
      1,
      1,
      1,
      1.492021,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.949005,
      NULL,
      0,
      NULL,
      83.813362,
      NULL,
      0,
      30.479249,
      22.234541,
      NULL,
      2.110348,
      0,
      NULL,
      0.552189,
      NULL,
      0.700869,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.518523,
      NULL,
      NULL,
      NULL,
      1.874789,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.183435,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.670239,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.282671,
      NULL,
      2.512401,
      NULL,
      3.919319,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.323532,
      NULL,
      1,
      NULL,
      1.893363,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      122.831173,
      NULL,
      1.700891,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.000347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      2.396604,
      NULL,
      138.231157,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      245.332134,
      2,
      NULL,
      1.102139,
      NULL,
      0,
      NULL,
      1,
      1.235288,
      3.223659,
      5,
      NULL,
      NULL,
      0,
      1.497295,
      3.912575,
      NULL,
      NULL,
      1,
      3,
      2,
      2,
      1,
      0,
      4.732203,
      2.425731,
      0.739318,
      2,
      1,
      1,
      0,
      1,
      1,
      2.334978,
      1,
      1,
      1,
      0,
      0,
      0.330921,
      0.424542,
      NULL,
      1,
      1.281367,
      1,
      1.459109,
      0.915733,
      0.068331,
      2,
      0.744018,
      1.551976,
      NULL,
      0,
      0,
      0.896986,
      NULL,
      3.208707,
      2.053460,
      0.958837,
      0,
      1.445961,
      2.224268,
      NULL,
      1.500701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.109498,
      NULL,
      1,
      0.822581,
      0,
      4,
      4,
      0,
      1.490773,
      2,
      67,
      74,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


