set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '1243104',
      NULL,
      0,
      1,
      1,
      '0011',
      3,
      NULL,
      NULL,
      NULL,
      '10-18-1999',
      13,
      NULL,
      0,
      1,
      0,
      ' 3- 2-1974',
      47.743083,
      0.067161,
      274,
      10,
      2,
      NULL,
      NULL,
      ' 2-18-1998',
      3.209194,
      NULL,
      1,
      1.691373,
      1,
      NULL,
      0,
      1.412735,
      1,
      NULL,
      6,
      18.475818,
      NULL,
      24.489904,
      12.751085,
      4,
      7,
      4,
      0,
      2,
      0.814477,
      0,
      2,
      1,
      1,
      0.244473,
      1.605967,
      1.646192,
      0.644274,
      0.467811,
      0,
      0,
      3,
      3,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      3,
      1,
      0,
      NULL,
      0,
      1,
      1,
      5,
      2,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.373604,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.538550,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3.186348,
      NULL,
      2,
      3,
      0.225796,
      0.531074,
      NULL,
      1.778406,
      0,
      0,
      1,
      NULL,
      4.921610,
      2,
      NULL,
      0.156663,
      1.533273,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1.220221,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      5,
      0,
      3,
      4,
      2,
      5,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      5,
      5,
      1,
      1,
      NULL,
      5,
      3,
      3,
      2,
      0.881637,
      ' 7-11-1986',
      40,
      NULL,
      427.028871,
      2.876192,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1.820482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      40,
      3.745106,
      1.387759,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.362190,
      0,
      5,
      6.385988,
      1.326474,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.960249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208162,
      1.137275,
      NULL,
      1,
      2.741306,
      1,
      0,
      1,
      NULL,
      3.068679,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      2,
      2,
      1,
      2,
      3,
      0,
      NULL,
      NULL,
      3,
      2,
      0,
      3.426597,
      2,
      NULL,
      NULL,
      1,
      2,
      1.873906,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1.131063,
      NULL,
      0.045023,
      8,
      NULL,
      0,
      3.494912,
      3.177822,
      0,
      3,
      2.699562,
      7.581309,
      NULL,
      NULL,
      2.402228,
      17.263794,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      '42101',
      '',
      '',
      0,
      '',
      '',
      '',
      0.491088,
      NULL,
      '',
      '',
      2,
      38,
      37,
      14.738782,
      3,
      31,
      11.054362,
      3,
      2,
      2.465911,
      1.988952,
      0,
      0.080858,
      NULL,
      NULL,
      0,
      1,
      3,
      0.807371,
      NULL,
      NULL,
      1.700641,
      NULL,
      NULL,
      3.379318,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.353751,
      NULL,
      NULL,
      NULL,
      2,
      5,
      0,
      1.305818,
      NULL,
      NULL,
      NULL,
      0.241388,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774834,
      3,
      0.403341,
      NULL,
      NULL,
      1.293733,
      NULL,
      NULL,
      0,
      0.270121,
      1,
      3.159076,
      NULL,
      1,
      2,
      2.350908,
      NULL,
      1.083774,
      1.897334,
      NULL,
      0,
      2,
      0,
      0,
      1.425615,
      NULL,
      NULL,
      0.111192,
      NULL,
      NULL,
      3,
      2.172627,
      3,
      10,
      8,
      5.097800,
      3,
      0.825702,
      NULL,
      NULL,
      NULL,
      0.616407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084259,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.356137,
      NULL,
      NULL,
      NULL,
      1.222434,
      1.773131,
      0.244906,
      NULL,
      NULL,
      4,
      0,
      1.657736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.033481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744557,
      0.611014,
      1.133504,
      NULL,
      NULL,
      0.331733,
      3.507102,
      NULL,
      1.999463,
      9.603467,
      4,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.113393,
      0.617538,
      1,
      2,
      1,
      7.493300,
      2,
      0.293625,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.843869,
      7,
      NULL,
      1,
      3.961824,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1,
      0.401763,
      NULL,
      1.294983,
      1,
      NULL,
      NULL,
      NULL,
      1.183748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.882900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423780,
      NULL,
      NULL,
      NULL,
      0.545507,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.367538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695173,
      NULL,
      NULL,
      NULL,
      2.929812,
      NULL,
      NULL,
      NULL,
      0.323923,
      NULL,
      NULL,
      NULL,
      7.781567,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      6,
      2,
      0,
      80.010931,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.629321,
      39.178620,
      NULL,
      2,
      35,
      NULL,
      1.095335,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      66.059396,
      1.247945,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1.136953,
      1.395693,
      1,
      NULL,
      NULL,
      0.161415,
      0,
      0.987503,
      1.147649,
      0.584827,
      1.074729,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.318843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.285944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.180696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.105940,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523441,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202228,
      1.776250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349931,
      0.930777,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.679888,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2,
      0.947506,
      3.795437,
      0,
      1.398256,
      1,
      NULL,
      0.071571,
      NULL,
      NULL,
      1.696963,
      1,
      NULL,
      1.490054,
      3,
      NULL,
      0,
      0,
      NULL,
      3,
      2.871094,
      NULL,
      0,
      NULL,
      NULL,
      1.726604,
      0.766862,
      NULL,
      0.643274,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.911398,
      1.364920,
      NULL,
      0,
      0,
      1.857611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.864782,
      NULL,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      36.964768,
      68,
      2,
      0,
      NULL,
      '02214',
      '',
      '',
      1.803406,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


