set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      2.195534,
      1.139544,
      4,
      0,
      '2301',
      3.413427,
      1.604896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.871835,
      10,
      ' 5- 0-1976',
      12.269680,
      3.186581,
      132,
      32.952717,
      2,
      NULL,
      NULL,
      '10-24-1985',
      1,
      NULL,
      0.191480,
      2.550620,
      0.401678,
      NULL,
      1,
      NULL,
      1,
      2.523433,
      3,
      15.945710,
      9.419315,
      NULL,
      19,
      5,
      NULL,
      1,
      3,
      8,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      0.162008,
      0.767576,
      0,
      3,
      3,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      3,
      NULL,
      1,
      1,
      4,
      1,
      0,
      4,
      1,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      1.569529,
      NULL,
      NULL,
      5,
      0,
      1.097496,
      2.050909,
      1.671130,
      0.776116,
      NULL,
      1.207578,
      1.571051,
      1,
      0.296962,
      0.187077,
      0,
      NULL,
      1,
      NULL,
      1,
      0.973670,
      1,
      1,
      1,
      5,
      2.871426,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007511,
      NULL,
      NULL,
      1,
      0,
      1,
      4,
      0,
      0,
      0,
      NULL,
      0,
      5,
      NULL,
      3,
      1,
      7,
      1,
      0,
      NULL,
      0,
      0.862647,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      0,
      5,
      1,
      4,
      NULL,
      NULL,
      NULL,
      5,
      5,
      NULL,
      5,
      1,
      2,
      4,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1.216313,
      0,
      ' 1-16-1977',
      283.817297,
      ' 1-16-2001',
      289,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      5,
      NULL,
      0.337623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.594715,
      0.872900,
      0,
      1.434378,
      NULL,
      0,
      1,
      0.012904,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      4.796730,
      7,
      4,
      1.033089,
      NULL,
      NULL,
      0,
      9,
      0.241417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932305,
      NULL,
      1,
      0.339601,
      0.103425,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      53.559956,
      24,
      NULL,
      NULL,
      0,
      3.218321,
      0,
      2,
      3,
      3,
      3,
      1,
      1,
      0,
      NULL,
      2,
      3,
      2.376791,
      NULL,
      1.591946,
      0,
      NULL,
      0.549209,
      0.404899,
      NULL,
      0.625889,
      0.255715,
      1,
      0.701725,
      NULL,
      NULL,
      NULL,
      3,
      3.668155,
      3.666104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      43,
      NULL,
      NULL,
      NULL,
      4,
      1.781115,
      3,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      1,
      29,
      117.996870,
      1,
      NULL,
      7.847119,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.788833,
      3.224782,
      1.332018,
      NULL,
      NULL,
      1,
      NULL,
      0.186727,
      2,
      1.920169,
      NULL,
      2.911556,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.557714,
      0,
      0,
      NULL,
      NULL,
      0.194255,
      NULL,
      NULL,
      8,
      0.304703,
      3.638376,
      NULL,
      1.193207,
      NULL,
      NULL,
      NULL,
      1.146483,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.787372,
      NULL,
      NULL,
      NULL,
      1,
      0.391054,
      1,
      1.600402,
      1.239536,
      NULL,
      1.801679,
      0.962208,
      0,
      0.472665,
      NULL,
      0,
      0.798462,
      1.176281,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      10.224157,
      2,
      NULL,
      1,
      0.047525,
      NULL,
      NULL,
      NULL,
      1.068326,
      NULL,
      NULL,
      NULL,
      1.798629,
      NULL,
      NULL,
      NULL,
      1.269789,
      1,
      NULL,
      2,
      1,
      2.986875,
      0.766607,
      1.325986,
      NULL,
      NULL,
      NULL,
      0.061420,
      NULL,
      1.089597,
      3,
      14.553566,
      0,
      5.978172,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574833,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.196359,
      NULL,
      NULL,
      1.560840,
      NULL,
      NULL,
      1.272249,
      NULL,
      NULL,
      2.405368,
      3.550650,
      NULL,
      2.026014,
      1,
      9.049682,
      2.018765,
      0.124001,
      2,
      NULL,
      5.329830,
      0,
      0.596606,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0.161435,
      1.781564,
      0.233161,
      0,
      2.245656,
      1,
      NULL,
      NULL,
      1.294469,
      NULL,
      2.688281,
      1,
      NULL,
      NULL,
      NULL,
      0.845625,
      NULL,
      NULL,
      NULL,
      1.180017,
      1,
      3.767888,
      NULL,
      1,
      3.466634,
      3.991583,
      7.857253,
      3.545720,
      2,
      1,
      1,
      1,
      NULL,
      1.239725,
      0.613614,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.553857,
      NULL,
      NULL,
      1.954366,
      NULL,
      NULL,
      0.838643,
      NULL,
      NULL,
      1.410050,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.698176,
      0.471094,
      1.188680,
      1.843282,
      NULL,
      NULL,
      0.660825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020871,
      NULL,
      NULL,
      NULL,
      2.265343,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.284224,
      NULL,
      NULL,
      NULL,
      1.881545,
      NULL,
      NULL,
      NULL,
      1.575116,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.231382,
      NULL,
      NULL,
      2.036851,
      0.777234,
      NULL,
      NULL,
      1.010254,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.627168,
      NULL,
      NULL,
      NULL,
      2.577930,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3.364940,
      0,
      1,
      3.926750,
      100,
      NULL,
      NULL,
      3.364041,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      48.842963,
      NULL,
      NULL,
      7,
      NULL,
      0.357910,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.693170,
      1.798255,
      NULL,
      0.306170,
      0,
      NULL,
      NULL,
      NULL,
      1.462849,
      1,
      0.235777,
      1,
      1.480669,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.974126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719555,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.834121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.907074,
      NULL,
      3.128221,
      NULL,
      57,
      NULL,
      1,
      NULL,
      0.409742,
      NULL,
      1.932147,
      NULL,
      2.262220,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.302385,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2,
      0,
      NULL,
      0,
      1.563993,
      3.758816,
      0.692736,
      1.803935,
      NULL,
      0.009088,
      1.707180,
      1,
      NULL,
      0,
      1.517244,
      0,
      1,
      0,
      0.419000,
      1.892070,
      0,
      0,
      0.698478,
      NULL,
      0.006990,
      1,
      1,
      0.294238,
      NULL,
      0,
      0.643011,
      0,
      0,
      0.804662,
      0.552412,
      3.095412,
      0.894808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.703241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.259646,
      0,
      1,
      1,
      1,
      0,
      NULL,
      2,
      6,
      1,
      NULL,
      NULL,
      41,
      26,
      3,
      1.370266,
      0,
      '11223',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


