set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '1234434',
      0,
      NULL,
      0,
      0,
      '2414',
      NULL,
      1,
      NULL,
      NULL,
      ' 2-12-1974',
      NULL,
      NULL,
      2,
      2,
      12,
      ' 0- 8-1995',
      2,
      NULL,
      339.376877,
      87.950374,
      0,
      NULL,
      NULL,
      ' 7-21-1977',
      NULL,
      NULL,
      NULL,
      2,
      1.638398,
      2.134615,
      0,
      0,
      0,
      9,
      8,
      11,
      6,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      0.521248,
      1.228839,
      NULL,
      NULL,
      0,
      0.143550,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      4,
      0,
      5,
      2,
      1,
      1,
      0,
      3,
      3,
      NULL,
      6,
      NULL,
      1,
      2,
      0,
      1.365781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      1.749370,
      NULL,
      NULL,
      2,
      0,
      2.802179,
      0,
      0,
      1.607071,
      1.714501,
      1,
      0.796364,
      3.242542,
      1.921947,
      1.441742,
      1,
      0,
      5,
      NULL,
      NULL,
      2,
      0.200701,
      1.730106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      4,
      NULL,
      1,
      1,
      1,
      2,
      1,
      5,
      NULL,
      2,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0.468903,
      3,
      5,
      1,
      0,
      NULL,
      5,
      0,
      5,
      0,
      2,
      4,
      0,
      3,
      0,
      1,
      5,
      4,
      1,
      4,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      0.857385,
      ' 9-20-1997',
      188.218684,
      ' 0-20-1987',
      137,
      NULL,
      0,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      2,
      0,
      1.060537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.716418,
      0.102325,
      3.441287,
      1,
      1.193655,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      7.052606,
      6.497066,
      7.691922,
      7,
      3.834109,
      0.015245,
      NULL,
      NULL,
      1,
      12,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962805,
      1.078066,
      1,
      1.134673,
      2,
      0.350905,
      1.457680,
      0,
      NULL,
      0.795273,
      0,
      15.730622,
      35.750224,
      13.200195,
      1,
      NULL,
      3,
      3,
      2,
      0,
      3,
      3,
      NULL,
      2,
      2,
      2,
      NULL,
      NULL,
      3.449872,
      0,
      1.498303,
      0,
      NULL,
      3.710472,
      1.876253,
      1,
      0.712698,
      NULL,
      1,
      1.328120,
      0.311173,
      0.941199,
      3,
      0.928533,
      NULL,
      1,
      6,
      NULL,
      5.926911,
      NULL,
      3,
      4,
      NULL,
      3.250286,
      0,
      1.803920,
      2.388217,
      0,
      14.153599,
      2,
      1,
      65,
      NULL,
      NULL,
      NULL,
      1,
      0.983328,
      1,
      '10014',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.550872,
      NULL,
      '',
      '',
      3.000954,
      5,
      90,
      1,
      NULL,
      35,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.053976,
      1,
      1.583963,
      0.108731,
      0.312709,
      3.675126,
      2.043928,
      1,
      0,
      1.809526,
      NULL,
      NULL,
      1.066169,
      NULL,
      NULL,
      1.968673,
      2.762947,
      NULL,
      1.484243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      7,
      0,
      0,
      1.586577,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.250332,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.824355,
      1.084889,
      1.209377,
      3.668227,
      1.045534,
      0,
      NULL,
      2.897763,
      NULL,
      2.173698,
      NULL,
      0.602536,
      1.132203,
      0.312540,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.642034,
      3.010765,
      5,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.978699,
      0,
      1,
      2,
      3.277737,
      1,
      2,
      0,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      7,
      NULL,
      0.687442,
      NULL,
      NULL,
      NULL,
      1.647014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.633785,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      0.710863,
      6.267923,
      1.653634,
      NULL,
      0.603879,
      NULL,
      7.925678,
      0.740398,
      NULL,
      NULL,
      3.429794,
      1.597048,
      NULL,
      1,
      1.515379,
      0.297920,
      NULL,
      NULL,
      1.026599,
      9,
      2.346410,
      4.721559,
      NULL,
      NULL,
      0.552456,
      0.534667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725601,
      1.800698,
      NULL,
      8.342268,
      0.316179,
      7.640299,
      9,
      5,
      1,
      NULL,
      NULL,
      0,
      0.973097,
      0,
      1.268357,
      1,
      1.228622,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.068526,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      3,
      2,
      1,
      0,
      2.001562,
      3,
      NULL,
      NULL,
      4.539590,
      1,
      NULL,
      NULL,
      2.889477,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205246,
      NULL,
      NULL,
      NULL,
      0.695890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      2.410478,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.183922,
      1.782605,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      6,
      0,
      3,
      3,
      36.059857,
      NULL,
      NULL,
      NULL,
      0.965739,
      3.046030,
      20,
      5,
      3.115263,
      63,
      4.337571,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702866,
      NULL,
      NULL,
      0.394901,
      0,
      0.836101,
      0,
      0.377744,
      NULL,
      1.634723,
      1,
      1.639673,
      0.664448,
      0.930167,
      1.056002,
      NULL,
      1,
      NULL,
      0.796033,
      1,
      1.318580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392116,
      1.459941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417304,
      3.865566,
      NULL,
      2.994856,
      NULL,
      2,
      NULL,
      19.895881,
      NULL,
      0.827996,
      NULL,
      1.737086,
      NULL,
      0,
      1.301813,
      0,
      3,
      34,
      0.487826,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      2,
      0.456762,
      3,
      5,
      0.495489,
      NULL,
      2,
      NULL,
      0,
      0.044541,
      1,
      3,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.499897,
      NULL,
      3,
      0,
      0.949940,
      0,
      0,
      2.508966,
      1.354230,
      0.995953,
      1.799589,
      0.021340,
      1.514362,
      0,
      0,
      0.427001,
      NULL,
      NULL,
      2,
      0.346026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.739590,
      NULL,
      1.397481,
      NULL,
      2,
      6,
      3,
      1,
      NULL,
      NULL,
      22.709494,
      NULL,
      NULL,
      0,
      5.517302,
      '23301',
      '21302',
      '',
      1,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


