set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9107982';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '0102040',
      3.552440,
      1,
      0,
      0,
      '2440',
      NULL,
      0.120860,
      3,
      27.959985,
      ' 5-11-1985',
      64,
      NULL,
      2,
      1,
      NULL,
      ' 5- 6-1987',
      99,
      3.021978,
      150,
      122.555968,
      2,
      NULL,
      NULL,
      ' 5- 3-1988',
      3.255071,
      1.390788,
      1,
      0,
      0,
      NULL,
      0,
      3.391567,
      NULL,
      NULL,
      NULL,
      4.423800,
      4,
      13.368749,
      6,
      3,
      18,
      3,
      4,
      1.104401,
      0.503368,
      0,
      NULL,
      1.665523,
      1,
      1.438724,
      0,
      1.407522,
      1.245318,
      0,
      0,
      0,
      2,
      3,
      1.826461,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      1.060596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.340207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.409076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      3,
      NULL,
      1,
      NULL,
      0.475936,
      0,
      1,
      0,
      1,
      1.307329,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0.465763,
      0.485164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.484823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      263,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019907,
      NULL,
      0,
      1,
      2.783660,
      7.140792,
      0.488193,
      NULL,
      NULL,
      NULL,
      0.118199,
      NULL,
      1.282665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008185,
      0,
      1,
      3,
      1.750412,
      NULL,
      0,
      0.225501,
      NULL,
      3.108692,
      1.222834,
      NULL,
      NULL,
      NULL,
      2,
      1.313082,
      2.755627,
      NULL,
      2,
      2,
      2,
      1,
      1,
      0,
      2,
      2,
      3,
      1.055742,
      0.921424,
      1.081274,
      4.761475,
      NULL,
      0.554135,
      0.899987,
      0.220977,
      0,
      4.632588,
      NULL,
      1,
      1,
      0,
      1,
      2,
      0,
      1.771306,
      NULL,
      11.118643,
      8.428616,
      5,
      0.962909,
      NULL,
      4,
      4,
      3,
      2.626329,
      3.735158,
      3,
      0.471695,
      15.979742,
      3,
      1.813989,
      49,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '12123',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '13342',
      NULL,
      '2323',
      1,
      NULL,
      416.826517,
      64,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.853247,
      NULL,
      NULL,
      0.040118,
      NULL,
      NULL,
      0.848732,
      NULL,
      NULL,
      1.238970,
      NULL,
      NULL,
      0.399828,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.904731,
      NULL,
      NULL,
      1.005152,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.764295,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242946,
      NULL,
      NULL,
      0.110860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.417592,
      NULL,
      NULL,
      1.202387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.016366,
      NULL,
      NULL,
      1.415756,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.722991,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.107727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.137860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.181018,
      NULL,
      NULL,
      0.018181,
      NULL,
      NULL,
      1.968114,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.249219,
      NULL,
      NULL,
      1.904938,
      NULL,
      NULL,
      1.479243,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.761300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.030703,
      1.205846,
      0,
      0.405518,
      1.236728,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.133456,
      2.474884,
      3.238700,
      0.559984,
      NULL,
      1,
      2.540270,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.105634,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554056,
      NULL,
      NULL,
      NULL,
      1.232028,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.072275,
      NULL,
      NULL,
      NULL,
      2.647874,
      NULL,
      NULL,
      NULL,
      2.006943,
      NULL,
      NULL,
      NULL,
      1.022680,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      1.179354,
      NULL,
      NULL,
      3.019948,
      NULL,
      9,
      0.304740,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.522016,
      21,
      70,
      1.658557,
      1.615102,
      0,
      0,
      0.848747,
      1.826873,
      0,
      1.243477,
      1,
      0.537170,
      0.234731,
      0.633449,
      NULL,
      1.432211,
      0.767262,
      1.277827,
      0.945368,
      0.605370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      5,
      NULL,
      0.877169,
      1.661540,
      1,
      0.564911,
      0,
      3,
      2,
      0,
      1.746020,
      0.167925,
      1,
      0.980061,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.024309,
      0,
      0,
      1.742701,
      NULL,
      1.627651,
      1.635847,
      NULL,
      1.110644,
      0,
      0,
      1,
      1.194411,
      NULL,
      0.672505,
      0,
      0.932458,
      0,
      0.354497,
      0.849328,
      0.816665,
      NULL,
      3.858658,
      3.699354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.521196,
      3,
      NULL,
      1.447156,
      NULL,
      3.128713,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.516603,
      1,
      NULL,
      NULL,
      1.875027,
      1,
      1,
      0.365867,
      1,
      2,
      NULL,
      NULL,
      1.090030,
      NULL,
      NULL,
      103,
      72.328726,
      NULL,
      1,
      NULL,
      NULL,
      '34441',
      '',
      NULL,
      '',
      '',
      '',
      4,
      '31103',
      '0340',
      '3320');
commit;
end;
/


