set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7938212';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '3241341',
      1,
      1,
      NULL,
      0,
      '2233',
      1,
      0.528449,
      2.111914,
      NULL,
      ' 9-25-1986',
      50,
      NULL,
      0,
      3.946358,
      0.778427,
      ' 3-14-1994',
      NULL,
      2,
      9,
      81.065747,
      0,
      ' 0-12-1996',
      ' 3-22-1988',
      ' 7-23-1991',
      1.888136,
      2,
      1,
      NULL,
      0,
      NULL,
      4,
      1,
      1,
      170.444536,
      8,
      11.446887,
      3.100675,
      32,
      13.735912,
      3,
      25.164992,
      3,
      3,
      NULL,
      0.578851,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0.217174,
      0.242309,
      1.157123,
      79,
      2,
      3,
      1,
      NULL,
      2,
      0,
      1,
      0,
      0,
      4,
      0,
      0,
      1,
      1,
      1,
      0,
      4,
      0,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      0.652086,
      NULL,
      NULL,
      0,
      NULL,
      1.510124,
      0.461493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.239056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      2,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1,
      1.450677,
      0,
      0,
      0,
      1,
      4.622092,
      NULL,
      3.112238,
      3,
      3,
      NULL,
      1,
      5,
      0,
      NULL,
      1,
      4,
      3,
      4,
      NULL,
      5,
      0,
      4,
      4,
      5,
      NULL,
      0,
      0,
      5,
      NULL,
      3,
      5,
      2,
      NULL,
      1.869898,
      NULL,
      NULL,
      NULL,
      690,
      3.089725,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      1.810711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.336479,
      0.958659,
      2.603633,
      1,
      1.663706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.109936,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.420064,
      NULL,
      NULL,
      1.905870,
      0.788476,
      0.279727,
      3,
      381.107974,
      0.728157,
      2,
      44.835466,
      1388.296265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      16,
      150,
      6.439055,
      157.537064,
      109,
      50.676061,
      42,
      0,
      0.234738,
      NULL,
      1.880366,
      1.679839,
      1,
      NULL,
      7,
      NULL,
      1,
      0.922992,
      8,
      5,
      0,
      1,
      5,
      NULL,
      NULL,
      7.246047,
      1,
      2.042917,
      1.247273,
      30.655645,
      0,
      1.141433,
      NULL,
      8,
      11,
      11.778253,
      NULL,
      0,
      NULL,
      '43214',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      1.453201,
      36,
      NULL,
      9,
      0,
      38.608708,
      20.022187,
      30.383141,
      NULL,
      1.769759,
      NULL,
      NULL,
      2.499503,
      2.454848,
      1.458483,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.640384,
      0.651433,
      0.976094,
      1.249782,
      2.102496,
      2.341173,
      NULL,
      3.756620,
      0,
      3.135919,
      2.487139,
      NULL,
      1.171791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2.449605,
      1,
      3.339723,
      0,
      5.149531,
      0,
      0.304131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.108099,
      1.615425,
      1,
      16.637519,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.566734,
      1.416433,
      1.920801,
      NULL,
      0.459829,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.270668,
      1,
      0.797682,
      3,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      4.350246,
      NULL,
      1.879353,
      0,
      NULL,
      NULL,
      NULL,
      5.434291,
      0,
      0,
      3,
      NULL,
      1.833780,
      1.736636,
      0.966266,
      NULL,
      1,
      NULL,
      NULL,
      1.094666,
      NULL,
      NULL,
      3,
      0,
      NULL,
      7.457139,
      1,
      0,
      3,
      2.602256,
      1.134527,
      3.752367,
      2,
      0,
      11,
      NULL,
      NULL,
      8,
      5,
      6,
      1,
      6.664593,
      4,
      0.125981,
      NULL,
      3,
      3,
      3,
      0,
      3,
      1,
      2.476117,
      1,
      2.224629,
      3,
      NULL,
      1,
      NULL,
      6.182924,
      NULL,
      NULL,
      0.127571,
      NULL,
      NULL,
      0.527047,
      NULL,
      1.753646,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1,
      0.367895,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      2.671022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311095,
      NULL,
      NULL,
      1.325363,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.006077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.100536,
      NULL,
      NULL,
      1.371483,
      0,
      NULL,
      1,
      0.307197,
      NULL,
      1,
      NULL,
      NULL,
      1.343113,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.784185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.673097,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.781833,
      NULL,
      NULL,
      3.853878,
      NULL,
      NULL,
      NULL,
      3.632554,
      1.785716,
      NULL,
      NULL,
      0.976420,
      2.610263,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.550173,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.990964,
      5,
      2,
      1,
      56,
      174,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.550036,
      1.729861,
      0,
      NULL,
      NULL,
      1.813247,
      NULL,
      NULL,
      1.127169,
      NULL,
      0.582934,
      90.958572,
      17.892629,
      1,
      2,
      0,
      1.008919,
      0,
      1,
      1.881115,
      1.897398,
      0.538752,
      NULL,
      NULL,
      2.191912,
      1.515429,
      1.481463,
      1,
      1.027160,
      NULL,
      NULL,
      NULL,
      0.880205,
      NULL,
      0.745667,
      NULL,
      0,
      NULL,
      1.420165,
      NULL,
      NULL,
      NULL,
      0.017150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089557,
      0.706341,
      0,
      0,
      NULL,
      0.152865,
      1.582479,
      2,
      0.095922,
      1,
      1.438423,
      1.818479,
      0,
      0,
      0.627973,
      1,
      0,
      NULL,
      0,
      3.390463,
      NULL,
      0,
      1,
      0.481558,
      1.813073,
      3.963414,
      NULL,
      0.485304,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.740274,
      1.056049,
      1.850394,
      0.110034,
      0.483718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.395520,
      NULL,
      NULL,
      1.128642,
      0.795231,
      2,
      NULL,
      4,
      2,
      NULL,
      1.281911,
      22,
      52,
      3,
      1,
      1.182123,
      '30112',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '20030',
      '',
      NULL);
commit;
end;
/


