set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      0.071867,
      1.273689,
      NULL,
      0,
      '1132',
      1,
      NULL,
      NULL,
      NULL,
      ' 5-11-1987',
      57,
      NULL,
      NULL,
      0.341580,
      NULL,
      ' 5-20-1976',
      4,
      0.232646,
      NULL,
      27.916341,
      0,
      ' 6-26-1991',
      ' 2-15-1981',
      ' 8-17-1974',
      NULL,
      0.137832,
      3,
      3.764367,
      0.652236,
      0,
      2,
      3.773286,
      NULL,
      NULL,
      NULL,
      10,
      5.363781,
      11.519627,
      NULL,
      4,
      NULL,
      4,
      0,
      4.703037,
      1.329631,
      0,
      0,
      0.666185,
      1.231705,
      0,
      1,
      1.247040,
      1,
      1.022066,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      2,
      1,
      NULL,
      2,
      NULL,
      0,
      1,
      6,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.847526,
      0.583624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1.627122,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      2,
      0,
      0,
      0,
      NULL,
      1,
      4,
      4,
      0,
      NULL,
      1,
      NULL,
      5,
      NULL,
      1,
      1,
      0,
      1,
      3,
      ' 4- 0-2000',
      33.043134,
      ' 4- 1-2000',
      NULL,
      1,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.546244,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.051994,
      1.436695,
      3.916827,
      1.120185,
      1.636596,
      0,
      NULL,
      5,
      0,
      0.389703,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.288910,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.260450,
      NULL,
      1.102965,
      0,
      16,
      0.409877,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      2,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      2.011288,
      0,
      0.898045,
      0,
      1.332489,
      1,
      NULL,
      1.988773,
      0,
      0.709028,
      1,
      NULL,
      0,
      NULL,
      4,
      0,
      1,
      8,
      7,
      6,
      NULL,
      5.444530,
      2.250931,
      NULL,
      NULL,
      0.636275,
      3,
      1.630934,
      68.663876,
      3,
      3,
      NULL,
      1,
      56,
      26,
      4,
      2,
      4,
      '21343',
      '34210',
      NULL,
      1.326357,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.192592,
      0.154224,
      1,
      1.421744,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.248432,
      NULL,
      NULL,
      0.167679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      325,
      22,
      NULL,
      NULL,
      1.217880,
      0.366607,
      1,
      1,
      0.478304,
      NULL,
      0.562339,
      1,
      1.846997,
      0,
      1,
      0.344354,
      0.657762,
      0,
      2.228140,
      1,
      0.790085,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.581370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.347586,
      1.836087,
      1.146709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.437571,
      1.580992,
      NULL,
      NULL,
      1.772361,
      1.961968,
      NULL,
      1,
      NULL,
      1,
      1,
      0.693748,
      0.643152,
      2.607420,
      NULL,
      1.406831,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.581241,
      NULL,
      0.319592,
      1.772180,
      1.901793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.710534,
      NULL,
      NULL,
      NULL,
      1.253740,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763087,
      0.645816,
      NULL,
      NULL,
      3,
      NULL,
      365,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0.350045,
      5.978335,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      0,
      1.110381,
      0,
      NULL,
      6.947957,
      2.944146,
      2,
      NULL,
      NULL,
      0.801875,
      1.912387,
      0,
      NULL,
      NULL,
      0.390624,
      1.437695,
      NULL,
      0.017528,
      1.249257,
      1,
      0.124786,
      1,
      1.334410,
      1.833212,
      NULL,
      0.255291,
      1.127876,
      0.208968,
      1.739429,
      NULL,
      NULL,
      1.703850,
      1.773172,
      1,
      0,
      2,
      2,
      3.227326,
      3,
      1.848374,
      1,
      1,
      3.555936,
      0.496804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961637,
      NULL,
      NULL,
      1.629307,
      0.857050,
      0,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      31,
      NULL,
      0,
      2.706924,
      4,
      '13204',
      '33022',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


