set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8404232';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '4323220',
      2.426392,
      1.923822,
      0,
      NULL,
      '1300',
      NULL,
      0,
      NULL,
      NULL,
      ' 1- 9-2001',
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      32.622679,
      2.781693,
      296.686258,
      139.158533,
      2,
      '11-14-1993',
      ' 9-20-1979',
      ' 4-11-1984',
      3,
      NULL,
      0,
      1.919765,
      1.627122,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      9,
      6.009367,
      13.873482,
      0,
      1,
      22.313848,
      2,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      1.427060,
      2,
      1,
      NULL,
      4,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      5.991406,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      5,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      2,
      1,
      0,
      1,
      3.406552,
      ' 3-14-1976',
      125.657106,
      ' 2-14-1979',
      0,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      1,
      NULL,
      1,
      3,
      0,
      5,
      1,
      5,
      3,
      4,
      0,
      0.743449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.598144,
      3.065355,
      3.229259,
      3.260494,
      1.047959,
      6.134631,
      NULL,
      NULL,
      0.887965,
      0.994029,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.701252,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.129692,
      0,
      1,
      0,
      0.563581,
      NULL,
      3,
      NULL,
      NULL,
      0.908756,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2,
      1,
      0,
      1.491737,
      NULL,
      0,
      0.775949,
      0,
      NULL,
      NULL,
      0.497080,
      1.081609,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.459690,
      11,
      8,
      0.886154,
      2.943244,
      10.086709,
      NULL,
      NULL,
      1,
      6.742502,
      0,
      2,
      NULL,
      11,
      1,
      0.715443,
      NULL,
      58,
      42,
      51,
      5,
      NULL,
      1.387639,
      '14340',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      2.128266,
      39,
      25.558580,
      0.267194,
      NULL,
      37.859361,
      3,
      1.646495,
      1,
      0.809944,
      NULL,
      1,
      1.086706,
      NULL,
      NULL,
      1.021340,
      NULL,
      NULL,
      0.240751,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.119384,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.140854,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.962324,
      NULL,
      NULL,
      1.271545,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.030903,
      0,
      3.932861,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.508430,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.251174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245194,
      NULL,
      NULL,
      0.343803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624330,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662531,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.697262,
      NULL,
      NULL,
      1.914002,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370119,
      0,
      1,
      NULL,
      NULL,
      0.320306,
      NULL,
      NULL,
      0.784857,
      0,
      NULL,
      1,
      1,
      NULL,
      2,
      1.545628,
      1.422088,
      3,
      0.526154,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.858065,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.107261,
      0,
      1,
      1,
      NULL,
      NULL,
      3.324659,
      2,
      0,
      1.027239,
      0.867831,
      NULL,
      NULL,
      1,
      0.154093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.041633,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.993393,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.701815,
      2,
      0.605070,
      NULL,
      0.884476,
      NULL,
      0,
      7.439478,
      NULL,
      0,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.836284,
      NULL,
      0.711704,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.250474,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.938686,
      NULL,
      1,
      NULL,
      0.216739,
      NULL,
      0.409909,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3.536688,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.199851,
      NULL,
      0.311506,
      NULL,
      NULL,
      NULL,
      0.288916,
      NULL,
      1.039430,
      NULL,
      0,
      NULL,
      6,
      NULL,
      4.634839,
      NULL,
      1,
      NULL,
      2.434583,
      2.917374,
      2,
      4,
      NULL,
      0.815289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.575835,
      NULL,
      NULL,
      1.982361,
      NULL,
      NULL,
      1.229281,
      NULL,
      NULL,
      1,
      NULL,
      0.963340,
      1057,
      1.592136,
      NULL,
      0,
      0.953514,
      1,
      NULL,
      0,
      0,
      0.655993,
      NULL,
      0,
      1.996116,
      NULL,
      1,
      1.471665,
      0,
      NULL,
      1.782928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      5.101174,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.114999,
      NULL,
      NULL,
      NULL,
      0.090603,
      1.687205,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.137526,
      NULL,
      2,
      NULL,
      NULL,
      1.560682,
      1.142616,
      NULL,
      1,
      1.111947,
      NULL,
      NULL,
      1.507024,
      NULL,
      0,
      NULL,
      NULL,
      1.324700,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.190030,
      0.955215,
      0.694589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.586005,
      NULL,
      3,
      1,
      4,
      NULL,
      NULL,
      NULL,
      72.773069,
      12,
      3,
      1.086757,
      3.841490,
      '00142',
      '44312',
      NULL,
      1.593989,
      '',
      '',
      '',
      1.367439,
      '',
      '',
      '');
commit;
end;
/


