set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8404232';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      1.294148,
      1,
      3,
      0,
      '3202',
      1.572122,
      1,
      NULL,
      NULL,
      '11-17-1982',
      17,
      NULL,
      1,
      1,
      1,
      ' 9- 1-1978',
      4,
      1,
      44.103000,
      41,
      1,
      ' 5-27-1984',
      ' 8- 5-1983',
      ' 6-13-1975',
      NULL,
      0.749956,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      8.414921,
      7,
      20.839133,
      NULL,
      NULL,
      9.648134,
      NULL,
      3,
      2.918185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.825126,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0.243249,
      NULL,
      NULL,
      1,
      1,
      0,
      0.278613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.939669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      4,
      NULL,
      3,
      NULL,
      1,
      1,
      1,
      5,
      5,
      1,
      0,
      5,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0.715601,
      1,
      5,
      3,
      0,
      3,
      4,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      4,
      3,
      2,
      2,
      1,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      19,
      ' 7- 3-1975',
      20.293512,
      1.994954,
      0,
      1,
      1,
      3,
      NULL,
      5,
      NULL,
      2,
      1,
      0,
      2,
      0,
      0,
      NULL,
      0,
      3,
      0.750257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.372312,
      NULL,
      4,
      0,
      3,
      1.894646,
      0,
      3,
      1.797203,
      1,
      1.853176,
      7,
      2.617633,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.490106,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0.195333,
      0.436974,
      2.537589,
      28,
      1,
      1.258864,
      NULL,
      NULL,
      NULL,
      2,
      0.934183,
      2.236298,
      3,
      2,
      2,
      2,
      1,
      3,
      NULL,
      0,
      2,
      1,
      3.792753,
      0,
      1.777401,
      1,
      1.762603,
      1.282087,
      1,
      1,
      0.182508,
      0,
      NULL,
      0,
      0.447297,
      0.552816,
      0,
      NULL,
      NULL,
      3.932502,
      1.703425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      24,
      2,
      56,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      0.512882,
      '',
      '',
      '',
      NULL,
      10.952697,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.118513,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.862645,
      NULL,
      NULL,
      1.722391,
      NULL,
      NULL,
      0.248667,
      NULL,
      NULL,
      0.491696,
      NULL,
      NULL,
      0.357212,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.997500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859843,
      NULL,
      NULL,
      1.892871,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.898221,
      NULL,
      NULL,
      1.096435,
      NULL,
      NULL,
      0.896066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.263166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.830748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.786797,
      NULL,
      NULL,
      0.651792,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.890419,
      1,
      NULL,
      NULL,
      1,
      0.442106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420095,
      NULL,
      NULL,
      0.683675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339835,
      NULL,
      NULL,
      1.431532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.044786,
      NULL,
      1.520738,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.732179,
      3,
      NULL,
      1,
      1,
      0.512590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.590497,
      NULL,
      0,
      NULL,
      0.224114,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477289,
      NULL,
      NULL,
      0.449445,
      NULL,
      NULL,
      0.296188,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.578557,
      NULL,
      0.995580,
      111,
      1,
      0.866813,
      0.248427,
      0.235682,
      1,
      1.917934,
      0.419785,
      1.058413,
      0,
      0,
      0.571371,
      1.583856,
      1.578166,
      0,
      0,
      0,
      NULL,
      0.037425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      3.378088,
      0,
      3.781417,
      2,
      NULL,
      1.601355,
      3.917847,
      1.521726,
      1.606885,
      0.370591,
      NULL,
      1.499696,
      0.398766,
      NULL,
      1.979506,
      3.169749,
      NULL,
      1.420737,
      0.266533,
      NULL,
      1,
      0.304607,
      NULL,
      NULL,
      2.403650,
      NULL,
      0.231879,
      1.333888,
      NULL,
      NULL,
      0,
      NULL,
      0.027990,
      0.242275,
      NULL,
      1,
      1,
      NULL,
      0,
      0.397047,
      NULL,
      1,
      0,
      3,
      1.884320,
      NULL,
      NULL,
      NULL,
      1.386229,
      NULL,
      1.360325,
      NULL,
      0.719797,
      NULL,
      0.129708,
      NULL,
      2.626578,
      NULL,
      3.314342,
      NULL,
      1,
      NULL,
      1.199819,
      NULL,
      2,
      NULL,
      1.716350,
      NULL,
      NULL,
      NULL,
      33.083518,
      1.916532,
      NULL,
      2.709614,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.482221,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.071738,
      NULL,
      1.985572,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      33.288162,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.744859,
      NULL,
      NULL,
      NULL,
      11.485355,
      4,
      0.003278,
      0.158702,
      '04310',
      '10423',
      '',
      1,
      NULL,
      NULL,
      '',
      1.191889,
      '',
      '',
      NULL);
commit;
end;
/


