set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8404232';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '1022101',
      3,
      0,
      4,
      3,
      NULL,
      1.283387,
      0,
      NULL,
      NULL,
      ' 9- 8-1982',
      2,
      NULL,
      1,
      NULL,
      6,
      NULL,
      16,
      1.837059,
      355.585799,
      NULL,
      2,
      ' 7-13-1999',
      '10- 5-1995',
      ' 2- 8-1998',
      3,
      1,
      0.941397,
      1.654859,
      1.056230,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      1,
      NULL,
      NULL,
      31,
      1,
      0,
      6.394165,
      3.359679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.358370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      5.034346,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      4,
      0,
      3,
      0,
      2,
      3,
      3,
      NULL,
      1,
      0,
      0,
      0,
      0.072057,
      0,
      ' 3-22-1987',
      592,
      ' 3-24-1996',
      NULL,
      1.537731,
      2,
      1,
      2,
      2,
      NULL,
      0,
      1,
      1,
      0,
      0,
      4,
      0,
      NULL,
      3,
      0,
      NULL,
      3.110909,
      0,
      4.704948,
      1.057949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.887090,
      0.517104,
      NULL,
      3,
      2,
      NULL,
      0.203665,
      1.832634,
      0,
      2,
      NULL,
      1.943696,
      2.517224,
      1.008920,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.090445,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.242659,
      1.474115,
      3,
      27,
      0,
      0.341783,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      2,
      2,
      1,
      1,
      0,
      NULL,
      1.385713,
      1.518615,
      0.242217,
      0,
      0.130905,
      1.205952,
      NULL,
      1,
      0.371056,
      1,
      NULL,
      1.046933,
      NULL,
      NULL,
      1.812611,
      1,
      0,
      NULL,
      0,
      0,
      9.849333,
      2.497596,
      5.433547,
      5,
      2.233884,
      2,
      0.583300,
      2,
      NULL,
      0,
      1.081378,
      NULL,
      2,
      0.360909,
      NULL,
      35,
      11,
      NULL,
      2,
      1,
      3.165069,
      '01234',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      11,
      NULL,
      0.323422,
      1.265033,
      20,
      NULL,
      NULL,
      NULL,
      3.715531,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245531,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114648,
      NULL,
      NULL,
      0.692072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.706960,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.370525,
      3,
      1.370665,
      2,
      1,
      NULL,
      NULL,
      0.357916,
      NULL,
      NULL,
      0.079592,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974905,
      NULL,
      NULL,
      0.938508,
      NULL,
      NULL,
      1.079653,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034105,
      NULL,
      NULL,
      0.680296,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.126506,
      NULL,
      NULL,
      1.632584,
      NULL,
      NULL,
      1.924891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693423,
      NULL,
      NULL,
      0.154374,
      NULL,
      NULL,
      1.698446,
      NULL,
      NULL,
      1.809095,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.295208,
      NULL,
      NULL,
      1.763058,
      0.699972,
      0,
      NULL,
      3,
      1,
      5,
      0.847109,
      NULL,
      0,
      NULL,
      NULL,
      0.920808,
      1,
      0.283276,
      1,
      1.289024,
      0.469441,
      0,
      1.884602,
      NULL,
      NULL,
      NULL,
      1,
      3.026921,
      NULL,
      1.067782,
      3.610322,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.227106,
      NULL,
      NULL,
      4,
      4.934187,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.469957,
      1.952717,
      NULL,
      1,
      0.779493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.016847,
      1.589133,
      0.908450,
      1.065727,
      0.472657,
      1.393079,
      NULL,
      NULL,
      NULL,
      NULL,
      8.383337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169517,
      NULL,
      NULL,
      NULL,
      3.779388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024482,
      NULL,
      NULL,
      NULL,
      0.754595,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.431227,
      NULL,
      NULL,
      NULL,
      3.085993,
      NULL,
      NULL,
      NULL,
      2.313255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823491,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.028520,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      2.538260,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      1.337001,
      NULL,
      NULL,
      NULL,
      1.170670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      817.226842,
      NULL,
      1,
      1,
      1.559259,
      0.065574,
      0.677031,
      1.823220,
      NULL,
      NULL,
      0,
      1.865947,
      NULL,
      NULL,
      0.965542,
      NULL,
      0,
      0.586889,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      7.099793,
      2,
      2.837580,
      NULL,
      3,
      NULL,
      NULL,
      2.071607,
      1.546464,
      1.361197,
      NULL,
      NULL,
      1,
      1.157715,
      NULL,
      1.633178,
      1.827144,
      NULL,
      NULL,
      1,
      NULL,
      1.799757,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.578713,
      NULL,
      1.290160,
      1.138850,
      NULL,
      1,
      1.929357,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.642561,
      NULL,
      3.695428,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.681011,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.108068,
      NULL,
      3.847017,
      NULL,
      1.820926,
      NULL,
      NULL,
      NULL,
      38.258634,
      2,
      NULL,
      3,
      2.732937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058649,
      NULL,
      3.077446,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.172378,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.875277,
      3.046426,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.359298,
      NULL,
      2,
      NULL,
      5,
      0.996221,
      NULL,
      NULL,
      111,
      18.319467,
      NULL,
      0.995384,
      4.347605,
      '22400',
      NULL,
      NULL,
      0.647783,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


